/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.export;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.PostFinalizePhase;
import org.jboss.windup.config.query.WindupConfigurationQuery;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.util.ZipUtil;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(afterIDs={"DeleteWorkDirsAtTheEndRuleProvider"}, description="Creates a ZIP file containing all the files in the output path. Use --exportZipReport to enable it.", phase=PostFinalizePhase.class)
public class ExportZipReportRuleProvider
extends AbstractRuleProvider {
    public static final String ZIP_REPORTS_NAME = "reports.zip";

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().when((Condition)WindupConfigurationQuery.hasOption((String)"exportZipReport", (Object)true).as("discard")).perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                WindupConfigurationModel windupConfiguration = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
                try {
                    FileModel outputFolderToZip = windupConfiguration.getOutputPath();
                    ZipUtil.zipFolder((Path)outputFolderToZip.asFile().toPath(), (String)outputFolderToZip.getFilePath(), (String)ExportZipReportRuleProvider.ZIP_REPORTS_NAME, List.of("graph", "logs"));
                }
                catch (IOException e) {
                    throw new WindupException((Throwable)e);
                }
            }

            public String toString() {
                return "Create a ZIP file to collect the reports";
            }
        });
    }
}

