/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.export;

import com.opencsv.CSVWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.Iteration;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.DependentPhase;
import org.jboss.windup.config.phase.PostReportGenerationPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.LinkModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.graph.traversal.OnlyOnceTraversalStrategy;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.graph.traversal.TraversalStrategy;
import org.jboss.windup.reporting.category.IssueCategoryModel;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.jboss.windup.reporting.model.TechnologyTagModel;
import org.jboss.windup.reporting.rules.AttachApplicationReportsToIndexRuleProvider;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.InlineHintService;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.util.PathUtil;
import org.jboss.windup.util.ThemeProvider;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=DependentPhase.class, after={PostReportGenerationPhase.class}, before={AttachApplicationReportsToIndexRuleProvider.class}, haltOnException=true)
public class ExportCSVFileRuleProvider
extends AbstractRuleProvider {
    private static final Logger LOG = Logger.getLogger(ExportCSVFileRuleProvider.class.getCanonicalName());
    private static final String MERGED_CSV_FILENAME = "AllIssues";
    private static final String APP_FILE_TECH_CSV_FILENAME = "ApplicationFileTechnologies";

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(WindupConfigurationModel.class).withProperty("csv", (Object)true)).perform((Operation)Iteration.over((String)"default").perform((Operation)new ExportCSVReportOperation()).endIteration());
    }

    private final class ExportCSVReportOperation
    extends AbstractIterationOperation<WindupConfigurationModel> {
        private ExportCSVReportOperation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(GraphRewrite event, EvaluationContext context, WindupConfigurationModel config) {
            InlineHintService hintService = new InlineHintService(event.getGraphContext());
            String outputFolderPath = config.getOutputPath().getFilePath() + File.separator;
            ClassificationService classificationService = new ClassificationService(event.getGraphContext());
            HashMap<String, CSVWriter> projectToFile = new HashMap<String, CSVWriter>();
            List hints = hintService.findAll();
            List classifications = classificationService.findAll();
            ArrayList reportableEvents = new ArrayList();
            reportableEvents.addAll(hints);
            reportableEvents.addAll(classifications);
            try {
                reportableEvents.stream().sorted((o1, o2) -> ((Comparator)(o11, o21) -> {
                    IssueCategoryModel c1 = o11.getIssueCategory();
                    IssueCategoryModel c2 = o21.getIssueCategory();
                    IssueCategoryModel.IssueSummaryPriorityComparator comparator = new IssueCategoryModel.IssueSummaryPriorityComparator();
                    return comparator.compare(c1, c2);
                }).thenComparing(((Comparator)(o112, o212) -> {
                    int i1 = o112.getEffort();
                    int i2 = o212.getEffort();
                    return Integer.compare(i1, i2);
                }).reversed()).compare(o1, o2)).forEachOrdered(reportableEvent -> this.writeRecordForHint(reportableEvent, projectToFile, outputFolderPath, config));
                this.produceApplicationListCSV(event, projectToFile, outputFolderPath);
            }
            finally {
                for (CSVWriter csvWriter : projectToFile.values()) {
                    try {
                        csvWriter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        private void writeRecordForHint(Object reportableEvent, Map<String, CSVWriter> projectToFile, String outputFolderPath, WindupConfigurationModel config) {
            if (reportableEvent instanceof InlineHintModel) {
                boolean isUserRulesFile;
                InlineHintModel hint = (InlineHintModel)reportableEvent;
                if (hint.getFile().getProjectModel() == null && (isUserRulesFile = config.getUserRulesPaths().stream().anyMatch(file -> config.getUserRulesPaths().stream().anyMatch(userRuleFile -> file.getFileName().equals(userRuleFile.getFileName()))))) {
                    return;
                }
                String links = this.buildLinkString(hint.getLinks());
                String ruleId = hint.getRuleID() != null ? hint.getRuleID() : "";
                String title = hint.getTitle() != null ? hint.getTitle() : "";
                String description = hint.getDescription() != null ? hint.getDescription() : "";
                String projectNameString = "";
                String fileName = "";
                String filePath = "";
                if (hint.getFile() != null) {
                    if (hint.getFile().getProjectModel() != null) {
                        projectNameString = hint.getFile().getProjectModel().getName();
                    }
                    fileName = hint.getFile().getFileName();
                    filePath = hint.getFile().getFilePath();
                }
                String[] strings = new String[]{ruleId, hint.getIssueCategory().getCategoryID(), title, description, links, projectNameString, fileName, filePath, String.valueOf(hint.getLineNumber()), String.valueOf(hint.getEffort())};
                ProjectModel parentRootProjectModel = hint.getFile().getProjectModel().getRootProjectModel();
                this.writeCsvRecordForProject(projectToFile, outputFolderPath, parentRootProjectModel, strings, null, false);
            }
            if (reportableEvent instanceof ClassificationModel) {
                ClassificationModel classification = (ClassificationModel)reportableEvent;
                for (FileModel fileModel : classification.getFileModels()) {
                    String links = this.buildLinkString(classification.getLinks());
                    String ruleId = classification.getRuleID() != null ? classification.getRuleID() : "";
                    String classificationText = classification.getClassification() != null ? classification.getClassification() : "";
                    String description = classification.getDescription() != null ? classification.getDescription() : "";
                    String projectNameString = "";
                    if (fileModel.getProjectModel() != null) {
                        projectNameString = fileModel.getProjectModel().getName();
                    }
                    String fileName = fileModel.getFileName();
                    String filePath = fileModel.getFilePath();
                    String[] strings = new String[]{ruleId, classification.getIssueCategory().getCategoryID(), classificationText, description, links, projectNameString, fileName, filePath, "N/A", String.valueOf(classification.getEffort())};
                    ProjectModel parentRootProjectModel = fileModel.getProjectModel().getRootProjectModel();
                    this.writeCsvRecordForProject(projectToFile, outputFolderPath, parentRootProjectModel, strings, null, false);
                }
            }
        }

        private String buildLinkString(Iterable<LinkModel> links) {
            StringBuilder linksString = new StringBuilder();
            for (LinkModel linkModel : links) {
                linksString.append("[");
                linksString.append(linkModel.getLink()).append(",");
                linksString.append(linkModel.getDescription());
                linksString.append("]");
            }
            return linksString.toString();
        }

        private void produceApplicationListCSV(GraphRewrite event, Map<String, CSVWriter> projectToFile, String outputFolderPath) {
            ArrayList<String> headerFieldsList = new ArrayList<String>();
            headerFieldsList.add("App Name");
            TechnologyTagService techTagService = new TechnologyTagService(event.getGraphContext());
            List<TechnologyTagModel> masterTagList = techTagService.findAll().stream().filter(tag -> !tag.getName().equals("Decompiled Java File")).sorted((o1, o2) -> {
                String n1 = o1.getName();
                String n2 = o2.getName();
                return n1.compareToIgnoreCase(n2);
            }).collect(Collectors.toList());
            masterTagList.forEach(masterTag -> headerFieldsList.add(masterTag.getName()));
            String[] headerStringsToWrite = headerFieldsList.toArray(new String[0]);
            WindupConfigurationModel configuration = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
            configuration.getInputPaths().forEach(app -> {
                ProjectModelTraversal traversal = new ProjectModelTraversal(app.getProjectModel(), (TraversalStrategy)new OnlyOnceTraversalStrategy());
                ArrayList tagsForApp = new ArrayList();
                ArrayList<TechnologyTagModel> structuredTagsForApp = new ArrayList<TechnologyTagModel>();
                ((TreeSet)techTagService.findTechnologyTagsForProject(traversal)).stream().filter(tag -> !tag.getName().equals("Decompiled Java File")).sorted((o1, o2) -> {
                    String n1 = o1.getName();
                    String n2 = o2.getName();
                    return n1.compareToIgnoreCase(n2);
                }).forEachOrdered(tagsForApp::add);
                masterTagList.forEach(masterTag -> {
                    if (tagsForApp.contains(masterTag)) {
                        structuredTagsForApp.add((TechnologyTagModel)masterTag);
                    } else {
                        structuredTagsForApp.add(null);
                    }
                    headerFieldsList.add((String)(masterTag == null ? "" : masterTag.getName() + (String)(masterTag.getVersion() == null ? "" : " " + masterTag.getVersion())));
                });
                ArrayList<String> appNameAndTagNames = new ArrayList<String>();
                appNameAndTagNames.add(app.getProjectModel().getRootFileModel().getFileName());
                structuredTagsForApp.forEach(tag -> appNameAndTagNames.add((String)(tag == null ? "" : tag.getName() + (String)(tag.getVersion() == null ? "" : " " + tag.getVersion()))));
                String[] stringsToWrite = appNameAndTagNames.toArray(new String[0]);
                this.writeCsvRecordForProject(projectToFile, outputFolderPath, app.getProjectModel(), stringsToWrite, headerStringsToWrite, true);
            });
        }

        private void writeCsvRecordForProject(Map<String, CSVWriter> projectToFile, String outputFolderPath, ProjectModel projectModel, String[] line, String[] dynamicHeaderLine, boolean isLineForAppTagFile) {
            String[] headerLine;
            if (!projectToFile.containsKey(ExportCSVFileRuleProvider.MERGED_CSV_FILENAME)) {
                headerLine = new String[]{"Rule Id", "Issue Category", "Title", "Description", "Links", "Application", "File Name", "File Path", "Line", "Story points", "Parent Application"};
                String mergedFilename = PathUtil.cleanFileName((String)ExportCSVFileRuleProvider.MERGED_CSV_FILENAME) + ".csv";
                CSVWriter mergedFileWriter = this.initCSVWriter(outputFolderPath + mergedFilename, headerLine);
                projectToFile.put(ExportCSVFileRuleProvider.MERGED_CSV_FILENAME, mergedFileWriter);
            }
            if (!projectToFile.containsKey(projectModel.getName())) {
                headerLine = new String[]{"Rule Id", "Issue Category", "Title", "Description", "Links", "Application", "File Name", "File Path", "Line", "Story points"};
                String filename = PathUtil.cleanFileName((String)projectModel.getRootFileModel().getFileName()) + ".csv";
                CSVWriter writer = this.initCSVWriter(outputFolderPath + filename, headerLine);
                projectToFile.put(projectModel.getName(), writer);
                LOG.info("Setting csv filename to: " + filename + " for id: " + projectModel.getId());
                projectModel.setCsvFilename(filename);
            }
            if (!projectToFile.containsKey(ExportCSVFileRuleProvider.APP_FILE_TECH_CSV_FILENAME) && isLineForAppTagFile) {
                headerLine = dynamicHeaderLine;
                String appFileTechFilename = PathUtil.cleanFileName((String)ExportCSVFileRuleProvider.APP_FILE_TECH_CSV_FILENAME) + ".csv";
                CSVWriter appFileTechWriter = this.initCSVWriter(outputFolderPath + appFileTechFilename, headerLine);
                projectToFile.put(ExportCSVFileRuleProvider.APP_FILE_TECH_CSV_FILENAME, appFileTechWriter);
            }
            if (isLineForAppTagFile) {
                projectToFile.get(ExportCSVFileRuleProvider.APP_FILE_TECH_CSV_FILENAME).writeNext(line);
            } else {
                projectToFile.get(projectModel.getName()).writeNext(line);
                ArrayList<String> mergedList = new ArrayList<String>(Arrays.stream(line).collect(Collectors.toList()));
                mergedList.add(projectModel.getRootFileModel().asFile().getName());
                String[] mergedLine = new String[mergedList.size()];
                projectToFile.get(ExportCSVFileRuleProvider.MERGED_CSV_FILENAME).writeNext(mergedList.toArray(mergedLine));
            }
        }

        private CSVWriter initCSVWriter(String path, String[] headerLine) {
            try {
                CSVWriter writer = new CSVWriter((Writer)new FileWriter(path), ',');
                writer.writeNext(headerLine);
                return writer;
            }
            catch (IOException e) {
                System.err.println(ThemeProvider.getInstance().getTheme().getBrandNameAcronym() + " was not able to create a CSV file " + path + ". CSV Export will not be generated.");
                throw new WindupException("Unable to create file " + path, (Throwable)e);
            }
        }
    }
}

