/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.files;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.metadata.RuleMetadataType;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.graph.GraphTypeManager;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.rules.files.FileMapping;
import org.jboss.windup.rules.files.FileMappingTo;
import org.jboss.windup.util.exception.WindupException;
import org.jboss.windup.util.xml.XmlUtil;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.Context;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@NamespaceElementHandler(elementName="file-mapping", namespace="http://windup.jboss.org/schema/jboss-ruleset")
public class FileMappingHandler
implements ElementHandler<Void> {
    protected static final String ELEM_NAME = "file-mapping";
    private static final String FROM = "from";
    private static final String TO = "to";
    private static final String ON_PARSE_ERROR = "onParseError";
    @Inject
    private GraphTypeManager typeManager;
    private static final String ATTR_PARSE_IGNORE = "ignore";

    public Void processElement(ParserContext context, Element element) {
        FileMappingTo rule;
        List<String> acceptableValues;
        String id = JOOX.$((Element)element).attr("id");
        String from = JOOX.$((Element)element).attr(FROM);
        String to = JOOX.$((Element)element).attr(TO);
        String onParseError = JOOX.$((Element)element).attr(ON_PARSE_ERROR);
        if (StringUtils.isBlank((CharSequence)from)) {
            throw new WindupException("The 'file-mapping' element must have a non-empty 'from' attribute");
        }
        if (StringUtils.isBlank((CharSequence)to)) {
            throw new WindupException("The 'file-mapping' element must have a non-empty 'to' attribute");
        }
        if (!StringUtils.isBlank((CharSequence)onParseError) && !(acceptableValues = Arrays.asList(ATTR_PARSE_IGNORE, "warn", "warning")).contains(onParseError)) {
            throw new WindupException("The '<file-mapping>' attribute 'onParseError' must contain one of: " + StringUtils.join(acceptableValues, (String)", "));
        }
        ArrayList types = new ArrayList();
        List<String> typeNames = Arrays.asList(to.trim().split("\\s*,\\s*"));
        for (String name : typeNames) {
            ArrayList<Class> matchingTypes = new ArrayList<Class>();
            for (Class modelType : this.typeManager.getRegisteredTypes()) {
                if (!modelType.getName().equals(name) && !modelType.getSimpleName().equals(name + ".class") && !modelType.getSimpleName().equals(name + "Model") && !modelType.getSimpleName().equals(name)) continue;
                matchingTypes.add(modelType);
            }
            if (matchingTypes.isEmpty()) {
                throw new WindupException("A 'file-mapping' element specifies a file mapping type [" + name + "] that could not be found in any installed addons.");
            }
            if (matchingTypes.size() > 1) {
                throw new WindupException("A 'file-mapping' element specifies a file mapping type [" + name + "] that matched multiple file types. Please select one of matches and update the configuration to use the fully qualified name: [" + ((Object)matchingTypes).toString().replaceAll(",", System.lineSeparator()) + "]");
            }
            types.addAll(matchingTypes);
        }
        FileMappingTo mappingTo = FileMapping.from((String)from).to(types.toArray(new Class[types.size()])).onParseError(FileModel.OnParseError.IGNORE);
        Object object = rule = StringUtils.isNotBlank((CharSequence)id) ? mappingTo.withId(id) : mappingTo;
        if (rule instanceof Context) {
            ((Context)rule).put((Object)RuleMetadataType.RULE_XML, (Object)XmlUtil.nodeToString((Node)element));
        }
        context.getBuilder().addRule((Rule)rule);
        return null;
    }
}

