/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.archives.listener;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphListener;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.IgnoredArchiveModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.ArchiveService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.rules.apps.java.archives.identify.ArchiveIdentificationService;
import org.jboss.windup.rules.apps.java.archives.model.ArchiveCoordinateModel;
import org.jboss.windup.rules.apps.java.archives.model.IdentifiedArchiveModel;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.WindupException;

public final class ArchiveIdentificationGraphChangedListener
implements GraphListener {
    private static final Logger LOG = Logging.get(ArchiveIdentificationGraphChangedListener.class);
    private final ArchiveIdentificationService identifier;
    private GraphContext context;
    private ArchiveService archiveService;

    public ArchiveIdentificationGraphChangedListener(GraphContext context, ArchiveIdentificationService identifier) {
        this.identifier = identifier;
        this.setGraphContext(context);
    }

    public ArchiveIdentificationGraphChangedListener setGraphContext(GraphContext context) {
        this.context = context;
        this.archiveService = new ArchiveService(context);
        return this;
    }

    public void vertexPropertyChanged(Vertex element, Property oldValue, Object setValue, Object ... vertexPropertyKeyValues) {
        String key = oldValue.key();
        if ("archiveName".equals(key)) {
            ArchiveModel archive = (ArchiveModel)this.archiveService.getById(element.id());
            this.setArchiveHashes(archive);
            Coordinate coordinate = this.identifier.getCoordinate(archive.getSHA1Hash());
            if (coordinate != null) {
                if (this.shouldBeIgnored(archive)) {
                    this.identifyAndIgnore(archive, coordinate);
                }
            } else {
                LOG.info("Archive not identified: " + archive.getFilePath() + " SHA1: " + archive.getSHA1Hash());
            }
        }
    }

    private void setArchiveHashes(ArchiveModel payload) {
        InputStream is;
        if (payload.getMD5Hash() == null) {
            try {
                is = payload.asInputStream();
                try {
                    String md5 = DigestUtils.md5Hex((InputStream)is);
                    payload.setMD5Hash(md5);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (IOException e) {
                throw new WindupException("Failed to read archive file at: " + payload.getFilePath() + " due to: " + e.getMessage(), (Throwable)e);
            }
        }
        if (payload.getSHA1Hash() == null) {
            try {
                is = payload.asInputStream();
                try {
                    String sha1 = DigestUtils.sha1Hex((InputStream)is);
                    payload.setSHA1Hash(sha1);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (IOException e) {
                throw new WindupException("Failed to read archive file at: " + payload.getFilePath() + " due to: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean shouldBeIgnored(ArchiveModel archive) {
        boolean shouldBeIgnored;
        WindupConfigurationModel cfg = WindupConfigurationService.getConfigurationModel((GraphContext)this.context);
        if (!StringUtils.endsWithIgnoreCase((CharSequence)archive.getFileName(), (CharSequence)".jar")) {
            shouldBeIgnored = false;
        } else if (cfg.isAnalyzeKnownLibraries().booleanValue()) {
            shouldBeIgnored = false;
        } else {
            WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)this.context);
            shouldBeIgnored = configurationModel.getInputPaths().stream().noneMatch(path -> path.equals(archive));
        }
        return shouldBeIgnored;
    }

    private void identifyAndIgnore(ArchiveModel archive, Coordinate coordinate) {
        IdentifiedArchiveModel identifiedArchive = (IdentifiedArchiveModel)GraphService.addTypeToModel((GraphContext)this.context, (WindupVertexFrame)archive, IdentifiedArchiveModel.class);
        ArchiveCoordinateModel coordinateModel = (ArchiveCoordinateModel)new GraphService(this.context, ArchiveCoordinateModel.class).create();
        coordinateModel.setArtifactId(coordinate.getArtifactId());
        coordinateModel.setGroupId(coordinate.getGroupId());
        coordinateModel.setVersion(coordinate.getVersion());
        coordinateModel.setClassifier(coordinate.getClassifier());
        identifiedArchive.setCoordinate(coordinateModel);
        LOG.info("Identified archive: [" + archive.getFilePath() + "] as [" + coordinate + "] will not be unzipped or analyzed.");
        IgnoredArchiveModel ignoredArchive = (IgnoredArchiveModel)GraphService.addTypeToModel((GraphContext)this.context, (WindupVertexFrame)archive, IgnoredArchiveModel.class);
        ignoredArchive.setIgnoredRegex("Known open-source library");
    }

    public void vertexAdded(Vertex vertex) {
    }
}

