/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.GotoInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.MethodData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;

public final class MethodEditor {
    private static final ExceptionHandler[] noHandlers = new ExceptionHandler[0];
    private int[] instructionsToBytecodes;
    private IInstruction[] instructions;
    private ExceptionHandler[][] handlers;
    private final MethodData methodInfo;
    private static final int BEFORE_PASS = 1;
    private static final int DURING_PASS = 2;
    private static final int EMITTING_CODE = 4;
    private static final int BEFORE_END_PASS = 8;
    private int state = 1;
    private int patchCount;
    private Patch[] beforePatches;
    private Patch[] afterPatches;
    private Patch[] lastAfterPatches;
    private Patch[] replacementPatches;
    private Patch methodStartPatches;
    private Patch afterMethodPatches;
    private HandlerPatch[] instructionHandlerPatches;
    private HandlerPatch methodHandlerPatches;
    private int nextLabel;

    public MethodEditor(MethodData info) {
        if (info == null) {
            throw new IllegalArgumentException("info is null");
        }
        this.methodInfo = info;
        this.instructionsToBytecodes = info.getInstructionsToBytecodes();
        this.instructions = info.getInstructions();
        this.handlers = info.getHandlers();
    }

    public MethodEditor(Instruction[] instructions, ExceptionHandler[][] handlers, int[] instructionsToBytecodes) {
        if (instructions == null) {
            throw new IllegalArgumentException("null instructions");
        }
        if (handlers == null) {
            throw new IllegalArgumentException("null handlers");
        }
        this.methodInfo = null;
        this.instructionsToBytecodes = instructionsToBytecodes;
        this.instructions = instructions;
        this.handlers = handlers;
    }

    private void verifyState(int state) {
        if ((state & this.state) == 0) {
            throw new IllegalArgumentException(MethodEditor.getStateMessage(state));
        }
    }

    private static String getStateMessage(int state) {
        switch (state) {
            case 1: {
                return "This operation can only be performed before or after an editing pass";
            }
            case 2: {
                return "This operation can only be performed during an editing pass";
            }
            case 4: {
                return "This operation can only be performed while applying patches and emitting code";
            }
            case 8: {
                return "This operation can only be performed after applying patches";
            }
        }
        return "This operation cannot be performed in this state";
    }

    public ExceptionHandler[][] getHandlers() {
        this.verifyState(3);
        return this.handlers;
    }

    public IInstruction[] getInstructions() {
        this.verifyState(3);
        return this.instructions;
    }

    public int[] getInstructionsToBytecodes() {
        this.verifyState(3);
        return this.instructionsToBytecodes;
    }

    static ExceptionHandler[] mergeHandlers(ExceptionHandler[] h1, ExceptionHandler[] h2) {
        if (h1.length == 0) {
            return h2;
        }
        if (h2.length == 0) {
            return h1;
        }
        ExceptionHandler[] r = Arrays.copyOf(h1, h1.length + h2.length);
        System.arraycopy(h2, 0, r, h1.length, h2.length);
        return r;
    }

    public void beginPass() {
        this.verifyState(1);
        this.state = 2;
        this.nextLabel = this.instructions.length;
        this.beforePatches = new Patch[this.instructions.length];
        this.afterPatches = new Patch[this.instructions.length];
        this.lastAfterPatches = new Patch[this.instructions.length];
        this.replacementPatches = new Patch[this.instructions.length];
        this.instructionHandlerPatches = new HandlerPatch[this.instructions.length];
        this.methodStartPatches = null;
        this.afterMethodPatches = null;
        this.methodHandlerPatches = null;
        this.patchCount = 0;
    }

    public void endPass() {
        this.state = 1;
        this.beforePatches = null;
        this.afterPatches = null;
        this.lastAfterPatches = null;
        this.replacementPatches = null;
        this.instructionHandlerPatches = null;
        this.methodStartPatches = null;
        this.afterMethodPatches = null;
        this.methodHandlerPatches = null;
    }

    public int allocateLabel() throws IllegalArgumentException {
        this.verifyState(2);
        return this.nextLabel++;
    }

    public void insertAtStart(Patch p) {
        if (p == null) {
            throw new IllegalArgumentException("p is null");
        }
        this.verifyState(2);
        this.methodStartPatches = p.insert(this.methodStartPatches);
        ++this.patchCount;
    }

    public void insertBefore(int i, Patch p) {
        if (p == null) {
            throw new IllegalArgumentException("p is null");
        }
        this.verifyState(2);
        this.beforePatches[i] = p.insert(this.beforePatches[i]);
        ++this.patchCount;
    }

    public void insertAfter(int i, Patch p) {
        this.verifyState(2);
        try {
            if (this.afterPatches[i] == null) {
                this.lastAfterPatches[i] = this.afterPatches[i] = p.insert(null);
            } else {
                this.lastAfterPatches[i].next = p;
                this.lastAfterPatches[i] = p.insert(null);
            }
            ++this.patchCount;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("invalid i", e);
        }
    }

    public void replaceWith(int i, Patch p) throws NullPointerException {
        if (p == null) {
            throw new IllegalArgumentException("p is null");
        }
        this.verifyState(2);
        if (this.replacementPatches[i] != null) {
            throw new IllegalArgumentException("Instruction " + i + " cannot be replaced more than once");
        }
        this.replacementPatches[i] = p.insert(null);
        ++this.patchCount;
    }

    public void addInstructionExceptionHandler(int i, String catchClass, Patch p) {
        this.verifyState(2);
        try {
            this.instructionHandlerPatches[i] = new HandlerPatch(this.instructionHandlerPatches[i], catchClass, this.allocateLabel(), p);
            ++this.patchCount;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("invalid i: " + i, e);
        }
    }

    public void addMethodExceptionHandler(String catchClass, Patch p) {
        this.verifyState(2);
        if (p == null) {
            throw new IllegalArgumentException("null p");
        }
        this.methodHandlerPatches = new HandlerPatch(this.methodHandlerPatches, catchClass, this.allocateLabel(), p);
        ++this.patchCount;
    }

    public void insertAfterBody(Patch p) {
        if (p == null) {
            throw new IllegalArgumentException("p is null");
        }
        this.verifyState(2);
        this.afterMethodPatches = p.insert(this.afterMethodPatches);
        ++this.patchCount;
    }

    public MethodData getData() {
        return this.methodInfo;
    }

    private static ExceptionHandler[] makeExceptionArray(HandlerPatch hp) {
        if (hp == null) {
            return noHandlers;
        }
        int count = 0;
        HandlerPatch hpIterator = hp;
        while (hpIterator != null) {
            ++count;
            hpIterator = hpIterator.next;
        }
        ExceptionHandler[] patchedHandlers = new ExceptionHandler[count];
        count = 0;
        HandlerPatch hpIterator2 = hp;
        while (hpIterator2 != null) {
            patchedHandlers[count] = new ExceptionHandler(hpIterator2.label, hpIterator2.catchClass);
            ++count;
            hpIterator2 = hpIterator2.next;
        }
        return patchedHandlers;
    }

    public boolean applyPatches() throws IllegalArgumentException {
        int i;
        this.verifyState(2);
        this.state = 4;
        if (this.patchCount == 0) {
            this.state = 8;
            return false;
        }
        Output w = new Output(this.nextLabel);
        int[] oldInstructionsToNew = new int[this.instructions.length];
        w.additionalHandlers = noHandlers;
        w.originalBytecode = 0;
        Patch p = this.methodStartPatches;
        while (p != null) {
            p.emitTo(w);
            p = p.next;
        }
        ExceptionHandler[] methodHandlers = MethodEditor.makeExceptionArray(this.methodHandlerPatches);
        if (methodHandlers.length > 0) {
            w.codeChanged = true;
        }
        for (int i2 = 0; i2 < this.instructions.length; ++i2) {
            ExceptionHandler[] basicHandlers = MethodEditor.mergeHandlers(this.handlers[i2], methodHandlers);
            HandlerPatch hp = this.instructionHandlerPatches[i2];
            w.emitLabel(i2);
            w.originalBytecode = this.instructionsToBytecodes[i2];
            w.additionalHandlers = basicHandlers;
            Patch p2 = this.beforePatches[i2];
            while (p2 != null) {
                p2.emitTo(w);
                p2 = p2.next;
            }
            w.additionalHandlers = MethodEditor.mergeHandlers(MethodEditor.makeExceptionArray(hp), basicHandlers);
            Patch replace = this.replacementPatches[i2];
            if (replace == null) {
                oldInstructionsToNew[i2] = w.newInstructions.size();
                w.internalEmitInstruction(this.instructions[i2]);
            } else {
                w.codeChanged = true;
                oldInstructionsToNew[i2] = -1;
                replace.emitTo(w);
            }
            w.additionalHandlers = basicHandlers;
            Patch p3 = this.afterPatches[i2];
            while (p3 != null) {
                p3.emitTo(w);
                p3 = p3.next;
            }
            if (hp == null) continue;
            w.codeChanged = true;
            GotoInstruction branchOver = GotoInstruction.make(i2 + 1);
            w.internalEmitInstruction(branchOver);
            HandlerPatch hpIterator = hp;
            while (hpIterator != null) {
                w.additionalHandlers = MethodEditor.mergeHandlers(MethodEditor.makeExceptionArray(hpIterator.next), basicHandlers);
                w.emitLabel(hpIterator.label);
                hpIterator.patch.emitTo(w);
                w.internalEmitInstruction(branchOver);
                hpIterator = hpIterator.next;
            }
        }
        w.originalBytecode = 0;
        HandlerPatch hpIterator = this.methodHandlerPatches;
        while (hpIterator != null) {
            w.additionalHandlers = MethodEditor.makeExceptionArray(hpIterator.next);
            w.emitLabel(hpIterator.label);
            hpIterator.patch.emitTo(w);
            hpIterator = hpIterator.next;
        }
        w.additionalHandlers = noHandlers;
        Patch p4 = this.afterMethodPatches;
        while (p4 != null) {
            p4.emitTo(w);
            p4 = p4.next;
        }
        this.state = 8;
        if (!w.codeChanged) {
            return false;
        }
        this.instructions = new Instruction[w.newInstructions.size()];
        this.handlers = new ExceptionHandler[this.instructions.length][];
        this.instructionsToBytecodes = new int[this.instructions.length];
        w.newInstructions.toArray(this.instructions);
        w.newInstructionHandlers.toArray((T[])this.handlers);
        System.arraycopy(w.instructionsToBytecodes, 0, this.instructionsToBytecodes, 0, this.instructionsToBytecodes.length);
        int[] labelDefs = w.labelDefs;
        int[] newInstructionsToOld = new int[this.instructions.length];
        for (int i3 = 0; i3 < this.instructions.length; ++i3) {
            this.instructions[i3] = this.instructions[i3].redirectTargets(labelDefs);
            newInstructionsToOld[i3] = -1;
        }
        IdentityHashMap adjustedHandlers = null;
        for (i = 0; i < this.handlers.length; ++i) {
            ExceptionHandler[] hs = this.handlers[i];
            if (hs.length <= 0 || i != 0 && hs == this.handlers[i - 1]) continue;
            if (adjustedHandlers == null) {
                adjustedHandlers = new IdentityHashMap();
            }
            for (ExceptionHandler element : hs) {
                ExceptionHandler h = element;
                if (adjustedHandlers.containsKey(h)) continue;
                adjustedHandlers.put(h, null);
                h.handler = labelDefs[h.handler];
            }
        }
        if (this.methodInfo != null) {
            for (i = 0; i < oldInstructionsToNew.length; ++i) {
                if (oldInstructionsToNew[i] == -1) continue;
                newInstructionsToOld[oldInstructionsToNew[i]] = i;
            }
            this.methodInfo.update(this.instructions, this.handlers, newInstructionsToOld, this.instructionsToBytecodes);
        }
        return true;
    }

    public void visitInstructions(Visitor v) {
        this.verifyState(2);
        for (int i = 0; i < this.instructions.length; ++i) {
            v.setIndex(this, i);
            this.instructions[i].visit(v);
        }
    }

    public static class Visitor
    extends IInstruction.Visitor {
        private int index;
        private MethodEditor editor;

        public final void setIndex(MethodEditor e, int i) {
            this.index = i;
            this.editor = e;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void insertAfter(Patch p) {
            this.editor.insertAfter(this.index, p);
        }

        public final void insertBefore(Patch p) {
            this.editor.insertBefore(this.index, p);
        }

        public final void replaceWith(Patch p) {
            this.editor.replaceWith(this.index, p);
        }

        public final void addInstructionExceptionHandler(String catchClass, Patch p) {
            this.editor.addInstructionExceptionHandler(this.index, catchClass, p);
        }
    }

    public static abstract class Patch {
        Patch next;

        final Patch insert(Patch next) {
            this.next = next;
            return this;
        }

        public abstract void emitTo(Output var1);
    }

    public static final class Output {
        final ArrayList<IInstruction> newInstructions = new ArrayList();
        final ArrayList<ExceptionHandler[]> newInstructionHandlers = new ArrayList();
        int[] instructionsToBytecodes = new int[10];
        final int[] labelDefs;
        ExceptionHandler[] additionalHandlers;
        int originalBytecode;
        boolean codeChanged = false;

        Output(int numLabels) {
            this.labelDefs = new int[numLabels];
        }

        public void emitLabel(int label) {
            this.labelDefs[label] = this.newInstructions.size();
        }

        public void emit(Instruction i) {
            this.codeChanged = true;
            this.internalEmitInstruction(i);
        }

        public void emit(Instruction i, ExceptionHandler[] handlers) {
            this.codeChanged = true;
            int s = this.newInstructions.size();
            if (s + 1 > this.instructionsToBytecodes.length) {
                this.instructionsToBytecodes = Arrays.copyOf(this.instructionsToBytecodes, this.instructionsToBytecodes.length * 2);
            }
            this.instructionsToBytecodes[s] = this.originalBytecode;
            this.newInstructions.add(i);
            this.newInstructionHandlers.add(MethodEditor.mergeHandlers(handlers, this.additionalHandlers));
        }

        void internalEmitInstruction(IInstruction i) {
            int s = this.newInstructions.size();
            if (s + 1 > this.instructionsToBytecodes.length) {
                this.instructionsToBytecodes = Arrays.copyOf(this.instructionsToBytecodes, this.instructionsToBytecodes.length * 2);
            }
            this.instructionsToBytecodes[s] = this.originalBytecode;
            this.newInstructions.add(i);
            this.newInstructionHandlers.add(this.additionalHandlers);
        }

        public void emit(Instruction[] instrs) {
            this.emit(instrs, noHandlers);
        }

        public void emit(Instruction[] instrs, ExceptionHandler[] handlers) {
            if (instrs.length == 0) {
                return;
            }
            this.codeChanged = true;
            int s = this.newInstructions.size();
            if (s + instrs.length > this.instructionsToBytecodes.length) {
                this.instructionsToBytecodes = Arrays.copyOf(this.instructionsToBytecodes, this.instructionsToBytecodes.length * 2 + instrs.length);
            }
            ExceptionHandler[] hs = MethodEditor.mergeHandlers(handlers, this.additionalHandlers);
            for (int i = 0; i < instrs.length; ++i) {
                this.instructionsToBytecodes[s + i] = this.originalBytecode;
                this.newInstructions.add(instrs[i]);
                this.newInstructionHandlers.add(hs);
            }
        }
    }

    private static class HandlerPatch {
        final HandlerPatch next;
        final String catchClass;
        final int label;
        final Patch patch;

        HandlerPatch(HandlerPatch next, String catchClass, int label, Patch patch) {
            this.next = next;
            this.catchClass = catchClass;
            this.label = label;
            this.patch = patch;
        }
    }
}

