/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.attribute.Text;
import org.jboss.windup.ast.java.data.ResolutionStatus;
import org.jboss.windup.ast.java.data.TypeReferenceLocation;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.DuplicateProjectModel;
import org.jboss.windup.graph.model.FileLocationModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.reporting.TagUtil;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.jboss.windup.reporting.service.InlineHintService;
import org.jboss.windup.rules.apps.java.scan.ast.JavaTypeReferenceModel;
import org.jboss.windup.util.ExecutionStatistics;

public class TypeReferenceService
extends GraphService<JavaTypeReferenceModel> {
    public TypeReferenceService(GraphContext context) {
        super(context, JavaTypeReferenceModel.class);
    }

    public Map<String, Integer> getPackageUseFrequencies(ProjectModelTraversal projectTraversal, Set<String> includeTags, Set<String> excludeTags, int nameDepth, boolean recursive) {
        HashMap<String, Integer> packageUseCount = new HashMap<String, Integer>();
        this.getPackageUseFrequencies(packageUseCount, projectTraversal, includeTags, excludeTags, nameDepth, recursive);
        return packageUseCount;
    }

    private Map<String, Integer> getPackageUseFrequencies(Map<String, Integer> packageUseCount, ProjectModelTraversal projectTraversal, Set<String> includeTags, Set<String> excludeTags, int nameDepth, boolean recursive) {
        this.getPackageUseFrequencies(packageUseCount, projectTraversal.getCurrent(), includeTags, excludeTags, nameDepth, false);
        if (recursive) {
            for (ProjectModelTraversal childTraversal : projectTraversal.getChildren()) {
                this.getPackageUseFrequencies(packageUseCount, childTraversal, includeTags, excludeTags, nameDepth, recursive);
            }
        }
        return packageUseCount;
    }

    public Map<String, Integer> getPackageUseFrequencies(ProjectModel projectModel, Set<String> includeTags, Set<String> excludeTags, int nameDepth, boolean recursive) {
        ExecutionStatistics.get().begin("TypeReferenceService.getPackageUseFrequencies(projectModel,nameDepth,recursive)");
        HashMap<String, Integer> packageUseCount = new HashMap<String, Integer>();
        this.getPackageUseFrequencies(packageUseCount, projectModel, includeTags, excludeTags, nameDepth, recursive);
        ExecutionStatistics.get().end("TypeReferenceService.getPackageUseFrequencies(projectModel,nameDepth,recursive)");
        return packageUseCount;
    }

    private void getPackageUseFrequencies(Map<String, Integer> data, ProjectModel projectModel, Set<String> includeTags, Set<String> excludeTags, int nameDepth, boolean recursive) {
        ExecutionStatistics.get().begin("TypeReferenceService.getPackageUseFrequencies(data,projectModel,nameDepth,recursive)");
        if (projectModel instanceof DuplicateProjectModel) {
            projectModel = ((DuplicateProjectModel)projectModel).getCanonicalProject();
        }
        InlineHintService hintService = new InlineHintService(this.getGraphContext());
        GraphTraversal pipeline = new GraphTraversalSource((Graph)this.getGraphContext().getGraph()).V(new Object[]{projectModel.getElement()});
        pipeline.out(new String[]{"projectModelToFile"}).in(new String[]{"file"});
        pipeline.has("w:winduptype", Text.textContains((Object)"InlineHintModel"));
        pipeline.as("inlineHintVertex", new String[0]);
        pipeline.out(new String[]{"InlineHintModel-fileLocationReference"}).has("w:winduptype", Text.textContains((Object)"JavaTypeReferenceModel"));
        pipeline.select("inlineHintVertex");
        for (Vertex inlineHintVertex : pipeline.toList()) {
            InlineHintModel javaInlineHint = (InlineHintModel)hintService.frame(inlineHintVertex);
            if ((!includeTags.isEmpty() || !excludeTags.isEmpty()) && !TagUtil.checkMatchingTags((Collection)javaInlineHint.getTags(), includeTags, excludeTags)) continue;
            int val = 1;
            FileLocationModel fileLocationModel = javaInlineHint.getFileLocationReference();
            if (fileLocationModel == null || !(fileLocationModel instanceof JavaTypeReferenceModel)) continue;
            JavaTypeReferenceModel typeReferenceModel = (JavaTypeReferenceModel)fileLocationModel;
            String pattern = typeReferenceModel.getResolvedSourceSnippit();
            String[] keyArray = pattern.split("\\.");
            if (keyArray.length > 1 && nameDepth > 1) {
                StringBuilder patternSB = new StringBuilder();
                for (int i = 0; i < nameDepth; ++i) {
                    String subElement = keyArray[i];
                    if (subElement.contains("(") || subElement.contains(")")) continue;
                    if (patternSB.length() != 0) {
                        patternSB.append(".");
                    }
                    patternSB.append(subElement);
                }
                if (patternSB.toString().contains(".")) {
                    patternSB.append(".*");
                }
                pattern = patternSB.toString();
            }
            if (pattern.contains("(")) {
                pattern = pattern.substring(0, pattern.indexOf(40));
            }
            if (data.containsKey(pattern)) {
                val = data.get(pattern);
                ++val;
            }
            data.put(pattern, val);
        }
        if (recursive) {
            for (ProjectModel childProject : projectModel.getChildProjects()) {
                ExecutionStatistics.get().end("TypeReferenceService.getPackageUseFrequencies(data,projectModel,nameDepth,recursive)");
                this.getPackageUseFrequencies(data, childProject, includeTags, excludeTags, nameDepth, recursive);
                ExecutionStatistics.get().begin("TypeReferenceService.getPackageUseFrequencies(data,projectModel,nameDepth,recursive)");
            }
        }
        ExecutionStatistics.get().end("TypeReferenceService.getPackageUseFrequencies(data,projectModel,nameDepth,recursive)");
    }

    public JavaTypeReferenceModel createTypeReference(FileModel fileModel, TypeReferenceLocation location, ResolutionStatus resolutionStatus, int lineNumber, int columnNumber, int length, String resolvedSource, String line) {
        ExecutionStatistics.get().begin("TypeReferenceService.createTypeReference(fileModel,location,lineNumber,columnNumber,length,source)");
        JavaTypeReferenceModel model = (JavaTypeReferenceModel)this.create();
        model.setFile(fileModel);
        model.setLineNumber(lineNumber);
        model.setColumnNumber(columnNumber);
        model.setLength(length);
        model.setResolvedSourceSnippit(resolvedSource);
        model.setSourceSnippit(line);
        model.setReferenceLocation(location);
        model.setResolutionStatus(resolutionStatus);
        ExecutionStatistics.get().end("TypeReferenceService.createTypeReference(fileModel,location,lineNumber,columnNumber,length,source)");
        return model;
    }
}

