/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.service;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.jboss.forge.roaster.model.util.Types;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.exception.NonUniqueResultException;
import org.jboss.windup.rules.apps.java.model.AbstractJavaSourceModel;
import org.jboss.windup.rules.apps.java.model.AmbiguousJavaClassModel;
import org.jboss.windup.rules.apps.java.model.AmbiguousReferenceModel;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.model.JavaMethodModel;
import org.jboss.windup.rules.apps.java.model.JavaParameterModel;
import org.jboss.windup.rules.apps.java.model.PhantomJavaClassModel;
import org.jboss.windup.util.ExecutionStatistics;

public class JavaClassService
extends GraphService<JavaClassModel> {
    public JavaClassService(GraphContext context) {
        super(context, JavaClassModel.class);
    }

    public JavaClassModel getByName(String qualifiedName) throws NonUniqueResultException {
        ExecutionStatistics.get().begin("getUniqueByName(qualifiedName)");
        JavaClassModel result = this.resolveByQualifiedName(qualifiedName);
        ExecutionStatistics.get().end("getUniqueByName(qualifiedName)");
        return result;
    }

    public synchronized JavaClassModel create(String qualifiedName) {
        PhantomJavaClassModel phantom = (PhantomJavaClassModel)new GraphService(this.getGraphContext(), PhantomJavaClassModel.class).getUniqueByProperty("qualifiedName", (Object)qualifiedName);
        if (phantom != null) {
            GraphService.removeTypeFromModel((GraphContext)this.getGraphContext(), (WindupVertexFrame)phantom, PhantomJavaClassModel.class);
            return phantom;
        }
        JavaClassModel javaClassModel = (JavaClassModel)super.create();
        this.setPropertiesFromName(javaClassModel, qualifiedName);
        return javaClassModel;
    }

    public synchronized JavaClassModel getOrCreatePhantom(String qualifiedName) {
        JavaClassModel result = this.resolveByQualifiedName(qualifiedName);
        if (result == null) {
            result = (JavaClassModel)new GraphService(this.getGraphContext(), PhantomJavaClassModel.class).create();
            this.setPropertiesFromName(result, qualifiedName);
        }
        return result;
    }

    private void setPropertiesFromName(JavaClassModel model, String qualifiedName) {
        model.setQualifiedName(qualifiedName);
        model.setSimpleName(Types.toSimpleName((String)qualifiedName));
        model.setPackageName(Types.getPackage((String)qualifiedName));
    }

    public Iterable<JavaClassModel> findByJavaClassPattern(String regex) {
        ExecutionStatistics.get().begin("JavaClassService.findByJavaClassPattern(regex)");
        Iterable result = super.findAllByPropertyMatchingRegex("qualifiedName", new String[]{regex});
        ExecutionStatistics.get().end("JavaClassService.findByJavaClassPattern(regex)");
        return result;
    }

    public Iterable<JavaClassModel> findByJavaPackage(String packageName) {
        ExecutionStatistics.get().begin("JavaClassService.findByJavaPackage(packageName)");
        List result = this.getGraphContext().getQuery(JavaClassModel.class).traverse(g -> g.has("packageName", (Object)packageName)).toList(JavaClassModel.class);
        ExecutionStatistics.get().end("JavaClassService.findByJavaPackage(packageName)");
        return result;
    }

    public Iterable<JavaClassModel> findByJavaVersion(JavaVersion version) {
        ExecutionStatistics.get().begin("JavaClassService.findByJavaVersion(version)");
        List result = this.getGraphContext().getQuery(JavaClassModel.class).traverse(g -> g.has("majorVersion", (Object)version.getMajor())).traverse(g -> g.has("minorVersion", (Object)version.getMinor())).toList(JavaClassModel.class);
        ExecutionStatistics.get().end("JavaClassService.findByJavaVersion(version)");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaClassModel resolveByQualifiedName(String qualifiedClassName) {
        ExecutionStatistics.get().begin("JavaClassService.resolveByQualifiedName(qualifiedClassName)");
        try {
            JavaClassModel model;
            JavaClassModel javaClassModel = model = (JavaClassModel)this.getUniqueByProperty("qualifiedName", qualifiedClassName);
            return javaClassModel;
        }
        catch (NonUniqueResultException e) {
            Iterable candidates = this.findAllByProperty("qualifiedName", qualifiedClassName);
            AmbiguousReferenceModel ambiguousModel = null;
            for (JavaClassModel candidate : candidates) {
                if (!(candidate instanceof AmbiguousJavaClassModel)) continue;
                ambiguousModel = (AmbiguousJavaClassModel)candidate;
            }
            if (ambiguousModel == null) {
                GraphService ambiguousJavaClassModelService = new GraphService(this.getGraphContext(), AmbiguousJavaClassModel.class);
                ambiguousModel = (AmbiguousJavaClassModel)ambiguousJavaClassModelService.create();
            }
            HashSet<JavaClassModel> existingAmbiguousEntries = new HashSet<JavaClassModel>();
            for (JavaClassModel existingAmbiguousClass : ambiguousModel.getReferences()) {
                existingAmbiguousEntries.add(existingAmbiguousClass);
            }
            for (JavaClassModel candidate : candidates) {
                if (existingAmbiguousEntries.contains(candidate)) continue;
                ambiguousModel.addReference(candidate);
            }
            AmbiguousReferenceModel ambiguousReferenceModel = ambiguousModel;
            return ambiguousReferenceModel;
        }
        finally {
            ExecutionStatistics.get().end("JavaClassService.resolveByQualifiedName(qualifiedClassName)");
        }
    }

    public void addInterface(JavaClassModel jcm, JavaClassModel interfaceJCM) {
        for (JavaClassModel existingInterface : jcm.getInterfaces()) {
            if (!existingInterface.equals(interfaceJCM)) continue;
            return;
        }
        jcm.addInterface(interfaceJCM);
    }

    public JavaMethodModel addJavaMethod(JavaClassModel jcm, String methodName, JavaClassModel[] params) {
        ExecutionStatistics.get().begin("JavaClassService.addJavaMethod(jcm, methodName, params)");
        JavaMethodModel javaMethodModel = (JavaMethodModel)this.getGraphContext().getFramed().addFramedVertex(JavaMethodModel.class);
        javaMethodModel.setMethodName(methodName);
        for (int i = 0; i < params.length; ++i) {
            JavaClassModel param = params[i];
            JavaParameterModel paramModel = (JavaParameterModel)this.getGraphContext().getFramed().addFramedVertex(JavaParameterModel.class);
            paramModel.setJavaType(param);
            paramModel.setPosition(i);
            javaMethodModel.addMethodParameter(paramModel);
        }
        jcm.addJavaMethod(javaMethodModel);
        ExecutionStatistics.get().end("JavaClassService.addJavaMethod(jcm, methodName, params)");
        return javaMethodModel;
    }

    public Iterable<AbstractJavaSourceModel> getJavaSource(String clz) {
        LinkedList<AbstractJavaSourceModel> sources = new LinkedList<AbstractJavaSourceModel>();
        JavaClassModel classModel = this.getByName(clz);
        if (classModel == null) {
            return sources;
        }
        if (classModel instanceof AmbiguousJavaClassModel) {
            AmbiguousJavaClassModel ambiguousJavaClassModel = (AmbiguousJavaClassModel)classModel;
            for (JavaClassModel referencedClass : ambiguousJavaClassModel.getReferences()) {
                if (referencedClass.getDecompiledSource() != null) {
                    sources.add(referencedClass.getDecompiledSource());
                }
                if (referencedClass.getOriginalSource() == null) continue;
                sources.add(referencedClass.getOriginalSource());
            }
        } else {
            if (classModel.getDecompiledSource() != null) {
                sources.add(classModel.getDecompiledSource());
            }
            if (classModel.getOriginalSource() != null) {
                sources.add(classModel.getOriginalSource());
            }
        }
        return sources;
    }

    public static enum JavaVersion {
        JAVA_8(8, 0),
        JAVA_7(7, 0),
        JAVA_6(6, 0),
        JAVA_5(5, 0),
        JAVA_1_4(1, 4),
        JAVA_1_3(1, 3),
        JAVA_1_2(1, 2),
        JAVA_1_1(1, 1);

        final int major;
        final int minor;

        private JavaVersion(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }
    }
}

