/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.reporting.rules;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.ReportRenderingPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.graph.traversal.OnlyOnceTraversalStrategy;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.graph.traversal.TraversalStrategy;
import org.jboss.windup.reporting.category.IssueCategory;
import org.jboss.windup.reporting.category.IssueCategoryModel;
import org.jboss.windup.reporting.category.IssueCategoryRegistry;
import org.jboss.windup.reporting.freemarker.problemsummary.ProblemSummary;
import org.jboss.windup.reporting.freemarker.problemsummary.ProblemSummaryService;
import org.jboss.windup.reporting.model.TechnologyUsageStatisticsModel;
import org.jboss.windup.reporting.service.EffortReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.Context;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=ReportRenderingPhase.class)
public class CreateIssueSummaryDataRuleProvider
extends AbstractRuleProvider {
    public static final String ISSUE_SUMMARIES_JS = "issue_summaries.js";
    private static final Set<String> DISCARDED_TAGS = new HashSet<String>(Arrays.asList("Java EE", "Embedded", "View", "Connect", "Store", "Sustain", "Execute"));
    private static final String NEWLINE = OperatingSystemUtils.getLineSeparator();

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                CreateIssueSummaryDataRuleProvider.this.generateDataSummary(event);
            }
        });
    }

    private void generateDataSummary(GraphRewrite event) {
        ReportService reportService = new ReportService(event.getGraphContext());
        try {
            Path dataDirectory = reportService.getReportDataDirectory();
            Path issueSummaryJSPath = dataDirectory.resolve(ISSUE_SUMMARIES_JS);
            try (FileWriter issueSummaryWriter = new FileWriter(issueSummaryJSPath.toFile());){
                WindupConfigurationModel windupConfiguration = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
                issueSummaryWriter.write("var WINDUP_ISSUE_SUMMARIES = [];" + NEWLINE);
                issueSummaryWriter.write("var WINDUP_TECHNOLOGIES = [];" + NEWLINE);
                ArrayList<Map<String, Object>> analysisSummaryList = new ArrayList<Map<String, Object>>();
                for (FileModel inputApplicationFile : windupConfiguration.getInputPaths()) {
                    ProjectModel inputApplication = inputApplicationFile.getProjectModel();
                    ProjectModelTraversal projectModelTraversal = new ProjectModelTraversal(inputApplication, (TraversalStrategy)new OnlyOnceTraversalStrategy());
                    MappingJsonFactory jsonFactory = new MappingJsonFactory();
                    jsonFactory.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
                    ObjectMapper objectMapper = new ObjectMapper((JsonFactory)jsonFactory);
                    objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
                    objectMapper.addMixIn(Object.class, PropertyFilterMixin.class);
                    SimpleBeanPropertyFilter simpleBeanPropertyFilter = SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"graph", "steps", "traversal", "rawTraversal", "wrappedGraph"});
                    SimpleFilterProvider filters = new SimpleFilterProvider().addFilter("graphFilter", simpleBeanPropertyFilter);
                    Map<String, List<ProblemSummary>> summariesBySeverity = ProblemSummaryService.getProblemSummaries((GraphContext)event.getGraphContext(), (Set)projectModelTraversal.getAllProjects(true), Collections.emptySet(), Collections.emptySet()).entrySet().stream().collect(Collectors.toMap(e -> ((IssueCategoryModel)e.getKey()).getCategoryID(), Map.Entry::getValue));
                    issueSummaryWriter.write("WINDUP_ISSUE_SUMMARIES['" + inputApplication.getId() + "'] = ");
                    objectMapper.writer((FilterProvider)filters).writeValue((Writer)issueSummaryWriter, summariesBySeverity);
                    issueSummaryWriter.write(";" + NEWLINE);
                    if (!windupConfiguration.isExportingSummary()) continue;
                    analysisSummaryList.add(this.writeApplicationExportSummary(summariesBySeverity, inputApplicationFile, event.getGraphContext()));
                }
                if (windupConfiguration.isExportingSummary()) {
                    this.writeJsonOutputFile(analysisSummaryList, windupConfiguration);
                }
                issueSummaryWriter.write("var effortToDescription = [];" + NEWLINE);
                for (EffortReportService.EffortLevel level : EffortReportService.EffortLevel.values()) {
                    issueSummaryWriter.write("effortToDescription[" + level.getPoints() + "] = \"" + level.getShortDescription() + "\";");
                    issueSummaryWriter.write(NEWLINE);
                }
                issueSummaryWriter.write("var effortOrder = [");
                String comma = "";
                for (EffortReportService.EffortLevel level : EffortReportService.EffortLevel.values()) {
                    issueSummaryWriter.write(comma);
                    comma = ", ";
                    issueSummaryWriter.write("\"");
                    issueSummaryWriter.write(level.getShortDescription());
                    issueSummaryWriter.write("\"");
                }
                issueSummaryWriter.write("];" + NEWLINE);
                issueSummaryWriter.write("var severityOrder = [");
                IssueCategoryRegistry issueCategoryRegistry = IssueCategoryRegistry.instance((Context)event.getRewriteContext());
                for (IssueCategory issueCategory : issueCategoryRegistry.getIssueCategories()) {
                    issueSummaryWriter.write("'" + issueCategory.getCategoryID() + "', ");
                }
                issueSummaryWriter.write("];" + NEWLINE);
            }
        }
        catch (Exception e2) {
            throw new WindupException("Error serializing problem details due to: " + e2.getMessage(), (Throwable)e2);
        }
    }

    private Map<String, Object> writeApplicationExportSummary(Map<String, List<ProblemSummary>> summariesBySeverity, FileModel application, GraphContext context) {
        HashMap translatedResults = new HashMap();
        summariesBySeverity.forEach((k, v) -> {
            int incidents = 0;
            int effortPoints = 0;
            for (ProblemSummary summary : v) {
                incidents += summary.getNumberFound();
                effortPoints += summary.getNumberFound() * summary.getEffortPerIncident();
            }
            HashMap<String, Integer> results = new HashMap<String, Integer>();
            results.put("incidents", incidents);
            results.put("totalStoryPoints", effortPoints);
            translatedResults.put(k, results);
        });
        LinkedHashMap<String, Object> resultsWithTitle = new LinkedHashMap<String, Object>();
        resultsWithTitle.put("application", application.getFileName());
        resultsWithTitle.put("incidentsByCategory", translatedResults);
        List<ProblemSummary> mandatorySummaries = summariesBySeverity.get("mandatory");
        HashMap<Integer, Integer> incidentsByEffort = new HashMap<Integer, Integer>();
        if (mandatorySummaries != null) {
            mandatorySummaries.forEach(ps -> {
                if (!incidentsByEffort.containsKey(ps.getEffortPerIncident())) {
                    incidentsByEffort.put(ps.getEffortPerIncident(), ps.getNumberFound());
                } else {
                    incidentsByEffort.replace(ps.getEffortPerIncident(), (Integer)incidentsByEffort.get(ps.getEffortPerIncident()) + ps.getNumberFound());
                }
            });
        }
        HashMap translatedEffortResults = new HashMap();
        incidentsByEffort.forEach((k, v) -> {
            HashMap<String, Integer> results = new HashMap<String, Integer>();
            results.put("incidents", (Integer)v);
            results.put("totalStoryPoints", k * v);
            translatedEffortResults.put(this.getEffortDescription((Integer)k), results);
        });
        resultsWithTitle.put("mandatoryIncidentsByType", translatedEffortResults);
        resultsWithTitle.put("technologyTags", this.getTechnologyTagsForApplication(application, context));
        return resultsWithTitle;
    }

    private void writeJsonOutputFile(List analysisSummary, WindupConfigurationModel windupConfig) {
        String outputFolderPath = windupConfig.getOutputPath().getFilePath() + File.separator;
        ObjectMapper mapper = new ObjectMapper();
        OutputStreamWriter writer = null;
        try {
            String json = mapper.writeValueAsString((Object)analysisSummary);
            String filename = "analysisSummary.json";
            writer = new FileWriter(outputFolderPath + filename);
            writer.write(json);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Couldn't convert given map to JSON: " + e.getMessage());
        }
        catch (IOException ioe) {
            throw new RuntimeException("Couldn't write summary to file: " + ioe.getMessage());
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Set<Map<String, String>> getTechnologyTagsForApplication(FileModel application, GraphContext context) {
        GraphService service = new GraphService(context, TechnologyUsageStatisticsModel.class);
        return service.findAll().stream().filter(technologyUsageStatisticsModel -> application.getProjectModel().equals(technologyUsageStatisticsModel.getProjectModel().getRootProjectModel())).map(technologyUsageStatisticsModel -> {
            HashMap<String, String> techTag = new HashMap<String, String>(2);
            techTag.put("name", technologyUsageStatisticsModel.getName());
            techTag.put("category", technologyUsageStatisticsModel.getTags().stream().filter(technologyName -> !DISCARDED_TAGS.contains(technologyName)).findFirst().orElse("Other"));
            return techTag;
        }).collect(Collectors.toCollection(() -> new TreeSet<Map>(Comparator.comparing(stringStringMap -> (String)stringStringMap.get("name")))));
    }

    private String getEffortDescription(Integer effort) {
        switch (effort) {
            case 0: {
                return "Info";
            }
            case 1: {
                return "Trivial";
            }
            case 3: {
                return "Complex";
            }
            case 5: {
                return "Redesign";
            }
            case 7: {
                return "Architectural";
            }
        }
        return "Unknown";
    }

    @JsonFilter(value="graphFilter")
    public static class PropertyFilterMixin {
    }
}

