/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting.classloader;

import java.io.File;
import java.util.SortedSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.Location;
import org.jboss.tattletale.reporting.classloader.JBossASClassLoaderStructure;

public class JBossAS4ClassLoaderStructure
extends JBossASClassLoaderStructure {
    @Override
    public boolean isVisible(Archive from, Archive to) {
        SortedSet<Location> fromLocations = from.getLocations();
        SortedSet<Location> toLocations = to.getLocations();
        for (Location fromLocation : fromLocations) {
            String fromPath = fromLocation.getFilename();
            int fIdx = fromPath.indexOf(from.getName());
            String f = fromPath.substring(0, fIdx);
            if ((f = this.stripPrefix(f)).startsWith("docs")) continue;
            for (Location toLocation : toLocations) {
                String config;
                int deploy;
                String toPath = toLocation.getFilename();
                int tIdx = toPath.indexOf(to.getName());
                String t = toPath.substring(0, tIdx);
                if (f.equals(t = this.stripPrefix(t))) {
                    return true;
                }
                if (f.startsWith("bin") || f.startsWith("client")) continue;
                if (t.startsWith("bin") || t.startsWith("lib")) {
                    return true;
                }
                if (f.startsWith("lib")) {
                    if (!f.startsWith(t) && !t.startsWith("bin")) continue;
                    return true;
                }
                if (t.startsWith("client")) continue;
                if (f.startsWith(t)) {
                    return true;
                }
                if (f.endsWith("lib" + File.separator) || (deploy = f.indexOf("deploy")) == -1 || !t.equals((config = f.substring(0, deploy)) + "lib" + File.separator)) continue;
                return true;
            }
        }
        return false;
    }

    private String stripPrefix(String input) {
        int idx = input.indexOf("bin");
        if (idx != -1) {
            return input.substring(idx);
        }
        idx = input.indexOf("client");
        if (idx != -1) {
            return input.substring(idx);
        }
        idx = input.indexOf("docs");
        if (idx != -1) {
            return input.substring(idx);
        }
        idx = input.indexOf("server");
        if (idx != -1) {
            return input.substring(idx);
        }
        idx = input.indexOf("lib");
        if (idx != -1) {
            return input.substring(idx);
        }
        return input;
    }
}

