/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.tattletale.reporting.AbstractReport;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.Filter;
import org.jboss.tattletale.reporting.KeyFilter;

public class PackageMultipleJarsReport
extends AbstractReport {
    private static final String NAME = "Multiple Jar files (Packages)";
    private static final String DIRECTORY = "multiplejarspackage";
    private SortedMap<String, SortedSet<String>> gProvides;

    public PackageMultipleJarsReport() {
        super(DIRECTORY, 1, NAME, DIRECTORY);
    }

    public void setGlobalProvides(SortedMap<String, SortedSet<String>> gProvides) {
        this.gProvides = gProvides;
    }

    @Override
    public void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.newLine());
        bw.write("  <tr>" + Dump.newLine());
        bw.write("     <th>Package</th>" + Dump.newLine());
        bw.write("     <th>Jar files</th>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        TreeMap<String, TreeSet<String>> packageProvides = new TreeMap<String, TreeSet<String>>();
        for (Map.Entry<String, SortedSet<String>> entry : this.gProvides.entrySet()) {
            String clz = entry.getKey();
            SortedSet<String> archives = entry.getValue();
            String packageName = null;
            packageName = clz.indexOf(46) == -1 ? "" : clz.substring(0, clz.lastIndexOf(46));
            TreeSet<String> packageJars = (TreeSet<String>)packageProvides.get(packageName);
            if (packageJars == null) {
                packageJars = new TreeSet<String>();
            }
            packageJars.addAll(archives);
            packageProvides.put(packageName, packageJars);
        }
        boolean odd = true;
        for (Map.Entry entry : packageProvides.entrySet()) {
            String pkg = (String)entry.getKey();
            SortedSet archives = (SortedSet)entry.getValue();
            if (archives.size() <= 1) continue;
            boolean filtered = this.isFiltered(pkg);
            if (!filtered) {
                this.status = 1;
            }
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.newLine());
            }
            bw.write("     <td>" + pkg + "</td>" + Dump.newLine());
            if (!filtered) {
                bw.write("        <td>");
            } else {
                bw.write("        <td style=\"text-decoration: line-through;\">");
            }
            Iterator sit = archives.iterator();
            while (sit.hasNext()) {
                String archive = (String)sit.next();
                bw.write("<a href=\"../jar/" + archive + ".html\">" + archive + "</a>" + Dump.newLine());
                if (!sit.hasNext()) continue;
                bw.write(", ");
            }
            bw.write("</td>" + Dump.newLine());
            bw.write("  </tr>" + Dump.newLine());
            odd = !odd;
        }
        bw.write("</table>" + Dump.newLine());
    }

    @Override
    public void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.newLine());
        bw.write(Dump.newLine());
        bw.write("<h1>Multiple Jar files (Packages)</h1>" + Dump.newLine());
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.newLine());
        bw.write("<p>" + Dump.newLine());
    }

    @Override
    protected Filter createFilter() {
        return new KeyFilter();
    }
}

