/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.NestableArchive;
import org.jboss.tattletale.reporting.CLSReport;
import org.jboss.tattletale.reporting.Dump;

public class PackageDependsOnReport
extends CLSReport {
    private static final String NAME = "Package Depends On";
    private static final String DIRECTORY = "packagedependson";

    public PackageDependsOnReport() {
        super(DIRECTORY, 0, NAME, DIRECTORY);
    }

    @Override
    public void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.newLine());
        bw.write(Dump.newLine());
        bw.write("<h1>Package Depends On</h1>" + Dump.newLine());
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.newLine());
        bw.write("<p>" + Dump.newLine());
    }

    @Override
    public void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.newLine());
        bw.write("  <tr>" + Dump.newLine());
        bw.write("     <th>Package</th>" + Dump.newLine());
        bw.write("     <th>Depends On</th>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        SortedMap<String, SortedSet<String>> result = this.recursivelyBuildResultFromArchive(this.archives);
        boolean odd = true;
        for (Map.Entry<String, SortedSet<String>> entry : result.entrySet()) {
            String pack = entry.getKey();
            SortedSet<String> packDeps = entry.getValue();
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.newLine());
            }
            bw.write("     <td>" + pack + "</a></td>" + Dump.newLine());
            bw.write("     <td>");
            Iterator sit = packDeps.iterator();
            while (sit.hasNext()) {
                String dep = (String)sit.next();
                bw.write(dep);
                if (!sit.hasNext()) continue;
                bw.write(", ");
            }
            bw.write("</td>" + Dump.newLine());
            bw.write("  </tr>" + Dump.newLine());
            odd = !odd;
        }
        bw.write("</table>" + Dump.newLine());
    }

    private SortedMap<String, SortedSet<String>> recursivelyBuildResultFromArchive(Collection<Archive> archives) {
        TreeMap<String, SortedSet<String>> result = new TreeMap<String, SortedSet<String>>();
        for (Archive archive : archives) {
            if (archive instanceof NestableArchive) {
                NestableArchive nestableArchive = (NestableArchive)archive;
                SortedMap<String, SortedSet<String>> subResult = this.recursivelyBuildResultFromArchive(nestableArchive.getSubArchives());
                result.putAll(subResult);
                continue;
            }
            SortedMap<String, SortedSet<String>> packageDependencies = archive.getPackageDependencies();
            for (Map.Entry<String, SortedSet<String>> entry : packageDependencies.entrySet()) {
                String pack = entry.getKey();
                SortedSet<String> packDeps = entry.getValue();
                TreeSet<String> newDeps = new TreeSet<String>();
                for (String dep : packDeps) {
                    if (dep.equals(pack)) continue;
                    newDeps.add(dep);
                }
                result.put(pack, newDeps);
            }
        }
        return result;
    }
}

