/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.NestableArchive;
import org.jboss.tattletale.reporting.AbstractReport;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.Filter;
import org.jboss.tattletale.reporting.KeyFilter;

public class BlackListedReport
extends AbstractReport {
    private static final String NAME = "Black listed";
    private static final String DIRECTORY = "blacklisted";

    public BlackListedReport() {
        super(DIRECTORY, 2, NAME, DIRECTORY);
    }

    @Override
    public void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.newLine());
        bw.write("  <tr>" + Dump.newLine());
        bw.write("     <th>Archive</th>" + Dump.newLine());
        bw.write("     <th>Usage</th>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        boolean odd = true;
        for (Archive archive : this.archives) {
            String archiveName = archive.getName();
            int finalDot = archiveName.lastIndexOf(".");
            String extension = archiveName.substring(finalDot + 1);
            SortedMap<String, SortedSet<String>> blacklisted = this.getBlackListedDeps(archive);
            boolean include = false;
            boolean filtered = this.isFiltered(archive.getName());
            if (blacklisted != null && blacklisted.size() > 0) {
                include = true;
                if (!filtered) {
                    this.status = 2;
                }
            }
            if (include) {
                if (odd) {
                    bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
                } else {
                    bw.write("  <tr class=\"roweven\">" + Dump.newLine());
                }
                bw.write("     <td><a href=\"../" + extension + "/" + archiveName + ".html\">" + archive.getName() + "</a></td>" + Dump.newLine());
                bw.write("     <td>");
                bw.write("       <table>" + Dump.newLine());
                for (Map.Entry<String, SortedSet<String>> stringSortedSetEntry : blacklisted.entrySet()) {
                    String pkg = stringSortedSetEntry.getKey();
                    SortedSet<String> blpkgs = stringSortedSetEntry.getValue();
                    bw.write("      <tr>" + Dump.newLine());
                    bw.write("        <td>" + pkg + "</td>" + Dump.newLine());
                    if (!filtered) {
                        bw.write("       <td>");
                    } else {
                        bw.write("       <td style=\"text-decoration: line-through;\">");
                    }
                    for (String blp : blpkgs) {
                        bw.write(blp + "<br>");
                    }
                    bw.write("</td>" + Dump.newLine());
                    bw.write("      </tr>" + Dump.newLine());
                }
                bw.write("       </table>" + Dump.newLine());
                bw.write("</td>" + Dump.newLine());
                bw.write("  </tr>" + Dump.newLine());
                odd = !odd;
            }
            bw.write("</table>" + Dump.newLine());
        }
    }

    private SortedMap<String, SortedSet<String>> getBlackListedDeps(Archive a) {
        TreeMap<String, SortedSet<String>> deps = new TreeMap<String, SortedSet<String>>();
        if (a instanceof NestableArchive) {
            NestableArchive na = (NestableArchive)a;
            List<Archive> subArchives = na.getSubArchives();
            for (Archive sa : subArchives) {
                deps.putAll(this.getBlackListedDeps(sa));
            }
        } else {
            deps.putAll(a.getBlackListedDependencies());
        }
        return deps;
    }

    @Override
    public void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.newLine());
        bw.write(Dump.newLine());
        bw.write("<h1>Black listed</h1>" + Dump.newLine());
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.newLine());
        bw.write("<p>" + Dump.newLine());
    }

    @Override
    protected Filter createFilter() {
        return new KeyFilter();
    }
}

