/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.analyzers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.jboss.tattletale.analyzers.AbstractScanner;
import org.jboss.tattletale.analyzers.Extractor;
import org.jboss.tattletale.analyzers.JarScanner;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.ClassesArchive;
import org.jboss.tattletale.core.Location;
import org.jboss.tattletale.core.WarArchive;
import org.jboss.tattletale.profiles.Profile;

public class WarScanner
extends AbstractScanner {
    @Override
    public Archive scan(File war) {
        return this.scan(war, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Archive scan(File war, Map<String, SortedSet<String>> gProvides, List<Profile> known, Set<String> blacklisted) {
        if (war == null || !war.exists()) {
            return null;
        }
        WarArchive warArchive = null;
        ArrayList<Archive> subArchiveList = new ArrayList<Archive>();
        JarScanner jarScanner = new JarScanner();
        ZipFile warFile = null;
        String name = war.getName();
        try {
            JarEntry warEntry;
            String canonicalPath = war.getCanonicalPath();
            warFile = new JarFile(war);
            File extractedDir = war.isFile() ? Extractor.extract((JarFile)warFile) : war;
            Integer classVersion = null;
            TreeSet<String> requires = new TreeSet<String>();
            TreeMap<String, Long> provides = new TreeMap<String, Long>();
            TreeSet<String> profiles = new TreeSet<String>();
            TreeMap<String, SortedSet<String>> classDependencies = new TreeMap<String, SortedSet<String>>();
            TreeMap<String, SortedSet<String>> packageDependencies = new TreeMap<String, SortedSet<String>>();
            TreeMap<String, SortedSet<String>> blacklistedDependencies = new TreeMap<String, SortedSet<String>>();
            ArrayList<String> lSign = null;
            Enumeration<JarEntry> warEntries = ((JarFile)warFile).entries();
            while (warEntries.hasMoreElements()) {
                File jarFile;
                Archive jarArchive;
                warEntry = warEntries.nextElement();
                String entryName = warEntry.getName();
                InputStream entryStream = null;
                if (entryName.endsWith(".class")) {
                    try {
                        entryStream = ((JarFile)warFile).getInputStream(warEntry);
                        classVersion = this.scanClasses(entryStream, blacklisted, known, classVersion, provides, requires, profiles, classDependencies, packageDependencies, blacklistedDependencies);
                        continue;
                    }
                    catch (Exception openException) {
                        openException.printStackTrace();
                        continue;
                    }
                    finally {
                        if (entryStream != null) {
                            entryStream.close();
                        }
                        continue;
                    }
                }
                if (entryName.contains("META-INF") && entryName.endsWith(".SF")) {
                    InputStream is = null;
                    try {
                        is = ((JarFile)warFile).getInputStream(warEntry);
                        InputStreamReader isr = new InputStreamReader(is);
                        LineNumberReader lnr = new LineNumberReader(isr);
                        if (lSign == null) {
                            lSign = new ArrayList<String>();
                        }
                        String s = lnr.readLine();
                        while (s != null) {
                            lSign.add(s);
                            s = lnr.readLine();
                        }
                    }
                    catch (Exception isr) {}
                    continue;
                    finally {
                        try {
                            if (is == null) continue;
                            is.close();
                        }
                        catch (IOException isr) {}
                        continue;
                    }
                }
                if (!entryName.endsWith(".jar") || (jarArchive = jarScanner.scan(jarFile = new File(extractedDir.getCanonicalPath(), entryName), gProvides, known, blacklisted)) == null) continue;
                subArchiveList.add(jarArchive);
            }
            if (provides.size() == 0 && subArchiveList.size() == 0) {
                warEntry = null;
                return warEntry;
            }
            String version = null;
            List<String> lManifest = null;
            Manifest manifest = ((JarFile)warFile).getManifest();
            if (manifest != null) {
                version = super.versionFromManifest(manifest);
                lManifest = super.readManifest(manifest);
            }
            Location location = new Location(canonicalPath, version);
            if (subArchiveList.size() > 0 && classVersion == null) {
                classVersion = ((Archive)subArchiveList.get(0)).getVersion();
            }
            if (classVersion == null) {
                classVersion = 0;
            }
            String classesName = name + "/WEB-INF/classes";
            ClassesArchive classesArchive = new ClassesArchive(classesName, classVersion, lManifest, lSign, requires, provides, classDependencies, packageDependencies, blacklistedDependencies, location);
            subArchiveList.add(classesArchive);
            warArchive = new WarArchive(name, classVersion, lManifest, lSign, requires, provides, classDependencies, packageDependencies, blacklistedDependencies, location, subArchiveList);
            super.addProfilesToArchive(warArchive, profiles);
            for (String provide : provides.keySet()) {
                if (gProvides != null) {
                    SortedSet<String> ss = gProvides.get(provide);
                    if (ss == null) {
                        ss = new TreeSet<String>();
                    }
                    ss.add(warArchive.getName());
                    gProvides.put(provide, ss);
                }
                requires.remove(provide);
            }
        }
        catch (Exception e) {
            System.err.println("Scan: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        finally {
            try {
                if (warFile != null) {
                    warFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        return warArchive;
    }
}

