/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.Factory;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class MapUtil {
    public static <K, T> Set<T> findOrCreateSet(Map<K, Set<T>> M, K key) {
        if (M == null) {
            throw new IllegalArgumentException("M is null");
        }
        Set<T> result = M.get(key);
        if (result == null) {
            result = HashSetFactory.make(2);
            M.put(key, result);
        }
        return result;
    }

    public static <K> MutableIntSet findOrCreateMutableIntSet(Map<K, MutableIntSet> M, K key) {
        if (M == null) {
            throw new IllegalArgumentException("M is null");
        }
        MutableIntSet mis = M.get(key);
        if (mis == null) {
            mis = MutableSparseIntSet.makeEmpty();
            M.put(key, mis);
        }
        return mis;
    }

    public static <K, T> Collection<T> findOrCreateCollection(Map<K, Collection<T>> M, K key) {
        if (M == null) {
            throw new IllegalArgumentException("M is null");
        }
        Collection<T> result = M.get(key);
        if (result == null) {
            result = HashSetFactory.make(2);
            M.put(key, result);
        }
        return result;
    }

    public static <K, T> List<T> findOrCreateList(Map<K, List<T>> M, K key) {
        if (M == null) {
            throw new IllegalArgumentException("M is null");
        }
        if (!M.containsKey(key)) {
            M.put(key, new ArrayList());
        }
        return M.get(key);
    }

    public static <K, K2, V> Map<K2, V> findOrCreateMap(Map<K, Map<K2, V>> M, K key) {
        if (M == null) {
            throw new IllegalArgumentException("M is null");
        }
        Map<K2, V> result = M.get(key);
        if (result == null) {
            result = HashMapFactory.make(2);
            M.put(key, result);
        }
        return result;
    }

    public static <K, V> V findOrCreateValue(Map<K, V> M, K key, Factory<V> factory) {
        if (M == null) {
            throw new IllegalArgumentException("M is null");
        }
        V result = M.get(key);
        if (result == null) {
            result = factory.make();
            M.put(key, result);
        }
        return result;
    }

    public static <K, V> WeakHashMap<K, V> findOrCreateWeakHashMap(Map<Object, WeakHashMap<K, V>> M, Object key) {
        if (M == null) {
            throw new IllegalArgumentException("M is null");
        }
        WeakHashMap result = M.computeIfAbsent(key, k -> new WeakHashMap(2));
        return result;
    }

    public static <K, V> Map<V, Set<K>> inverseMap(Map<K, Set<V>> m) {
        if (m == null) {
            throw new IllegalArgumentException("m is null");
        }
        HashMap result = HashMapFactory.make(m.size());
        for (Map.Entry<K, Set<V>> E : m.entrySet()) {
            K key = E.getKey();
            Set<V> values = E.getValue();
            for (V v : values) {
                Set s = MapUtil.findOrCreateSet(result, v);
                s.add(key);
            }
        }
        return result;
    }

    public static <K, V> Map<V, K> invertOneToOneMap(Map<K, V> m) {
        if (m == null) {
            throw new IllegalArgumentException("m is null");
        }
        HashMap<V, K> result = HashMapFactory.make(m.size());
        for (Map.Entry<K, V> entry : m.entrySet()) {
            K key = entry.getKey();
            V val = entry.getValue();
            if (result.containsKey(val)) {
                throw new IllegalArgumentException("input map not one-to-one");
            }
            result.put(val, key);
        }
        return result;
    }

    public static <K, V> Map<Set<K>, V> groupKeysByValue(Map<K, V> m) {
        if (m == null) {
            throw new IllegalArgumentException("m is null");
        }
        HashMap<Set, K> result = HashMapFactory.make();
        HashMap valueToKeys = HashMapFactory.make();
        for (Map.Entry<K, V> E : m.entrySet()) {
            K key = E.getKey();
            V value = E.getValue();
            MapUtil.findOrCreateSet(valueToKeys, value).add(key);
        }
        for (Map.Entry<K, V> E : valueToKeys.entrySet()) {
            K value = E.getKey();
            Set keys = (Set)E.getValue();
            result.put(keys, value);
        }
        return result;
    }
}

