/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util.function;

import java.io.Serializable;
import java.util.Comparator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface Lambda
extends Serializable {
    public static final String DEFAULT_LAMBDA_LANGUAGE = "gremlin-groovy";

    public String getLambdaScript();

    public String getLambdaLanguage();

    public int getLambdaArguments();

    public static <A, B> Function<A, B> function(String lambdaSource, String lambdaLanguage) {
        return new OneArgLambda(lambdaSource, lambdaLanguage);
    }

    public static <A> Predicate<A> predicate(String lambdaSource, String lambdaLanguage) {
        return new OneArgLambda(lambdaSource, lambdaLanguage);
    }

    public static <A> Consumer<A> consumer(String lambdaSource, String lambdaLanguage) {
        return new OneArgLambda(lambdaSource, lambdaLanguage);
    }

    public static <A> Supplier<A> supplier(String lambdaSource, String lambdaLanguage) {
        return new ZeroArgLambda(lambdaSource, lambdaLanguage);
    }

    public static <A> Comparator<A> comparator(String lambdaSource, String lambdaLanguage) {
        return new TwoArgLambda(lambdaSource, lambdaLanguage);
    }

    public static <A, B, C> BiFunction<A, B, C> biFunction(String lambdaSource, String lambdaLanguage) {
        return new TwoArgLambda(lambdaSource, lambdaLanguage);
    }

    public static <A, B> Function<A, B> function(String lambdaSource) {
        return new OneArgLambda(lambdaSource, DEFAULT_LAMBDA_LANGUAGE);
    }

    public static <A> Predicate<A> predicate(String lambdaSource) {
        return new OneArgLambda(lambdaSource, DEFAULT_LAMBDA_LANGUAGE);
    }

    public static <A> Consumer<A> consumer(String lambdaSource) {
        return new OneArgLambda(lambdaSource, DEFAULT_LAMBDA_LANGUAGE);
    }

    public static <A> Supplier<A> supplier(String lambdaSource) {
        return new ZeroArgLambda(lambdaSource, DEFAULT_LAMBDA_LANGUAGE);
    }

    public static <A> Comparator<A> comparator(String lambdaSource) {
        return new TwoArgLambda(lambdaSource, DEFAULT_LAMBDA_LANGUAGE);
    }

    public static <A, B, C> BiFunction<A, B, C> biFunction(String lambdaSource) {
        return new TwoArgLambda(lambdaSource, DEFAULT_LAMBDA_LANGUAGE);
    }

    public static class TwoArgLambda<A, B, C>
    extends AbstractLambda
    implements BiFunction<A, B, C>,
    Comparator<A> {
        public TwoArgLambda(String lambdaSource, String lambdaLanguage) {
            super(lambdaSource, lambdaLanguage, 2);
        }

        @Override
        public C apply(A a, B b) {
            return null;
        }

        @Override
        public int compare(A first, A second) {
            return 0;
        }
    }

    public static class OneArgLambda<A, B>
    extends AbstractLambda
    implements Function<A, B>,
    Predicate<A>,
    Consumer<A> {
        public OneArgLambda(String lambdaSource, String lambdaLanguage) {
            super(lambdaSource, lambdaLanguage, 1);
        }

        @Override
        public B apply(A a) {
            return null;
        }

        @Override
        public boolean test(A a) {
            return false;
        }

        @Override
        public void accept(A a) {
        }
    }

    public static class ZeroArgLambda<A>
    extends AbstractLambda
    implements Supplier<A> {
        public ZeroArgLambda(String lambdaSource, String lambdaLanguage) {
            super(lambdaSource, lambdaLanguage, 0);
        }

        @Override
        public A get() {
            return null;
        }
    }

    public static class UnknownArgLambda
    extends AbstractLambda {
        public UnknownArgLambda(String lambdaSource, String lambdaLanguage, int lambdaArguments) {
            super(lambdaSource, lambdaLanguage, lambdaArguments);
        }
    }

    public static abstract class AbstractLambda
    implements Lambda {
        private final String lambdaSource;
        private final String lambdaLanguage;
        private final int lambdaArguments;

        private AbstractLambda(String lambdaSource, String lambdaLanguage, int lambdaArguments) {
            this.lambdaSource = lambdaSource;
            this.lambdaLanguage = lambdaLanguage;
            this.lambdaArguments = lambdaArguments;
        }

        @Override
        public String getLambdaScript() {
            return this.lambdaSource;
        }

        @Override
        public String getLambdaLanguage() {
            return this.lambdaLanguage;
        }

        @Override
        public int getLambdaArguments() {
            return this.lambdaArguments;
        }

        public String toString() {
            return "lambda[" + this.lambdaSource + "]";
        }

        public int hashCode() {
            return this.lambdaSource.hashCode() + this.lambdaLanguage.hashCode() + this.lambdaArguments;
        }

        public boolean equals(Object object) {
            return object instanceof Lambda && ((Lambda)object).getLambdaArguments() == this.getLambdaArguments() && ((Lambda)object).getLambdaScript().equals(this.lambdaSource) && ((Lambda)object).getLambdaLanguage().equals(this.lambdaLanguage);
        }
    }
}

