/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.remote;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.remote.traversal.strategy.decoration.RemoteStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyGraph;

@Graph.OptIns(value={@Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessStandardSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessComputerSuite")})
@Graph.OptOuts(value={@Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.GroupCountTest", method="g_V_hasXnoX_groupCountXaX_capXaX", reason="This test asserts an empty side-effect which reflects as a null rather than an \"empty\" and thus doesn't assert"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.PeerPressureTest", method="*", reason="hmmmm"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.PageRankTest", method="*", reason="hmmmm"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.TranslationStrategyProcessTest", method="*", reason="hmmmm"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.CoreTraversalTest", method="*", reason="The test suite does not support profiling or lambdas and for groovy tests: 'Could not locate method: GraphTraversalSource.withStrategies([{traversalCategory=interface org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy$DecorationStrategy}])'"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.ProgramTest", method="*", reason="RemoteGraph retrieves detached vertices that can't be attached to a remote OLAP graph"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.ElementIdStrategyProcessTest", method="*", reason="RemoteGraph does not support ElementIdStrategy at this time - it requires a lambda in construction which is not serializable"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.EventStrategyProcessTest", method="*", reason="RemoteGraph does not support EventStrategy at this time - some of its members are not serializable"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.PartitionStrategyProcessTest", method="*", reason="RemoteGraph does not support PartitionStrategy at this time"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.computer.ranking.pagerank.PageRankVertexProgramTest", method="*", reason="RemoteGraph does not support direct Graph.compute() access"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.computer.bulkloading.BulkLoaderVertexProgramTest", method="*", reason="RemoteGraph does not support direct Graph.compute() access"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.computer.bulkdumping.BulkDumperVertexProgramTest", method="*", reason="RemoteGraph does not support direct Graph.compute() access"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.computer.GraphComputerTest", method="*", reason="RemoteGraph does not support direct Graph.compute() access"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.TraversalInterruptionTest", method="*", reason="The interruption model in the test can't guarantee interruption at the right time with RemoteGraph."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.TraversalInterruptionComputerTest", method="*", reason="The interruption model in the test can't guarantee interruption at the right time with RemoteGraph.")})
@Deprecated
public class RemoteGraph
implements Graph {
    private final RemoteConnection connection;
    public static final String GREMLIN_REMOTE_GRAPH_REMOTE_CONNECTION_CLASS = "gremlin.remoteGraph.remoteConnectionClass";

    private RemoteGraph(RemoteConnection connection) {
        this.connection = connection;
    }

    public static RemoteGraph open(Configuration conf) {
        RemoteConnection remoteConnection;
        if (!conf.containsKey(GREMLIN_REMOTE_GRAPH_REMOTE_CONNECTION_CLASS)) {
            throw new IllegalArgumentException("Configuration must contain the 'gremlin.remoteGraph.remoteConnectionClass' key");
        }
        try {
            Class<RemoteConnection> clazz = Class.forName(conf.getString(GREMLIN_REMOTE_GRAPH_REMOTE_CONNECTION_CLASS)).asSubclass(RemoteConnection.class);
            Constructor<RemoteConnection> ctor = clazz.getConstructor(Configuration.class);
            remoteConnection = ctor.newInstance(conf);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        return new RemoteGraph(remoteConnection);
    }

    public static RemoteGraph open(String configFile) throws Exception {
        return RemoteGraph.open((Configuration)new PropertiesConfiguration(configFile));
    }

    public static RemoteGraph open(RemoteConnection connection) {
        return new RemoteGraph(connection);
    }

    public RemoteConnection getConnection() {
        return this.connection;
    }

    @Override
    public void close() throws Exception {
        this.connection.close();
    }

    @Override
    public Vertex addVertex(Object ... keyValues) {
        throw new UnsupportedOperationException(String.format("RemoteGraph is a proxy to %s - this method is not supported", this.connection));
    }

    @Override
    public <C extends GraphComputer> C compute(Class<C> graphComputerClass) throws IllegalArgumentException {
        throw new UnsupportedOperationException(String.format("RemoteGraph is a proxy to %s - this method is not supported", this.connection));
    }

    @Override
    public GraphComputer compute() throws IllegalArgumentException {
        throw new UnsupportedOperationException(String.format("RemoteGraph is a proxy to %s - this method is not supported", this.connection));
    }

    @Override
    public Iterator<Vertex> vertices(Object ... vertexIds) {
        return Collections.emptyIterator();
    }

    @Override
    public Iterator<Edge> edges(Object ... edgeIds) {
        return Collections.emptyIterator();
    }

    @Override
    public Transaction tx() {
        throw new UnsupportedOperationException(String.format("RemoteGraph is a proxy to %s - this method is not supported", this.connection));
    }

    @Override
    public Graph.Variables variables() {
        throw new UnsupportedOperationException(String.format("RemoteGraph is a proxy to %s - this method is not supported", this.connection));
    }

    @Override
    public Configuration configuration() {
        throw new UnsupportedOperationException(String.format("RemoteGraph is a proxy to %s - this method is not supported", this.connection));
    }

    @Override
    public Graph.Features features() {
        return RemoteFeatures.INSTANCE;
    }

    public String toString() {
        return StringFactory.graphString(this, this.connection.toString());
    }

    static {
        TraversalStrategies.GlobalCache.registerStrategies(RemoteGraph.class, TraversalStrategies.GlobalCache.getStrategies(EmptyGraph.class).clone().addStrategies(RemoteStrategy.instance()));
    }

    public static class RemoteGraphFeatures
    implements Graph.Features.GraphFeatures {
        static RemoteGraphFeatures INSTANCE = new RemoteGraphFeatures();

        private RemoteGraphFeatures() {
        }

        @Override
        public boolean supportsTransactions() {
            return false;
        }

        @Override
        public boolean supportsThreadedTransactions() {
            return false;
        }
    }

    public static class RemoteFeatures
    implements Graph.Features {
        static RemoteFeatures INSTANCE = new RemoteFeatures();

        private RemoteFeatures() {
        }

        @Override
        public Graph.Features.GraphFeatures graph() {
            return RemoteGraphFeatures.INSTANCE;
        }
    }
}

