/*
 * Decompiled with CFR 0.152.
 */
package com.github.rwitzel.streamflyer.util.statistics;

import com.github.rwitzel.streamflyer.core.AfterModification;
import com.github.rwitzel.streamflyer.util.ModificationFactory;
import com.github.rwitzel.streamflyer.util.statistics.ModificationFactoryDecorator;

public class PositionAwareModificationFactory
extends ModificationFactoryDecorator {
    protected long currentPosition = 0L;

    public PositionAwareModificationFactory(ModificationFactory delegate) {
        super(delegate);
    }

    @Override
    public AfterModification skipOrStop(int numberOfCharactersToSkip, StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, boolean endOfStreamHit) {
        AfterModification afterModification = super.skipOrStop(numberOfCharactersToSkip, characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit);
        this.currentPosition += (long)afterModification.getNumberOfCharactersToSkip();
        return afterModification;
    }

    @Override
    public AfterModification skip(int numberOfCharactersToSkip, StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, boolean endOfStreamHit) {
        AfterModification afterModification = super.skip(numberOfCharactersToSkip, characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit);
        this.currentPosition += (long)afterModification.getNumberOfCharactersToSkip();
        return afterModification;
    }

    @Override
    public AfterModification fetchMoreInput(int numberOfCharactersToSkip, StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, boolean endOfStreamHit) {
        AfterModification afterModification = super.fetchMoreInput(numberOfCharactersToSkip, characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit);
        this.currentPosition += (long)afterModification.getNumberOfCharactersToSkip();
        return afterModification;
    }

    @Override
    public AfterModification modifyAgainImmediately(int newNumberOfChars, int firstModifiableCharacterInBuffer) {
        AfterModification afterModification = super.modifyAgainImmediately(newNumberOfChars, firstModifiableCharacterInBuffer);
        this.currentPosition += (long)afterModification.getNumberOfCharactersToSkip();
        return afterModification;
    }

    @Override
    public AfterModification skipEntireBuffer(StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, boolean endOfStreamHit) {
        AfterModification afterModification = super.skipEntireBuffer(characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit);
        this.currentPosition += (long)afterModification.getNumberOfCharactersToSkip();
        return afterModification;
    }

    @Override
    public AfterModification stop(StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, boolean endOfStreamHit) {
        AfterModification afterModification = super.stop(characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit);
        this.currentPosition += (long)afterModification.getNumberOfCharactersToSkip();
        return afterModification;
    }

    public long getCurrentPosition() {
        return this.currentPosition;
    }
}

