/*
 * Decompiled with CFR 0.152.
 */
package com.syncleus.ferma.framefactories.annotation;

import com.syncleus.ferma.VertexFrame;
import com.syncleus.ferma.annotations.Adjacency;
import com.syncleus.ferma.annotations.Incidence;
import com.syncleus.ferma.annotations.Property;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ReflectionUtility {
    private static final String SET = "set";
    private static final String GET = "get";
    private static final String REMOVE = "remove";
    private static final String ADD = "add";
    private static final String IS = "is";
    private static final String CAN = "can";

    public static boolean isGetMethod(Method method) {
        Adjacency.Operation operation;
        Incidence.Operation operation2;
        Property.Operation operation3;
        Property propertyAnnotation = method.getAnnotation(Property.class);
        if (propertyAnnotation != null && (operation3 = propertyAnnotation.operation()) != null && operation3 != Property.Operation.AUTO) {
            return operation3 == Property.Operation.GET;
        }
        Incidence incidenceAnnotation = method.getAnnotation(Incidence.class);
        if (incidenceAnnotation != null && (operation2 = incidenceAnnotation.operation()) != null && operation2 != Incidence.Operation.AUTO) {
            return operation2 == Incidence.Operation.GET;
        }
        Adjacency adjacencyAnnotation = method.getAnnotation(Adjacency.class);
        if (adjacencyAnnotation != null && (operation = adjacencyAnnotation.operation()) != null && operation != Adjacency.Operation.AUTO) {
            return operation == Adjacency.Operation.GET;
        }
        Class<?> returnType = method.getReturnType();
        return method.getName().startsWith(GET) || (returnType == Boolean.class || returnType == Boolean.TYPE) && (method.getName().startsWith(IS) || method.getName().startsWith(CAN));
    }

    public static boolean isSetMethod(Method method) {
        Adjacency.Operation operation;
        Property.Operation operation2;
        Property propertyAnnotation = method.getAnnotation(Property.class);
        if (propertyAnnotation != null && (operation2 = propertyAnnotation.operation()) != null && operation2 != Property.Operation.AUTO) {
            return operation2 == Property.Operation.SET;
        }
        Adjacency adjacencyAnnotation = method.getAnnotation(Adjacency.class);
        if (adjacencyAnnotation != null && (operation = adjacencyAnnotation.operation()) != null && operation != Adjacency.Operation.AUTO) {
            return operation == Adjacency.Operation.SET;
        }
        return method.getName().startsWith(SET);
    }

    public static boolean isRemoveMethod(Method method) {
        Adjacency.Operation operation;
        Incidence.Operation operation2;
        Property.Operation operation3;
        Property propertyAnnotation = method.getAnnotation(Property.class);
        if (propertyAnnotation != null && (operation3 = propertyAnnotation.operation()) != null && operation3 != Property.Operation.AUTO) {
            return operation3 == Property.Operation.REMOVE;
        }
        Incidence incidenceAnnotation = method.getAnnotation(Incidence.class);
        if (incidenceAnnotation != null && (operation2 = incidenceAnnotation.operation()) != null && operation2 != Incidence.Operation.AUTO) {
            return operation2 == Incidence.Operation.REMOVE;
        }
        Adjacency adjacencyAnnotation = method.getAnnotation(Adjacency.class);
        if (adjacencyAnnotation != null && (operation = adjacencyAnnotation.operation()) != null && operation != Adjacency.Operation.AUTO) {
            return operation == Adjacency.Operation.REMOVE;
        }
        return method.getName().startsWith(REMOVE);
    }

    public static boolean isAddMethod(Method method) {
        Adjacency.Operation operation;
        Incidence.Operation operation2;
        Incidence incidenceAnnotation = method.getAnnotation(Incidence.class);
        if (incidenceAnnotation != null && (operation2 = incidenceAnnotation.operation()) != null && operation2 != Incidence.Operation.AUTO) {
            return operation2 == Incidence.Operation.ADD;
        }
        Adjacency adjacencyAnnotation = method.getAnnotation(Adjacency.class);
        if (adjacencyAnnotation != null && (operation = adjacencyAnnotation.operation()) != null && operation != Adjacency.Operation.AUTO) {
            return operation == Adjacency.Operation.ADD;
        }
        return method.getName().startsWith(ADD);
    }

    public static boolean acceptsIterator(Method method, int parameterIndex) {
        return parameterIndex + 1 == method.getParameterTypes().length && Iterator.class.isAssignableFrom(method.getParameterTypes()[parameterIndex]);
    }

    public static boolean acceptsIterable(Method method, int parameterIndex) {
        return parameterIndex + 1 == method.getParameterTypes().length && Iterable.class.isAssignableFrom(method.getParameterTypes()[parameterIndex]);
    }

    public static boolean acceptsVertexFrame(Method method, int parameterIndex) {
        return parameterIndex + 1 == method.getParameterTypes().length && VertexFrame.class.isAssignableFrom(method.getParameterTypes()[parameterIndex]);
    }

    public static boolean returnsIterator(Method method) {
        return Iterator.class.isAssignableFrom(method.getReturnType());
    }

    public static boolean returnsList(Method method) {
        return List.class.isAssignableFrom(method.getReturnType());
    }

    public static boolean returnsSet(Method method) {
        return Set.class.isAssignableFrom(method.getReturnType());
    }

    public static Type getType(Type[] types, int pos) {
        if (pos >= types.length) {
            throw new IndexOutOfBoundsException("No type can be found at position " + pos);
        }
        return types[pos];
    }

    public static Class<?> getActualType(Type genericType, int pos) {
        if (genericType == null) {
            return null;
        }
        if (!ParameterizedType.class.isAssignableFrom(genericType.getClass())) {
            if (genericType instanceof TypeVariable) {
                genericType = ReflectionUtility.getType(((TypeVariable)genericType).getBounds(), pos);
            } else if (genericType instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)genericType;
                Type[] bounds = wildcardType.getLowerBounds();
                if (bounds.length == 0) {
                    bounds = wildcardType.getUpperBounds();
                }
                genericType = ReflectionUtility.getType(bounds, pos);
            }
            Class<?> cls = (Class<?>)genericType;
            return cls.isArray() ? cls.getComponentType() : cls;
        }
        ParameterizedType paramType = (ParameterizedType)genericType;
        Type t = ReflectionUtility.getType(paramType.getActualTypeArguments(), pos);
        return t instanceof Class ? (Class<?>)t : ReflectionUtility.getActualType(t, pos);
    }

    public static Class getGenericClass(Method method) {
        Type returnType = method.getGenericReturnType();
        return ReflectionUtility.getActualType(returnType, 0);
    }
}

