/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.util;

import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.furnace.util.OperatingSystemUtils;

public final class SecurityActions {
    private static final Logger log = Logger.getLogger(SecurityActions.class.getName());

    private SecurityActions() {
    }

    public static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public static void setContextClassLoader(final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
    }

    public static void cleanupThreadLocals(Thread thread) {
        if (!OperatingSystemUtils.isJava8()) {
            return;
        }
        try {
            if (thread != null) {
                SecurityActions.cleanField(thread, Thread.class.getDeclaredField("threadLocals"));
                SecurityActions.cleanField(thread, Thread.class.getDeclaredField("inheritableThreadLocals"));
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed to cleanup ThreadLocal instances for Thread [" + thread + "]", e);
        }
    }

    private static void cleanField(Thread thread, Field threadLocalsField) throws IllegalAccessException, ClassNotFoundException, NoSuchFieldException {
        threadLocalsField.setAccessible(true);
        Object threadLocalTable = threadLocalsField.get(thread);
        Class<?> threadLocalMapClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
        Field tableField = threadLocalMapClass.getDeclaredField("table");
        tableField.setAccessible(true);
        if (threadLocalTable != null) {
            Object table = tableField.get(threadLocalTable);
            Field referentField = Reference.class.getDeclaredField("referent");
            referentField.setAccessible(true);
            for (int i = 0; i < Array.getLength(table); ++i) {
                ThreadLocal threadLocal;
                Object entry = Array.get(table, i);
                if (entry == null || (threadLocal = (ThreadLocal)referentField.get(entry)) == null) continue;
                threadLocal.remove();
            }
        }
    }
}

