/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.diva.analysis;

import com.ibm.wala.cast.java.ipa.callgraph.JavaSourceAnalysisScope;
import com.ibm.wala.cast.java.loader.JavaSourceLoaderImpl;
import com.ibm.wala.cast.java.translator.jdt.ecj.ECJClassLoaderFactory;
import com.ibm.wala.classLoader.BinaryDirectoryTreeModule;
import com.ibm.wala.classLoader.ClassLoaderFactory;
import com.ibm.wala.classLoader.ClassLoaderFactoryImpl;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.SourceDirectoryTreeModule;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphStats;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyFactory;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.strings.StringStuff;
import com.ibm.wala.util.warnings.Warnings;
import io.tackle.diva.Constants;
import io.tackle.diva.Constraint;
import io.tackle.diva.Context;
import io.tackle.diva.Framework;
import io.tackle.diva.Report;
import io.tackle.diva.Standalone;
import io.tackle.diva.Trace;
import io.tackle.diva.Util;
import io.tackle.diva.analysis.JDBCAnalysis;
import io.tackle.diva.analysis.JPAAnalysis;
import io.tackle.diva.analysis.QuarkusAnalysis;
import io.tackle.diva.analysis.ServletAnalysis;
import io.tackle.diva.analysis.SpringBootAnalysis;
import io.tackle.diva.irgen.DivaIRGen;
import io.tackle.diva.irgen.DivaSourceLoaderImpl;
import io.tackle.diva.irgen.FilteredClassHierarchy;
import io.tackle.diva.irgen.ModularAnalysisScope;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.IgnoredArchiveModel;
import org.jboss.windup.graph.model.ProjectDependencyModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.rules.apps.diva.analysis.DivaToWindup;
import org.jboss.windup.rules.apps.diva.model.DivaAppModel;
import org.jboss.windup.rules.apps.diva.model.DivaConstraintModel;
import org.jboss.windup.rules.apps.diva.model.DivaContextModel;
import org.jboss.windup.rules.apps.diva.model.DivaEntryMethodModel;
import org.jboss.windup.rules.apps.diva.model.DivaRequestConstraintModel;
import org.jboss.windup.rules.apps.diva.model.DivaRequestParamModel;
import org.jboss.windup.rules.apps.diva.model.DivaRestCallOpModel;
import org.jboss.windup.rules.apps.diva.service.DivaEntryMethodService;
import org.jboss.windup.rules.apps.java.model.JarArchiveModel;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.model.JavaMethodModel;
import org.jboss.windup.rules.apps.java.model.PropertiesModel;
import org.jboss.windup.rules.apps.java.model.WarArchiveModel;
import org.jboss.windup.rules.apps.java.model.WindupJavaConfigurationModel;
import org.jboss.windup.rules.apps.java.model.project.MavenProjectModel;
import org.jboss.windup.rules.apps.java.service.WindupJavaConfigurationService;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class DivaLauncher
extends GraphOperation {
    private static final Logger LOG = Logger.getLogger(DivaLauncher.class.getName());

    public void perform(GraphRewrite event, EvaluationContext context) {
        Boolean enableDiva = event.getGraphContext().getOptionMap().getOrDefault("enableTransactionAnalysis", Boolean.FALSE);
        if (!enableDiva.booleanValue()) {
            LOG.info("Skipping Diva analysis as enableTransactionAnalysis option isn't set.");
            return;
        }
        try {
            Util.injectedCall((Map)DivaIRGen.advices(), (String[])new String[]{"org.jboss.windup.rules.apps.diva.analysis"}, (String[])new String[0], (String)(DivaLauncher.class.getName() + ".launch"), (Object[])new Object[]{event, context});
        }
        catch (Exception e) {
            throw new WindupException((Throwable)e);
        }
    }

    public static void launch(GraphRewrite event, EvaluationContext context) throws Exception {
        Object clf;
        String[] stdlibs;
        JavaSourceAnalysisScope scope;
        boolean treeStructured;
        final GraphContext gc = event.getGraphContext();
        Boolean sourceMode = event.getGraphContext().getOptionMap().getOrDefault("sourceMode", Boolean.FALSE);
        WindupConfigurationModel cfg = WindupConfigurationService.getConfigurationModel((GraphContext)gc);
        WindupJavaConfigurationModel javaCfg = WindupJavaConfigurationService.getJavaConfigurationModel((GraphContext)gc);
        List projects = gc.getQuery(ProjectModel.class).traverse(g -> g.filter((Traversal)__.out((String[])new String[]{"projectModelToFile"}).has("w:winduptype", (Object)"SourceFileModel"))).toList(ProjectModel.class);
        List notMaven = Util.makeList((Iterable)Util.filter((Iterable)projects, p -> !(p instanceof MavenProjectModel)));
        Path temp = cfg.getOutputPath().asFile().toPath().resolve("diva-temp");
        LOG.info("Diva: tempdir=" + temp);
        boolean bl = treeStructured = sourceMode != false && !projects.isEmpty() && notMaven.isEmpty();
        if (treeStructured) {
            List mavenProjects = Util.makeList((Iterable)Util.map((Iterable)projects, p -> (MavenProjectModel)p));
            for (MavenProjectModel m2 : mavenProjects) {
                List<MavenProjectModel> deps = DivaLauncher.getMavenDeps(m2, mavenProjects);
                if (deps.size() <= 1) continue;
                treeStructured = false;
                break;
            }
        }
        boolean isMultiModular = treeStructured;
        LOG.info("Diva runs in " + (sourceMode != false ? "source" : "binary") + " mode" + (isMultiModular ? ", with multi-modular analysis." : "."));
        if (isMultiModular) {
            final ModularAnalysisScope mods = new ModularAnalysisScope();
            scope = mods;
            stdlibs = Framework.loadStandardLib((AnalysisScope)mods, (Path)temp);
            FileUtils.forceDeleteOnExit((File)temp.toFile());
            List mavenProjects = Util.makeList((Iterable)Util.map((Iterable)projects, p -> (MavenProjectModel)p));
            for (MavenProjectModel m3 : mavenProjects) {
                List<MavenProjectModel> deps;
                LOG.info("Project: " + m3.toPrettyString());
                Stack<MavenProjectModel> todo = new Stack<MavenProjectModel>();
                todo.push(m3);
                while (!(deps = DivaLauncher.getMavenDeps(m3, mavenProjects)).isEmpty()) {
                    m3 = deps.get(0);
                    todo.push(m3);
                }
                ClassLoaderReference parent = ClassLoaderReference.Application;
                while (!todo.isEmpty()) {
                    m3 = (MavenProjectModel)todo.pop();
                    File f = new File(m3.getRootFileModel().getFilePath() + "/src/main/java");
                    if (!f.exists()) continue;
                    parent = mods.findOrCreateModuleLoader(m3.getName(), (Module)new SourceDirectoryTreeModule(f), parent);
                }
            }
            clf = new ClassLoaderFactoryImpl(scope.getExclusions(), (AnalysisScope)scope){
                final /* synthetic */ AnalysisScope val$scope;
                {
                    this.val$scope = analysisScope;
                    super(exclusions);
                }

                protected IClassLoader makeNewClassLoader(ClassLoaderReference classLoaderReference, IClassHierarchy cha, IClassLoader parent, AnalysisScope unused) throws IOException {
                    if (mods.moduleLoaderRefs().contains(classLoaderReference)) {
                        DivaSourceLoaderImpl cl = new DivaSourceLoaderImpl(classLoaderReference, parent, cha, stdlibs);
                        cl.init(mods.getModules(classLoaderReference));
                        return cl;
                    }
                    return super.makeNewClassLoader(classLoaderReference, cha, parent, this.val$scope);
                }
            };
        } else {
            scope = new JavaSourceAnalysisScope(){

                public boolean isApplicationLoader(IClassLoader loader) {
                    return loader.getReference().equals((Object)ClassLoaderReference.Application) || loader.getReference().equals((Object)JavaSourceAnalysisScope.SOURCE);
                }
            };
            Standalone.addDefaultExclusions((AnalysisScope)scope);
            String[] stdlibs_ = Framework.loadStandardLib((AnalysisScope)scope, (Path)temp);
            FileUtils.forceDeleteOnExit((File)temp.toFile());
            if (sourceMode.booleanValue()) {
                ArrayList<String> sourceDirs = new ArrayList<String>();
                for (FileModel file : cfg.getInputPaths()) {
                    String unzipped;
                    if (file.isDirectory()) {
                        sourceDirs.add(file.getFilePath());
                        continue;
                    }
                    if (!(file instanceof ArchiveModel) || (unzipped = ((ArchiveModel)file).getUnzippedDirectory()) == null) continue;
                    sourceDirs.add(unzipped);
                }
                LOG.info("Using root source dirs: " + sourceDirs);
                for (String sourceDir : sourceDirs) {
                    scope.addToScope(JavaSourceAnalysisScope.SOURCE, (Module)new SourceDirectoryTreeModule(new File(sourceDir)));
                }
                stdlibs = stdlibs_;
            } else {
                ArrayList<String> stdList = new ArrayList<String>(Arrays.asList(stdlibs_));
                for (ProjectModel p2 : projects) {
                    LOG.fine("Project: " + p2.toPrettyString());
                    FileModel rootFileModel = p2.getRootFileModel();
                    if (rootFileModel.isDirectory()) {
                        scope.addToScope(ClassLoaderReference.Application, (Module)new BinaryDirectoryTreeModule(rootFileModel.asFile()));
                    }
                    if (!(rootFileModel instanceof ArchiveModel)) continue;
                    Path unzippedPath = Paths.get(((ArchiveModel)rootFileModel).getUnzippedDirectory(), new String[0]);
                    if (rootFileModel instanceof WarArchiveModel) {
                        Path classRoot = unzippedPath.resolve("WEB-INF").resolve("classes");
                        if (!classRoot.toFile().isDirectory()) continue;
                        scope.addToScope(ClassLoaderReference.Application, (Module)new BinaryDirectoryTreeModule(classRoot.toFile()));
                        continue;
                    }
                    if (rootFileModel instanceof JarArchiveModel && !rootFileModel.traverse(g -> g.out(new String[]{"parentArchive"}).has("w:winduptype", (Object)"JarArchiveModel")).toList(JarArchiveModel.class).isEmpty()) {
                        scope.addToScope(ClassLoaderReference.Application, (Module)new BinaryDirectoryTreeModule(unzippedPath.toFile()));
                        continue;
                    }
                    if (!(rootFileModel instanceof JarArchiveModel)) continue;
                    stdList.add(rootFileModel.getFilePath());
                    if (rootFileModel instanceof IgnoredArchiveModel) continue;
                    scope.addToScope(ClassLoaderReference.Application, (Module)new JarFileModule(new JarFile(rootFileModel.getFilePath())));
                }
                stdlibs = stdList.toArray(new String[0]);
            }
            clf = new ECJClassLoaderFactory(scope.getExclusions()){

                protected JavaSourceLoaderImpl makeSourceLoader(ClassLoaderReference classLoaderReference, IClassHierarchy cha, IClassLoader parent) {
                    return new DivaSourceLoaderImpl(classLoaderReference, parent, cha, stdlibs);
                }
            };
        }
        LOG.info("Generating IR from scope = [" + (AnalysisScope)scope + "]");
        DivaIRGen.init();
        ClassHierarchy cha = ClassHierarchyFactory.makeWithRoot((AnalysisScope)scope, (ClassLoaderFactory)clf);
        DivaIRGen.loadKnownIntefaces((IClassHierarchy)cha);
        LOG.info(cha.getNumberOfClasses() + " classes");
        LOG.fine(Warnings.asString());
        HashSet relevantClasses = new HashSet();
        HashSet appClasses = new HashSet();
        Framework.relevantJarsAnalysis((IClassHierarchy)cha, relevantClasses, appClasses, c -> JDBCAnalysis.checkRelevance((IClass)c) || JPAAnalysis.checkRelevance((IClass)c) || SpringBootAnalysis.checkRelevance((IClass)c) || isMultiModular && QuarkusAnalysis.checkRelevance((IClass)c));
        FilteredClassHierarchy filteredCha = new FilteredClassHierarchy((IClassHierarchy)cha, appClasses::contains);
        FilteredClassHierarchy relevantCha = new FilteredClassHierarchy((IClassHierarchy)cha, relevantClasses::contains);
        ArrayList entries = new ArrayList();
        entries.addAll(ServletAnalysis.getEntries((IClassHierarchy)filteredCha));
        entries.addAll(SpringBootAnalysis.getEntries((IClassHierarchy)filteredCha));
        entries.addAll(QuarkusAnalysis.getEntries((IClassHierarchy)filteredCha));
        if (entries.isEmpty()) {
            LOG.info("Diva: Found no entry methods for analysis");
            return;
        }
        ArrayList cgEntries = new ArrayList();
        cgEntries.addAll(entries);
        cgEntries.addAll(SpringBootAnalysis.getInits((IClassHierarchy)relevantCha));
        JPAAnalysis.getEntities((IClassHierarchy)relevantCha);
        AnalysisOptions options = new AnalysisOptions();
        Supplier builder = Framework.chaCgBuilder((IClassHierarchy)cha, (AnalysisOptions)options, cgEntries, m -> relevantClasses.contains(m.getDeclaringClass()));
        LOG.info("Diva: building call graph...");
        CallGraph cg = (CallGraph)builder.get();
        LOG.info("Diva: " + CallGraphStats.getStats((CallGraph)cg));
        Framework fw = new Framework((IClassHierarchy)cha, cg);
        fw.relevanceAnalysis(new Predicate[]{c -> JDBCAnalysis.checkRelevance((IClass)c) || JPAAnalysis.checkRelevance((IClass)c) || SpringBootAnalysis.checkRelevance((IClass)c) || isMultiModular && QuarkusAnalysis.checkRelevance((IClass)c)});
        for (CGNode n : cg) {
            if (!entries.contains(n.getMethod()) || !fw.isRelevant(n)) continue;
            fw.recordContraint((Constraint)new Constraint.EntryConstraint(n));
        }
        fw.traverse((CGNode)cg.getNode(0), (Trace.Visitor)ServletAnalysis.getContextualAnalysis((Framework)fw));
        List contexts = Context.calculateDefaultContexts((Framework)fw);
        final DivaToWindup<DivaContextModel> report = new DivaToWindup<DivaContextModel>(gc, DivaContextModel.class);
        final DivaEntryMethodService entryMethodService = new DivaEntryMethodService(gc);
        final GraphService requestParamService = new GraphService(gc, DivaRequestParamModel.class);
        gc.getGraph().tx().commit();
        int success = 0;
        int failure = 0;
        for (final Context cxt : contexts) {
            try {
                CGNode entry = null;
                for (Constraint c2 : cxt) {
                    if (!(c2 instanceof Constraint.EntryConstraint)) continue;
                    entry = ((Constraint.EntryConstraint)c2).node();
                }
                if (entry != null) {
                    Trace.Visitor txAnalysis = JDBCAnalysis.getTransactionAnalysis((Framework)fw, (Context)cxt).with(SpringBootAnalysis.getTransactionAnalysis((Framework)fw, (Context)cxt).with((Trace.Visitor)JPAAnalysis.getTransactionAnalysis((Framework)fw, (Context)cxt)));
                    if (isMultiModular) {
                        txAnalysis = txAnalysis.with((Trace.Visitor)QuarkusAnalysis.getTransactionAnalysis((Framework)fw, (Context)cxt));
                    }
                    fw.calculateTransactionsWithTimeout(entry, cxt, (Report)new Util.LazyReport(){

                        public void accept(Report.Builder txs) {
                            report.add(map -> {
                                map.put("constraints", r -> {
                                    DivaToWindup cs = (DivaToWindup)r;
                                    for (Constraint c : cxt) {
                                        if (c.category().equals("entry")) {
                                            IMethod m = ((Constraint.EntryConstraint)c).node().getMethod();
                                            DivaEntryMethodModel model = entryMethodService.getOrCreate(StringStuff.jvmToBinaryName((String)m.getDeclaringClass().getName().toString()), m.getName().toString());
                                            for (Annotation a : Util.getAnnotations((IMethod)m)) {
                                                if (a.getType().getName() == Constants.LJavaxWsRsGET) {
                                                    model.setHttpMethod("GET");
                                                } else if (a.getType().getName() == Constants.LJavaxWsRsPOST) {
                                                    model.setHttpMethod("POST");
                                                } else if (a.getType().getName() == Constants.LJavaxWsRsPATCH) {
                                                    model.setHttpMethod("PATCH");
                                                } else if (a.getType().getName() == Constants.LJavaxWsRsDELETE) {
                                                    model.setHttpMethod("DELETE");
                                                }
                                                if (a.getType().getName() != Constants.LJavaxWsRsPath) continue;
                                                model.setUrlPath(DivaLauncher.stripBraces(((AnnotationsReader.ConstantElementValue)a.getNamedArguments().get((Object)"value")).val.toString()));
                                            }
                                            cs.add(model);
                                            continue;
                                        }
                                        if (!c.category().equals("http-param")) continue;
                                        DivaRequestParamModel model = (DivaRequestParamModel)requestParamService.getOrCreateByProperties("paramName", c.type(), new String[]{"paramValue", c.value()});
                                        cs.add((DivaConstraintModel)GraphService.addTypeToModel((GraphContext)gc, (WindupVertexFrame)model, DivaRequestConstraintModel.class));
                                    }
                                });
                                map.put("transactions", txs);
                            });
                        }
                    }, txAnalysis);
                }
                gc.getGraph().tx().commit();
                ++success;
            }
            catch (RuntimeException e) {
                gc.getGraph().tx().rollback();
                ++failure;
            }
            if ((success + failure) % 10 != 0 && cxt != contexts.get(contexts.size() - 1)) continue;
            LOG.info("Diva: transaction analysis: " + (success + failure) + "/" + contexts.size() + " (" + failure + " failures)");
        }
        DivaLauncher.endpointResolution(gc, projects);
        LOG.info("Diva: DONE");
    }

    public static List<MavenProjectModel> getMavenDeps(MavenProjectModel m, List<MavenProjectModel> knownProjects) {
        List candidates = Util.makeList((Iterable)Util.map((Iterable)Util.filter((Iterable)Util.map((Iterable)m.getDependencies(), ProjectDependencyModel::getProjectModel), d -> d instanceof MavenProjectModel), p -> (MavenProjectModel)p));
        ArrayList<MavenProjectModel> res = new ArrayList<MavenProjectModel>();
        for (MavenProjectModel known : knownProjects) {
            if (!Util.any((Iterable)candidates, c -> c.getGroupId().equals(known.getGroupId()) && c.getArtifactId().equals(known.getArtifactId()))) continue;
            res.add(known);
        }
        return res;
    }

    public static String stripBraces(String s) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            b.append(s.charAt(i));
            if (s.charAt(i) != '{') continue;
            while (s.charAt(i) != '}') {
                ++i;
            }
            b.append('}');
        }
        return b.toString();
    }

    public static void endpointResolution(GraphContext gc, List<? extends ProjectModel> projects) {
        LinkedHashMap<String, Properties> appProps = new LinkedHashMap<String, Properties>();
        FileService files = new FileService(gc);
        for (ProjectModel projectModel : projects) {
            String targetPath = Paths.get(projectModel.getRootFileModel().getFilePath(), new String[0]).resolve("src/main/resources/application.properties").toString();
            PropertiesModel file = (PropertiesModel)files.findByPath(targetPath);
            if (file == null) continue;
            try {
                appProps.put(projectModel.getName(), file.getProperties());
            }
            catch (IOException e) {
                LOG.info("Failed to read: " + targetPath);
            }
        }
        Function<ProjectModel, DivaAppModel> toApp = p -> {
            DivaAppModel app;
            if (p instanceof DivaAppModel) {
                app = (DivaAppModel)p;
            } else {
                String datasource;
                app = (DivaAppModel)GraphService.addTypeToModel((GraphContext)gc, (WindupVertexFrame)p, DivaAppModel.class);
                if (appProps.containsKey(p.getName()) && (datasource = (String)((Properties)appProps.get(p.getName())).getOrDefault((Object)"quarkus.datasource.jdbc.url", (Object)null)) != null) {
                    app.setDatasource(datasource);
                }
            }
            return app;
        };
        for (FileModel dockerComposeYaml : gc.getQuery(FileModel.class).traverse(g -> g.has("fileName", (Object)"docker-compose.yml")).toList(FileModel.class)) {
            try {
                Map topLevel = (Map)Util.YAML_SERIALIZER.readValue(new File(dockerComposeYaml.getFilePath()), Object.class);
                Map services = topLevel.getOrDefault("services", topLevel);
                for (Map.Entry e : services.entrySet()) {
                    String targetPath = null;
                    Object build = ((Map)e.getValue()).getOrDefault("build", null);
                    if (build instanceof String) {
                        targetPath = Paths.get(dockerComposeYaml.getParentFile().getFilePath(), new String[0]).resolve((String)build).toFile().getCanonicalPath();
                    } else if (build instanceof Map) {
                        Map buildDict = build;
                        if (buildDict.containsKey("dockerfile")) {
                            targetPath = Paths.get(dockerComposeYaml.getParentFile().getFilePath(), new String[0]).resolve((String)buildDict.get("dockerfile")).toFile().getCanonicalPath();
                        } else if (buildDict.containsKey("context")) {
                            targetPath = Paths.get(dockerComposeYaml.getParentFile().getFilePath(), new String[0]).resolve((String)buildDict.get("context")).toFile().getCanonicalPath();
                        }
                    }
                    if (targetPath == null) continue;
                    String thePath = targetPath;
                    List ps = gc.getQuery(FileModel.class).traverse(g -> g.has("filePath", (Object)thePath).in(new String[]{"projectModelToFile"})).toList(ProjectModel.class);
                    for (ProjectModel p3 : ps) {
                        DivaAppModel app = toApp.apply(p3);
                        app.setEndpointName((String)e.getKey());
                    }
                }
            }
            catch (IOException e1) {
                LOG.info("Failed to read: " + dockerComposeYaml.getFilePath());
            }
        }
        for (DivaContextModel cxt : gc.findAll(DivaContextModel.class)) {
            ProjectModel p4 = (ProjectModel)cxt.traverse(g -> g.out(new String[]{"constraints"}).in(new String[]{"javaMethod"}).out(new String[]{"classFile", "originalSource", "classFile"}).in(new String[]{"projectModelToFile"})).next(ProjectModel.class);
            if (p4 == null) continue;
            DivaAppModel app = toApp.apply(p4);
            app.addContext(cxt);
        }
        for (DivaRestCallOpModel call : gc.findAll(DivaRestCallOpModel.class)) {
            URL url;
            Properties props;
            JavaMethodModel meth;
            JavaClassModel cls;
            List ps;
            if (call.getMethod() == null || (ps = (cls = (meth = call.getMethod()).getJavaClass()).traverse(g -> g.out(new String[]{"originalSource"}).in(new String[]{"projectModelToFile"})).toList(ProjectModel.class)).isEmpty() || (props = (Properties)appProps.getOrDefault(((ProjectModel)ps.get(0)).getName(), null)) == null) continue;
            try {
                url = new URL((String)props.getOrDefault((Object)(cls.getQualifiedName() + "/mp-rest/url"), (Object)null));
            }
            catch (RuntimeException | MalformedURLException e) {
                continue;
            }
            DivaAppModel app = (DivaAppModel)gc.getQuery(DivaAppModel.class).traverse(g -> g.has("endpointName", (Object)url.getHost())).next(DivaAppModel.class);
            if (app == null) continue;
            call.setEndpoint(app);
            List ms = app.traverse(g -> g.out(new String[]{"contexts"}).out(new String[]{"constraints"}).has("urlPath", (Object)call.getUrlPath()).has("httpMethod", (Object)call.getHttpMethod())).toList(DivaEntryMethodModel.class);
            Iterator iterator = ms.iterator();
            if (!iterator.hasNext()) continue;
            DivaEntryMethodModel m = (DivaEntryMethodModel)iterator.next();
            call.setEndpointMethod(m);
            for (DivaContextModel cxt : m.getContexts()) {
                if (!Util.all(cxt.getConstraints(), r -> {
                    if (!(r instanceof DivaRequestConstraintModel)) {
                        return true;
                    }
                    DivaRequestConstraintModel p = (DivaRequestConstraintModel)r;
                    return Util.all(call.getCallParams(), q -> !q.getParamName().equals(p.getParamName()) || q.getParamValue().equals(p.getParamValue()));
                })) continue;
                call.addEndpointContext(cxt);
            }
        }
    }
}

