/*
 * Decompiled with CFR 0.152.
 */
package com.syncleus.ferma.framefactories.annotation;

import com.syncleus.ferma.ClassInitializer;
import com.syncleus.ferma.EdgeFrame;
import com.syncleus.ferma.TVertex;
import com.syncleus.ferma.VertexFrame;
import com.syncleus.ferma.annotations.Incidence;
import com.syncleus.ferma.framefactories.annotation.AbstractMethodHandler;
import com.syncleus.ferma.framefactories.annotation.CachesReflection;
import com.syncleus.ferma.framefactories.annotation.ReflectionUtility;
import com.syncleus.ferma.typeresolvers.TypeResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.tinkerpop.gremlin.structure.Direction;

public class IncidenceMethodHandler
extends AbstractMethodHandler {
    public Class<Incidence> getAnnotationType() {
        return Incidence.class;
    }

    @Override
    public <E> DynamicType.Builder<E> processMethod(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        Parameter[] arguments = method.getParameters();
        if (ReflectionUtility.isAddMethod(method)) {
            if (arguments == null || arguments.length == 0) {
                return this.addEdgeDefault(builder, method, annotation);
            }
            if (arguments.length == 1) {
                if (ClassInitializer.class.isAssignableFrom(arguments[0].getType())) {
                    return this.addEdgeByTypeUntypedEdge(builder, method, annotation);
                }
                return this.addEdgeByObjectUntypedEdge(builder, method, annotation);
            }
            if (arguments.length == 2) {
                if (!ClassInitializer.class.isAssignableFrom(arguments[1].getType())) {
                    throw new IllegalStateException(method.getName() + " was annotated with @Incidence, had two arguments, but the second argument was not of the type ClassInitializer");
                }
                if (ClassInitializer.class.isAssignableFrom(arguments[0].getType())) {
                    return this.addEdgeByTypeTypedEdge(builder, method, annotation);
                }
                return this.addEdgeByObjectTypedEdge(builder, method, annotation);
            }
            throw new IllegalStateException(method.getName() + " was annotated with @Incidence but had more than 1 arguments.");
        }
        if (ReflectionUtility.isGetMethod(method)) {
            if (arguments == null || arguments.length == 0) {
                if (ReflectionUtility.returnsIterator(method)) {
                    return this.getEdgesIteratorDefault(builder, method, annotation);
                }
                if (ReflectionUtility.returnsList(method)) {
                    return this.getEdgesListDefault(builder, method, annotation);
                }
                if (ReflectionUtility.returnsSet(method)) {
                    return this.getEdgesSetDefault(builder, method, annotation);
                }
                return this.getEdgeDefault(builder, method, annotation);
            }
            if (arguments.length == 1) {
                if (!Class.class.isAssignableFrom(arguments[0].getType())) {
                    throw new IllegalStateException(method.getName() + " was annotated with @Incidence, had a single argument, but that argument was not of the type Class");
                }
                if (ReflectionUtility.returnsIterator(method)) {
                    return this.getEdgesIteratorByType(builder, method, annotation);
                }
                if (ReflectionUtility.returnsList(method)) {
                    return this.getEdgesListByType(builder, method, annotation);
                }
                if (ReflectionUtility.returnsSet(method)) {
                    return this.getEdgesSetByType(builder, method, annotation);
                }
                return this.getEdgeByType(builder, method, annotation);
            }
            throw new IllegalStateException(method.getName() + " was annotated with @Incidence but had more than 1 arguments.");
        }
        if (ReflectionUtility.isRemoveMethod(method)) {
            if (arguments == null || arguments.length == 0) {
                throw new IllegalStateException(method.getName() + " was annotated with @Incidence but had no arguments.");
            }
            if (arguments.length == 1) {
                return this.removeEdge(builder, method, annotation);
            }
            throw new IllegalStateException(method.getName() + " was annotated with @Incidence but had more than 1 arguments.");
        }
        throw new IllegalStateException(method.getName() + " was annotated with @Incidence but did not begin with: get, remove");
    }

    private <E> DynamicType.Builder<E> addEdgeDefault(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(AddEdgeDefaultInterceptor.class));
    }

    private <E> DynamicType.Builder<E> addEdgeByTypeUntypedEdge(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(AddEdgeByTypeUntypedEdgeInterceptor.class));
    }

    private <E> DynamicType.Builder<E> addEdgeByObjectUntypedEdge(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(AddEdgeByObjectUntypedEdgeInterceptor.class));
    }

    private <E> DynamicType.Builder<E> addEdgeByTypeTypedEdge(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(AddEdgeByTypeTypedEdgeInterceptor.class));
    }

    private <E> DynamicType.Builder<E> addEdgeByObjectTypedEdge(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(AddEdgeByObjectTypedEdgeInterceptor.class));
    }

    private <E> DynamicType.Builder<E> getEdgesIteratorDefault(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(GetEdgesIteratorDefaultInterceptor.class));
    }

    private <E> DynamicType.Builder<E> getEdgesListDefault(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(GetEdgesListDefaultInterceptor.class));
    }

    private <E> DynamicType.Builder<E> getEdgesSetDefault(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(GetEdgesSetDefaultInterceptor.class));
    }

    private <E> DynamicType.Builder<E> getEdgesIteratorByType(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(GetEdgesIteratorByTypeInterceptor.class));
    }

    private <E> DynamicType.Builder<E> getEdgesListByType(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(GetEdgesListByTypeInterceptor.class));
    }

    private <E> DynamicType.Builder<E> getEdgesSetByType(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(GetEdgesSetByTypeInterceptor.class));
    }

    private <E> DynamicType.Builder<E> getEdgeDefault(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(GetEdgeDefaultInterceptor.class));
    }

    private <E> DynamicType.Builder<E> getEdgeByType(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(GetEdgeByTypeInterceptor.class));
    }

    private <E> DynamicType.Builder<E> removeEdge(DynamicType.Builder<E> builder, Method method, Annotation annotation) {
        return builder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)MethodDelegation.to(RemoveEdgeInterceptor.class));
    }

    public static final class RemoveEdgeInterceptor {
        @RuntimeType
        public static void removeEdge(@This VertexFrame thiz, @Origin Method method, @RuntimeType @Argument(value=0) EdgeFrame edge) {
            edge.remove();
        }
    }

    public static final class GetEdgeByTypeInterceptor {
        @RuntimeType
        public static Object getEdge(@This VertexFrame thiz, @Origin Method method, @RuntimeType @Argument(value=0) Class type) {
            assert (thiz instanceof CachesReflection);
            Incidence annotation = ((CachesReflection)((Object)thiz)).getReflectionCache().getAnnotation(method, Incidence.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            TypeResolver resolver = thiz.getGraph().getTypeResolver();
            switch (direction) {
                case BOTH: {
                    return thiz.traverse(input -> resolver.hasType(input.bothE(new String[]{label}), type)).next(type);
                }
                case IN: {
                    return thiz.traverse(input -> resolver.hasType(input.inE(new String[]{label}), type)).next(type);
                }
                case OUT: {
                    return thiz.traverse(input -> resolver.hasType(input.outE(new String[]{label}), type)).next(type);
                }
            }
            throw new IllegalStateException(method.getName() + " is annotated with a direction other than BOTH, IN, or OUT.");
        }
    }

    public static final class GetEdgeDefaultInterceptor {
        @RuntimeType
        public static Object getEdges(@This VertexFrame thiz, @Origin Method method) {
            assert (thiz instanceof CachesReflection);
            Incidence annotation = ((CachesReflection)((Object)thiz)).getReflectionCache().getAnnotation(method, Incidence.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            switch (direction) {
                case BOTH: {
                    return thiz.traverse(input -> input.bothE(new String[]{label})).next(VertexFrame.class);
                }
                case IN: {
                    return thiz.traverse(input -> input.inE(new String[]{label})).next(VertexFrame.class);
                }
                case OUT: {
                    return thiz.traverse(input -> input.outE(new String[]{label})).next(VertexFrame.class);
                }
            }
            throw new IllegalStateException(method.getName() + " is annotated with a direction other than BOTH, IN, or OUT.");
        }
    }

    public static final class GetEdgesSetByTypeInterceptor {
        @RuntimeType
        public static Set getEdges(@This VertexFrame thiz, @Origin Method method, @RuntimeType @Argument(value=0) Class type) {
            assert (thiz instanceof CachesReflection);
            Incidence annotation = ((CachesReflection)((Object)thiz)).getReflectionCache().getAnnotation(method, Incidence.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            TypeResolver resolver = thiz.getGraph().getTypeResolver();
            switch (direction) {
                case BOTH: {
                    return thiz.traverse(input -> resolver.hasType(input.bothE(new String[]{label}), type)).toSet(type);
                }
                case IN: {
                    return thiz.traverse(input -> resolver.hasType(input.inE(new String[]{label}), type)).toSet(type);
                }
                case OUT: {
                    return thiz.traverse(input -> resolver.hasType(input.outE(new String[]{label}), type)).toSet(type);
                }
            }
            throw new IllegalStateException(method.getName() + " is annotated with a direction other than BOTH, IN, or OUT.");
        }
    }

    public static final class GetEdgesListByTypeInterceptor {
        @RuntimeType
        public static List getEdges(@This VertexFrame thiz, @Origin Method method, @RuntimeType @Argument(value=0) Class type) {
            assert (thiz instanceof CachesReflection);
            Incidence annotation = ((CachesReflection)((Object)thiz)).getReflectionCache().getAnnotation(method, Incidence.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            TypeResolver resolver = thiz.getGraph().getTypeResolver();
            switch (direction) {
                case BOTH: {
                    return thiz.traverse(input -> resolver.hasType(input.bothE(new String[]{label}), type)).toList(type);
                }
                case IN: {
                    return thiz.traverse(input -> resolver.hasType(input.inE(new String[]{label}), type)).toList(type);
                }
                case OUT: {
                    return thiz.traverse(input -> resolver.hasType(input.outE(new String[]{label}), type)).toList(type);
                }
            }
            throw new IllegalStateException(method.getName() + " is annotated with a direction other than BOTH, IN, or OUT.");
        }
    }

    public static final class GetEdgesIteratorByTypeInterceptor {
        @RuntimeType
        public static Iterator getEdges(@This VertexFrame thiz, @Origin Method method, @RuntimeType @Argument(value=0) Class type) {
            assert (thiz instanceof CachesReflection);
            Incidence annotation = ((CachesReflection)((Object)thiz)).getReflectionCache().getAnnotation(method, Incidence.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            TypeResolver resolver = thiz.getGraph().getTypeResolver();
            switch (direction) {
                case BOTH: {
                    return thiz.traverse(input -> resolver.hasType(input.bothE(new String[]{label}), type)).frame(type);
                }
                case IN: {
                    return thiz.traverse(input -> resolver.hasType(input.inE(new String[]{label}), type)).frame(type);
                }
                case OUT: {
                    return thiz.traverse(input -> resolver.hasType(input.outE(new String[]{label}), type)).frame(type);
                }
            }
            throw new IllegalStateException(method.getName() + " is annotated with a direction other than BOTH, IN, or OUT.");
        }
    }

    public static final class GetEdgesSetDefaultInterceptor {
        @RuntimeType
        public static Set getEdges(@This VertexFrame thiz, @Origin Method method) {
            assert (thiz instanceof CachesReflection);
            Incidence annotation = ((CachesReflection)((Object)thiz)).getReflectionCache().getAnnotation(method, Incidence.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            switch (direction) {
                case BOTH: {
                    return thiz.traverse(input -> input.bothE(new String[]{label})).toSet(VertexFrame.class);
                }
                case IN: {
                    return thiz.traverse(input -> input.inE(new String[]{label})).toSet(VertexFrame.class);
                }
                case OUT: {
                    return thiz.traverse(input -> input.outE(new String[]{label})).toSet(VertexFrame.class);
                }
            }
            throw new IllegalStateException(method.getName() + " is annotated with a direction other than BOTH, IN, or OUT.");
        }
    }

    public static final class GetEdgesListDefaultInterceptor {
        @RuntimeType
        public static List getEdges(@This VertexFrame thiz, @Origin Method method) {
            assert (thiz instanceof CachesReflection);
            Incidence annotation = ((CachesReflection)((Object)thiz)).getReflectionCache().getAnnotation(method, Incidence.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            switch (direction) {
                case BOTH: {
                    return thiz.traverse(input -> input.bothE(new String[]{label})).toList(VertexFrame.class);
                }
                case IN: {
                    return thiz.traverse(input -> input.inE(new String[]{label})).toList(VertexFrame.class);
                }
                case OUT: {
                    return thiz.traverse(input -> input.outE(new String[]{label})).toList(VertexFrame.class);
                }
            }
            throw new IllegalStateException(method.getName() + " is annotated with a direction other than BOTH, IN, or OUT.");
        }
    }

    public static final class GetEdgesIteratorDefaultInterceptor {
        @RuntimeType
        public static Iterator getEdges(@This VertexFrame thiz, @Origin Method method) {
            assert (thiz instanceof CachesReflection);
            Incidence annotation = ((CachesReflection)((Object)thiz)).getReflectionCache().getAnnotation(method, Incidence.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            switch (direction) {
                case BOTH: {
                    return thiz.traverse(input -> input.bothE(new String[]{label})).frame(VertexFrame.class);
                }
                case IN: {
                    return thiz.traverse(input -> input.inE(new String[]{label})).frame(VertexFrame.class);
                }
                case OUT: {
                    return thiz.traverse(input -> input.outE(new String[]{label})).frame(VertexFrame.class);
                }
            }
            throw new IllegalStateException(method.getName() + " is annotated with a direction other than BOTH, IN, or OUT.");
        }
    }

    public static final class AddEdgeByObjectTypedEdgeInterceptor {
        @RuntimeType
        public static Object addVertex(@This VertexFrame thiz, @Origin Method method, @RuntimeType @Argument(value=0) VertexFrame newVertex, @RuntimeType @Argument(value=1) ClassInitializer edgeType) {
            assert (thiz instanceof CachesReflection);
            Incidence annotation = ((CachesReflection)((Object)thiz)).getReflectionCache().getAnnotation(method, Incidence.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            switch (direction) {
                case BOTH: {
                    throw new IllegalStateException(method.getName() + " is annotated with direction BOTH, this is not allowed for add methods annotated with @Incidence.");
                }
                case IN: {
                    return thiz.getGraph().addFramedEdge(newVertex, thiz, label, edgeType, new Object[0]);
                }
                case OUT: {
                    return thiz.getGraph().addFramedEdge(thiz, newVertex, label, edgeType, new Object[0]);
                }
            }
            throw new IllegalStateException(method.getName() + " is annotated with a direction other than BOTH, IN, or OUT.");
        }
    }

    public static final class AddEdgeByObjectUntypedEdgeInterceptor {
        @RuntimeType
        public static Object addVertex(@This VertexFrame thiz, @Origin Method method, @RuntimeType @Argument(value=0) VertexFrame newVertex) {
            assert (thiz instanceof CachesReflection);
            Incidence annotation = ((CachesReflection)((Object)thiz)).getReflectionCache().getAnnotation(method, Incidence.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            switch (direction) {
                case BOTH: {
                    throw new IllegalStateException(method.getName() + " is annotated with direction BOTH, this is not allowed for add methods annotated with @Incidence.");
                }
                case IN: {
                    return thiz.getGraph().addFramedEdge(newVertex, thiz, label);
                }
                case OUT: {
                    return thiz.getGraph().addFramedEdge(thiz, newVertex, label);
                }
            }
            throw new IllegalStateException(method.getName() + " is annotated with a direction other than BOTH, IN, or OUT.");
        }
    }

    public static final class AddEdgeByTypeTypedEdgeInterceptor {
        @RuntimeType
        public static Object addVertex(@This VertexFrame thiz, @Origin Method method, @RuntimeType @Argument(value=0) ClassInitializer vertexType, @RuntimeType @Argument(value=1) ClassInitializer edgeType) {
            Object newNode = thiz.getGraph().addFramedVertex(vertexType, new Object[0]);
            assert (newNode instanceof VertexFrame);
            VertexFrame newVertex = (VertexFrame)newNode;
            assert (thiz instanceof CachesReflection);
            Incidence annotation = ((CachesReflection)((Object)thiz)).getReflectionCache().getAnnotation(method, Incidence.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            assert (vertexType.getInitializationType().isInstance(newNode));
            switch (direction) {
                case BOTH: {
                    throw new IllegalStateException(method.getName() + " is annotated with direction BOTH, this is not allowed for add methods annotated with @Incidence.");
                }
                case IN: {
                    return thiz.getGraph().addFramedEdge(newVertex, thiz, label, edgeType, new Object[0]);
                }
                case OUT: {
                    return thiz.getGraph().addFramedEdge(thiz, newVertex, label, edgeType, new Object[0]);
                }
            }
            throw new IllegalStateException(method.getName() + " is annotated with a direction other than BOTH, IN, or OUT.");
        }
    }

    public static final class AddEdgeByTypeUntypedEdgeInterceptor {
        @RuntimeType
        public static Object addVertex(@This VertexFrame thiz, @Origin Method method, @RuntimeType @Argument(value=0) ClassInitializer vertexType) {
            Object newNode = thiz.getGraph().addFramedVertex(vertexType, new Object[0]);
            assert (newNode instanceof VertexFrame);
            VertexFrame newVertex = (VertexFrame)newNode;
            assert (thiz instanceof CachesReflection);
            Incidence annotation = ((CachesReflection)((Object)thiz)).getReflectionCache().getAnnotation(method, Incidence.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            assert (vertexType.getInitializationType().isInstance(newNode));
            switch (direction) {
                case BOTH: {
                    throw new IllegalStateException(method.getName() + " is annotated with direction BOTH, this is not allowed for add methods annotated with @Incidence.");
                }
                case IN: {
                    return thiz.getGraph().addFramedEdge(newVertex, thiz, label);
                }
                case OUT: {
                    return thiz.getGraph().addFramedEdge(thiz, newVertex, label);
                }
            }
            throw new IllegalStateException(method.getName() + " is annotated with a direction other than BOTH, IN, or OUT.");
        }
    }

    public static final class AddEdgeDefaultInterceptor {
        @RuntimeType
        public static Object addEdge(@This VertexFrame thiz, @Origin Method method) {
            TVertex newVertex = thiz.getGraph().addFramedVertex();
            assert (thiz instanceof CachesReflection);
            Incidence annotation = ((CachesReflection)((Object)thiz)).getReflectionCache().getAnnotation(method, Incidence.class);
            Direction direction = annotation.direction();
            String label = annotation.label();
            switch (direction) {
                case BOTH: {
                    throw new IllegalStateException(method.getName() + " is annotated with direction BOTH, this is not allowed for add methods annotated with @Incidence.");
                }
                case IN: {
                    return thiz.getGraph().addFramedEdge(newVertex, thiz, label);
                }
                case OUT: {
                    return thiz.getGraph().addFramedEdge(thiz, newVertex, label);
                }
            }
            throw new IllegalStateException(method.getName() + " is annotated with a direction other than BOTH, IN, or OUT.");
        }
    }
}

