/*
 * Decompiled with CFR 0.152.
 */
package com.syncleus.ferma;

import com.syncleus.ferma.ElementFrame;
import java.util.Comparator;

public abstract class Comparators {
    private static final IdComparator ID_COMPARATOR = new IdComparator();
    private static final IdAsLongComparator ID_AS_LONG_COMPARATOR = new IdAsLongComparator();

    private Comparators() {
    }

    public static Comparator<ElementFrame> id() {
        return ID_COMPARATOR;
    }

    public static Comparator<ElementFrame> idAsLong() {
        return ID_AS_LONG_COMPARATOR;
    }

    public static Comparator<ElementFrame> property(final String property) {
        return new Comparator<ElementFrame>(){

            @Override
            public int compare(ElementFrame t, ElementFrame t1) {
                Comparable c1 = (Comparable)t.getProperty(property);
                Comparable c2 = (Comparable)t1.getProperty(property);
                return c1.compareTo(c2);
            }
        };
    }

    private static final class IdAsLongComparator
    implements Comparator<ElementFrame> {
        private IdAsLongComparator() {
        }

        @Override
        public int compare(ElementFrame t, ElementFrame t1) {
            Long c1 = Long.parseLong((String)t.getId());
            Long c2 = Long.parseLong((String)t1.getId());
            return c1.compareTo(c2);
        }
    }

    private static final class IdComparator
    implements Comparator<ElementFrame> {
        private IdComparator() {
        }

        @Override
        public int compare(ElementFrame t, ElementFrame t1) {
            Comparable c1 = (Comparable)t.getId();
            Comparable c2 = (Comparable)t1.getId();
            return c1.compareTo(c2);
        }
    }
}

