/*
 * Decompiled with CFR 0.152.
 */
package com.syncleus.ferma;

import com.syncleus.ferma.ElementFrame;
import com.syncleus.ferma.FramedGraph;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;

public abstract class AbstractElementFrame
implements ElementFrame {
    private Element element;
    private FramedGraph graph;

    protected void init(FramedGraph graph, Element element) {
        this.graph = graph;
        this.element = element;
    }

    protected void init() {
    }

    @Override
    public <N> N getId() {
        return (N)this.getElement().id();
    }

    @Override
    public Set<String> getPropertyKeys() {
        return this.getElement().keys();
    }

    @Override
    public Class<?> getTypeResolution() {
        return this.getGraph().getTypeResolver().resolve(this.getElement());
    }

    @Override
    public void setTypeResolution(Class<?> type) {
        this.getGraph().getTypeResolver().init(this.getElement(), type);
    }

    @Override
    public void removeTypeResolution() {
        this.getGraph().getTypeResolver().deinit(this.getElement());
    }

    @Override
    public void remove() {
        this.getElement().remove();
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public void setElement(Element element) {
        this.element = element;
    }

    @Override
    public FramedGraph getGraph() {
        return this.graph;
    }

    @Override
    public <T> T getProperty(String name) {
        Property property = this.getElement().property(name);
        if (property.isPresent()) {
            return (T)property.value();
        }
        return null;
    }

    @Override
    public <T> T getProperty(String name, Class<T> type) {
        Property nameProperty = this.getElement().property(name);
        if (!nameProperty.isPresent()) {
            return null;
        }
        Object nameValue = nameProperty.value();
        if (type.isEnum()) {
            return Enum.valueOf(type, nameValue.toString());
        }
        return (T)nameValue;
    }

    @Override
    public void setProperty(String name, Object value) {
        if (value == null) {
            this.getElement().property(name).remove();
        } else if (value instanceof Enum) {
            this.getElement().property(name, (Object)value.toString());
        } else {
            this.getElement().property(name, value);
        }
    }

    public int hashCode() {
        return this.getElement().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        AbstractElementFrame other = (AbstractElementFrame)o;
        return !(this.getElement() == null ? other.getElement() != null : !this.getElement().equals(other.getElement()));
    }

    protected <N> N getId(Class<N> clazz) {
        return this.getId();
    }

    public String toString() {
        return this.getElement().toString();
    }
}

