/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.service;

import com.syncleus.ferma.Traversable;
import com.syncleus.ferma.VertexFrame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.attribute.Text;
import org.janusgraph.util.datastructures.IterablesUtil;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.Service;
import org.jboss.windup.graph.service.exception.NonUniqueResultException;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.FilteredIterator;
import org.jboss.windup.util.Util;
import org.jboss.windup.util.exception.WindupException;

public class GraphService<T extends WindupVertexFrame>
implements Service<T> {
    private final Class<T> type;
    private final GraphContext context;

    public GraphService(GraphContext context, Class<T> type) {
        this.context = context;
        this.type = type;
    }

    public static <T extends WindupVertexFrame> T refresh(GraphContext context, T frame) {
        Vertex v = (Vertex)context.getGraph().traversal().V(new Object[]{(Long)frame.getId()}).next();
        return (T)((WindupVertexFrame)context.getFramed().frameElement((Element)v, WindupVertexFrame.class));
    }

    @Override
    public void commit() {
        ExecutionStatistics.performBenchmarked((String)"GraphService.commit", () -> {
            this.getGraphContext().getGraph().tx().commit();
            return null;
        });
    }

    @Override
    public T create() {
        return (T)((WindupVertexFrame)ExecutionStatistics.performBenchmarked((String)"GraphService.create", () -> (WindupVertexFrame)this.context.getFramed().addFramedVertex(this.type)));
    }

    @Override
    public T addTypeToModel(WindupVertexFrame model) {
        return (T)((WindupVertexFrame)ExecutionStatistics.performBenchmarked((String)"GraphService.addTypeToModel", () -> GraphService.addTypeToModel(this.getGraphContext(), model, this.type)));
    }

    protected Traversable<?, ?> findAllQuery() {
        return this.getGraphContext().getQuery(this.type);
    }

    @Override
    public List<T> findAll() {
        return this.findAllQuery().toList(this.type);
    }

    @Override
    public Iterable<T> findAllByProperties(String[] keys, String[] vals) {
        return (Iterable)ExecutionStatistics.performBenchmarked((String)("GraphService.findAllByProperties(" + Arrays.asList(keys) + ")"), () -> {
            Traversable traversable = this.findAllQuery();
            int j = keys.length;
            for (int i = 0; i < j; ++i) {
                String key = keys[i];
                String val = vals[i];
                traversable = traversable.traverse(g -> g.has(key, (Object)val));
            }
            return traversable.toList(this.type);
        });
    }

    @Override
    public Iterable<T> findAllByProperty(String key, Object value) {
        return this.findAllByProperty(key, value, false);
    }

    public Iterable<T> findAllByProperty(String key, Object value, boolean filterByType) {
        return (Iterable)ExecutionStatistics.performBenchmarked((String)("GraphService.findAllByProperty(" + key + ")"), () -> {
            Class typeSearch = filterByType ? WindupVertexFrame.class : this.type;
            Iterator verticesIterator = this.context.getFramed().getFramedVertices(key, value, typeSearch);
            ArrayList vertices = new ArrayList();
            verticesIterator.forEachRemaining(v -> vertices.add((WindupVertexFrame)v));
            if (!filterByType) {
                return vertices;
            }
            return () -> {
                ModelTypeFilter<T> filter = new ModelTypeFilter<T>(this.type);
                return new FilteredIterator(vertices.iterator(), filter);
            };
        });
    }

    @Override
    public List<T> findAllWithoutProperty(String key, Object value) {
        return (List)ExecutionStatistics.performBenchmarked((String)("GraphService.findAllWithoutProperty(" + key + ")"), () -> this.findAllQuery().getRawTraversal().not((Traversal)__.has((String)key, (P)P.eq((Object)value))).toList().stream().map(v -> this.frame((Vertex)v)).collect(Collectors.toList()));
    }

    @Override
    public List<T> findAllWithoutProperty(String key) {
        return (List)ExecutionStatistics.performBenchmarked((String)("GraphService.findAllWithoutProperty(" + key + ")"), () -> this.findAllQuery().traverse(g -> g.hasNot(key)).toList(this.type));
    }

    @Override
    public Iterable<T> findAllByPropertyMatchingRegex(String key, String ... regex) {
        return (Iterable)ExecutionStatistics.performBenchmarked((String)("GraphService.findAllByPropertyMatchingRegex(" + key + ")"), () -> {
            String regexFinal;
            if (regex.length == 0) {
                return IterablesUtil.emptyIterable();
            }
            if (regex.length == 1) {
                regexFinal = regex[0];
            } else {
                StringBuilder builder = new StringBuilder();
                builder.append("\\b(");
                int i = 0;
                for (String value : regex) {
                    if (i > 0) {
                        builder.append("|");
                    }
                    builder.append(value);
                    ++i;
                }
                builder.append(")\\b");
                regexFinal = builder.toString();
            }
            return this.findAllQuery().traverse(g -> g.has(key, Text.textRegex((Object)regexFinal))).toList(this.type);
        });
    }

    @Override
    public T getById(Object id) {
        return (T)((WindupVertexFrame)this.context.getFramed().getFramedVertex(this.type, id));
    }

    @Override
    public T frame(Vertex vertex) {
        return (T)((WindupVertexFrame)this.getGraphContext().getFramed().frameElement((Element)vertex, this.getType()));
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    protected Traversable<?, ?> getQuery() {
        return this.getGraphContext().getQuery(this.getType());
    }

    @Override
    public T getUnique() throws NonUniqueResultException {
        List<T> results = this.findAll();
        if (!results.iterator().hasNext()) {
            return null;
        }
        Iterator iterator = results.iterator();
        WindupVertexFrame result = (WindupVertexFrame)iterator.next();
        if (iterator.hasNext()) {
            throw new NonUniqueResultException("Expected unique value, but returned non-unique.");
        }
        return (T)result;
    }

    @Override
    public T getUniqueByProperty(String property, Object value) throws NonUniqueResultException {
        return this.getUniqueByProperty(property, value, false);
    }

    public T getUniqueByProperty(String property, Object value, boolean enforceType) throws NonUniqueResultException {
        Iterable<T> results = this.findAllByProperty(property, value, enforceType);
        WindupVertexFrame result = null;
        for (WindupVertexFrame item : results) {
            if (!this.type.isInstance(item)) continue;
            if (result != null) {
                throw new NonUniqueResultException("Expected unique value, but returned non-unique: " + property + " Conflicting models:" + Util.NL + "\t" + StringUtils.join((Object[])item.getClass().getInterfaces(), (String)", ") + Util.NL + "\t\t" + item.toPrettyString() + Util.NL + "\t" + StringUtils.join((Object[])result.getClass().getInterfaces(), (String)", ") + Util.NL + "\t\t" + result.toPrettyString());
            }
            result = item;
        }
        return (T)result;
    }

    protected T getUnique(Traversal<?, ?> query) {
        List results = query.toList();
        if (!results.iterator().hasNext()) {
            return null;
        }
        Iterator iter = results.iterator();
        Object resultObj = iter.next();
        if (iter.hasNext()) {
            throw new NonUniqueResultException("Expected unique value, but returned non-unique.");
        }
        if (!(resultObj instanceof Vertex)) {
            throw new WindupException("Unrecognized type returned by framed query: " + resultObj);
        }
        return this.frame((Vertex)resultObj);
    }

    public T getOrCreateByProperties(String key, String value, String ... kvs) {
        if (kvs.length % 2 != 0) {
            throw new WindupException("Number of arguments should be even.");
        }
        String[] keys = new String[kvs.length / 2 + 1];
        String[] values = new String[kvs.length / 2 + 1];
        keys[0] = key;
        values[0] = value;
        int k = 0;
        while (k < kvs.length) {
            keys[k / 2 + 1] = kvs[k++];
            values[k / 2 + 1] = kvs[k++];
        }
        Iterator<T> iter = this.findAllByProperties(keys, values).iterator();
        if (iter.hasNext()) {
            return (T)((WindupVertexFrame)iter.next());
        }
        T model = this.create();
        model.setProperty(key, (Object)value);
        int k2 = 0;
        while (k2 < kvs.length) {
            model.setProperty(kvs[k2++], (Object)kvs[k2++]);
        }
        return model;
    }

    protected GraphContext getGraphContext() {
        return this.context;
    }

    @Override
    public Transaction newTransaction() {
        return this.context.getGraph().tx();
    }

    public static <T extends WindupVertexFrame> T addTypeToModel(GraphContext graphContext, WindupVertexFrame frame, Class<T> type) {
        Vertex vertex = frame.getElement();
        graphContext.getGraphTypeManager().addTypeToElement(type, (Element)vertex);
        return (T)((WindupVertexFrame)graphContext.getFramed().frameElement((Element)vertex, type));
    }

    public static <T extends WindupVertexFrame> WindupVertexFrame removeTypeFromModel(GraphContext graphContext, WindupVertexFrame frame, Class<T> type) {
        Vertex vertex = frame.getElement();
        graphContext.getGraphTypeManager().removeTypeFromElement(type, (Element)vertex);
        return (WindupVertexFrame)graphContext.getFramed().frameElement((Element)vertex, WindupVertexFrame.class);
    }

    @Override
    public void remove(T model) {
        ExecutionStatistics.performBenchmarked((String)"GraphService.commit", () -> {
            model.getElement().remove();
            return null;
        });
    }

    static class ModelTypeFilter<E extends VertexFrame>
    implements FilteredIterator.Filter<E> {
        Class<E> type;

        public ModelTypeFilter(Class<E> type) {
            this.type = type;
        }

        public boolean accept(E item) {
            return this.type.isInstance(item);
        }
    }
}

