/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;

public final class TraversalUtil {
    private TraversalUtil() {
    }

    public static final <S, E> E apply(Traverser.Admin<S> traverser, Traversal.Admin<S, E> traversal) {
        Traverser.Admin<S> split = traverser.split();
        split.setSideEffects(traversal.getSideEffects());
        split.setBulk(1L);
        traversal.reset();
        traversal.addStart(split);
        try {
            return traversal.next();
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("The provided traverser does not map to a value: " + split + "->" + traversal);
        }
    }

    public static final <S, E> Iterator<E> applyAll(Traverser.Admin<S> traverser, Traversal.Admin<S, E> traversal) {
        Traverser.Admin<S> split = traverser.split();
        split.setSideEffects(traversal.getSideEffects());
        split.setBulk(1L);
        traversal.reset();
        traversal.addStart(split);
        return traversal;
    }

    public static final <S, E> boolean test(Traverser.Admin<S> traverser, Traversal.Admin<S, E> traversal, E end) {
        if (null == end) {
            return TraversalUtil.test(traverser, traversal);
        }
        Traverser.Admin<S> split = traverser.split();
        split.setSideEffects(traversal.getSideEffects());
        split.setBulk(1L);
        traversal.reset();
        traversal.addStart(split);
        Step<?, E> endStep = traversal.getEndStep();
        while (traversal.hasNext()) {
            if (!((Traverser.Admin)endStep.next()).get().equals(end)) continue;
            return true;
        }
        return false;
    }

    public static final <S, E> E applyNullable(Traverser.Admin<S> traverser, Traversal.Admin<S, E> traversal) {
        return (E)(null == traversal ? traverser.get() : TraversalUtil.apply(traverser, traversal));
    }

    public static final <S, E> boolean test(Traverser.Admin<S> traverser, Traversal.Admin<S, E> traversal) {
        Traverser.Admin<S> split = traverser.split();
        split.setSideEffects(traversal.getSideEffects());
        split.setBulk(1L);
        traversal.reset();
        traversal.addStart(split);
        return traversal.hasNext();
    }

    public static final <S, E> E apply(S start, Traversal.Admin<S, E> traversal) {
        traversal.reset();
        traversal.addStart(traversal.getTraverserGenerator().generate(start, traversal.getStartStep(), 1L));
        try {
            return traversal.next();
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("The provided start does not map to a value: " + start + "->" + traversal);
        }
    }

    public static final <S, E> Iterator<E> applyAll(S start, Traversal.Admin<S, E> traversal) {
        traversal.reset();
        traversal.addStart(traversal.getTraverserGenerator().generate(start, traversal.getStartStep(), 1L));
        return traversal;
    }

    public static final <S, E> boolean test(S start, Traversal.Admin<S, E> traversal, E end) {
        if (null == end) {
            return TraversalUtil.test(start, traversal);
        }
        traversal.reset();
        traversal.addStart(traversal.getTraverserGenerator().generate(start, traversal.getStartStep(), 1L));
        Step<?, E> endStep = traversal.getEndStep();
        while (traversal.hasNext()) {
            if (!((Traverser.Admin)endStep.next()).get().equals(end)) continue;
            return true;
        }
        return false;
    }

    public static final <S, E> E applyNullable(S start, Traversal.Admin<S, E> traversal) {
        return (E)(null == traversal ? start : TraversalUtil.apply(start, traversal));
    }

    public static final <S, E> boolean test(S start, Traversal.Admin<S, E> traversal) {
        traversal.reset();
        traversal.addStart(traversal.getTraverserGenerator().generate(start, traversal.getStartStep(), 1L));
        return traversal.hasNext();
    }
}

