/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.finalization;

import java.util.List;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.VertexProgramStep;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.ProfileSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ProfileStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Graph;

public final class ProfileStrategy
extends AbstractTraversalStrategy<TraversalStrategy.FinalizationStrategy>
implements TraversalStrategy.FinalizationStrategy {
    private static final ProfileStrategy INSTANCE = new ProfileStrategy();
    private static final String MARKER = Graph.Hidden.hide("gremlin.profile");

    private ProfileStrategy() {
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        if ((traversal.getParent() instanceof EmptyStep || traversal.getParent() instanceof VertexProgramStep) && TraversalHelper.hasStepOfAssignableClassRecursively(ProfileSideEffectStep.class, traversal)) {
            TraversalHelper.applyTraversalRecursively(t -> t.getEndStep().addLabel(MARKER), traversal);
        }
        if (traversal.getEndStep().getLabels().contains(MARKER)) {
            traversal.getEndStep().removeLabel(MARKER);
            List<Step> steps = traversal.getSteps();
            int numSteps = steps.size();
            for (int i = 0; i < numSteps && !(steps.get(i * 2) instanceof ProfileSideEffectStep); ++i) {
                traversal.addStep(i * 2 + 1, new ProfileStep(traversal));
            }
        }
    }

    public static ProfileStrategy instance() {
        return INSTANCE;
    }
}

