/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.FileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.SourceModule;
import com.ibm.wala.util.io.FileSuffixes;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;

public class SourceFileModule
extends FileModule
implements Module,
ModuleEntry,
SourceModule {
    private final String fileName;

    public SourceFileModule(File f, String fileName, Module container) {
        super(f, container);
        this.fileName = fileName;
    }

    public SourceFileModule(File f, SourceFileModule clonedFrom) {
        super(f, clonedFrom.getContainer());
        this.fileName = clonedFrom.fileName;
    }

    public String toString() {
        return "SourceFileModule:" + this.getFile().toString();
    }

    @Override
    public boolean isClassFile() {
        return false;
    }

    @Override
    public String getClassName() {
        return FileSuffixes.stripSuffix(this.fileName).replace(File.separator.charAt(0), '/');
    }

    @Override
    public boolean isSourceFile() {
        return true;
    }

    @Override
    public Reader getInputReader() {
        return new InputStreamReader(this.getInputStream());
    }

    @Override
    public URL getURL() {
        try {
            return this.getFile().toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new Error("error making URL for " + this.getFile(), e);
        }
    }
}

