/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.analysis.reflection.GetMethodContext;
import com.ibm.wala.analysis.reflection.GetMethodContextInterpreter;
import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.intset.EmptyIntSet;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import java.util.Collection;

public class GetMethodContextSelector
implements ContextSelector {
    protected static final boolean DEBUG = false;
    private final boolean applicationClassesOnly;
    private static final Collection<MethodReference> UNDERSTOOD_METHOD_REFS = HashSetFactory.make();
    private static final IntSet thisParameter;

    public GetMethodContextSelector(boolean applicationClassesOnly) {
        this.applicationClassesOnly = applicationClassesOnly;
    }

    @Override
    public Context getCalleeTarget(CGNode caller, CallSiteReference site, IMethod callee, InstanceKey[] receiver) {
        if (receiver != null && receiver.length > 0 && GetMethodContextSelector.mayUnderstand(callee, receiver[0])) {
            IR ir = caller.getIR();
            SymbolTable symbolTable = ir.getSymbolTable();
            SSAAbstractInvokeInstruction[] invokeInstructions = caller.getIR().getCalls(site);
            if (invokeInstructions.length != 1) {
                return null;
            }
            int use = invokeInstructions[0].getUse(1);
            if (symbolTable.isStringConstant(invokeInstructions[0].getUse(1))) {
                String sym = symbolTable.getStringValue(use);
                ConstantKey<String> ck = GetMethodContextSelector.makeConstantKey(caller.getClassHierarchy(), sym);
                IClass type = GetMethodContextSelector.getTypeConstant(receiver[0]);
                if (!this.applicationClassesOnly || !type.getClassLoader().getReference().equals(ClassLoaderReference.Primordial) && !type.getClassLoader().getReference().equals(ClassLoaderReference.Extension)) {
                    return new GetMethodContext(new PointType(type), ck);
                }
            }
            return null;
        }
        return null;
    }

    private static IClass getTypeConstant(InstanceKey instance) {
        ConstantKey c;
        if (instance instanceof ConstantKey && (c = (ConstantKey)instance).getValue() instanceof IClass) {
            return (IClass)c.getValue();
        }
        return null;
    }

    protected static ConstantKey<String> makeConstantKey(IClassHierarchy cha, String str) {
        IClass cls = cha.lookupClass(TypeReference.JavaLangString);
        ConstantKey<String> ck = new ConstantKey<String>(str, cls);
        return ck;
    }

    private static boolean mayUnderstand(IMethod targetMethod, InstanceKey instance) {
        return UNDERSTOOD_METHOD_REFS.contains(targetMethod.getReference()) && GetMethodContextSelector.getTypeConstant(instance) != null;
    }

    @Override
    public IntSet getRelevantParameters(CGNode caller, CallSiteReference site) {
        if (UNDERSTOOD_METHOD_REFS.contains(site.getDeclaredTarget())) {
            return thisParameter;
        }
        return EmptyIntSet.instance;
    }

    static {
        UNDERSTOOD_METHOD_REFS.add(GetMethodContextInterpreter.GET_METHOD);
        UNDERSTOOD_METHOD_REFS.add(GetMethodContextInterpreter.GET_DECLARED_METHOD);
        thisParameter = IntSetUtil.make((int[])new int[]{0});
    }
}

