/*
 * Decompiled with CFR 0.152.
 */
package io.tackle.diva;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.ibm.wala.cast.java.loader.JavaSourceLoaderImpl;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import io.tackle.diva.Report;
import io.tackle.diva.irgen.DivaIRGen;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.commons.io.IOUtils;

public class Util {
    public static final Logger LOGGER;
    public static String CLASS_DUMP_LOCATION;
    public static ObjectWriter JSON_SERIALIZER;
    public static ObjectMapper YAML_SERIALIZER;
    static Iterator<?> EMPTY_ITER;

    public static void directoryAssurance(String directory) {
        File dir = new File(directory);
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static List<Annotation> getAnnotations(IClass c) {
        ArrayList<Annotation> res = new ArrayList<Annotation>();
        Collection as = c.getClassLoader() instanceof JavaSourceLoaderImpl ? (Collection)DivaIRGen.annotations.get(c.getReference()) : c.getAnnotations();
        for (Annotation annotation : as == null ? Collections.emptySet() : as) {
            res.add(annotation);
        }
        return res;
    }

    public static List<Annotation> getAnnotations(IMethod m) {
        ArrayList<Annotation> res = new ArrayList<Annotation>();
        Collection as = m.getDeclaringClass().getClassLoader() instanceof JavaSourceLoaderImpl ? (Collection)DivaIRGen.annotations.get(m.getReference()) : m.getAnnotations();
        for (Annotation annotation : as == null ? Collections.emptySet() : as) {
            res.add(annotation);
        }
        return res;
    }

    public static List<Annotation> getAnnotations(IMethod m, int param) {
        ArrayList<Annotation> res = new ArrayList<Annotation>();
        if (m.getDeclaringClass().getClassLoader() instanceof JavaSourceLoaderImpl) {
            Collection as = DivaIRGen.annotations.get(Pair.make((Object)m.getReference(), (Object)param));
            for (Annotation annotation : as == null ? Collections.emptySet() : as) {
                res.add(annotation);
            }
        }
        return res;
    }

    public static List<Annotation> getAnnotations(IField f) {
        ArrayList<Annotation> res = new ArrayList<Annotation>();
        Collection as = f.getDeclaringClass().getClassLoader() instanceof JavaSourceLoaderImpl ? (Collection)DivaIRGen.annotations.get(Pair.make((Object)f.getDeclaringClass().getReference(), (Object)f.getName())) : f.getAnnotations();
        for (Annotation annotation : as == null ? Collections.emptySet() : as) {
            res.add(annotation);
        }
        return res;
    }

    public static void injectedCall(Map<String, Class<?>> injectors, String name, Object ... args) throws Exception {
        Util.injectedCall(injectors, new String[0], new String[0], name, args);
    }

    public static void injectedCall(final Map<String, Class<?>> injectors, String[] includes, String[] excludes, String name, Object ... args) throws Exception {
        String pat = "^" + "com.ibm.wala".replace(".", "\\.") + "\\..*";
        pat = pat + "|^" + "org.eclipse.jdt".replace(".", "\\.") + "\\..*";
        pat = pat + "|^" + "io.tackle.diva".replace(".", "\\.") + "\\..*";
        for (String p : includes) {
            pat = pat + "|^" + p.replace(".", "\\.") + "\\..*";
        }
        final Predicate<String> inclusion = Pattern.compile(pat).asPredicate();
        pat = "";
        for (String p : excludes) {
            pat = pat + (pat.isEmpty() ? "^" : "|^") + p.replace(".", "\\.") + "\\..*";
        }
        final Predicate<String> exclusion = pat.isEmpty() ? s -> false : Pattern.compile(pat).asPredicate();
        Class<?> klazz = Class.forName(name.substring(0, name.lastIndexOf(46)));
        String method = name.substring(name.lastIndexOf(46) + 1);
        final HashSet<String> targetClasses = new HashSet<String>();
        for (String target : injectors.keySet()) {
            String targetClass = target.substring(0, target.lastIndexOf(46));
            targetClasses.add(targetClass);
        }
        final ClassLoader delegate = klazz.getClassLoader();
        ClassLoader cl = new ClassLoader(){

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                byte[] bytes;
                Class<?> c = delegate.loadClass(name);
                if (targetClasses.contains(name)) {
                    DynamicType.Builder b = new ByteBuddy().redefine(c);
                    for (String target : injectors.keySet()) {
                        if (!target.startsWith(name)) continue;
                        String targetMethod = target.substring(target.lastIndexOf(46) + 1);
                        b = b.visit((AsmVisitorWrapper)Advice.to((Class)((Class)injectors.get(target))).on((ElementMatcher)(targetMethod.equals("<init>") ? ElementMatchers.isConstructor() : ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.named((String)targetMethod)))));
                    }
                    bytes = b.make().getBytes();
                    LOGGER.fine("Instrumented: " + name);
                    if (CLASS_DUMP_LOCATION != null) {
                        try {
                            String path = CLASS_DUMP_LOCATION + "/" + name.replace('.', '/') + ".class";
                            Util.directoryAssurance(path.substring(0, path.lastIndexOf(47)));
                            FileOutputStream fos = new FileOutputStream(path);
                            fos.write(bytes);
                            fos.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    if (c.getClassLoader() == null || !inclusion.test(name) || exclusion.test(name)) {
                        return c;
                    }
                    String classAsPath = name.replace('.', '/') + ".class";
                    try {
                        bytes = IOUtils.toByteArray((InputStream)c.getClassLoader().getResourceAsStream(classAsPath));
                    }
                    catch (IOException e) {
                        return c;
                    }
                }
                return this.defineClass(name, bytes, 0, bytes.length);
            }

            @Override
            public URL getResource(String name) {
                return delegate.getResource(name);
            }

            @Override
            public InputStream getResourceAsStream(String name) {
                return delegate.getResourceAsStream(name);
            }

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                return delegate.getResources(name);
            }
        };
        Class<?> c = Class.forName(klazz.getName(), false, cl);
        for (Method m : c.getDeclaredMethods()) {
            if (!m.getName().equals(method)) continue;
            m.invoke(null, args);
            break;
        }
    }

    public static void dumpCallGraph(CallGraph cg) throws IOException {
        BitVector seen = new BitVector();
        try (PrintWriter out = new PrintWriter(new FileWriter("cg.dot"));){
            out.println("digraph {");
            out.println("node[shape=plaintext]");
            out.println("rankdir=LR");
            for (CGNode src : cg) {
                if (!seen.contains(src.getGraphNodeId())) {
                    seen.set(src.getGraphNodeId());
                    out.println("n" + src.getGraphNodeId() + " [label=\"" + src.toString() + "\"]");
                }
                for (CGNode tgt : () -> cg.getSuccNodes((Object)src)) {
                    if (!seen.contains(tgt.getGraphNodeId())) {
                        seen.set(tgt.getGraphNodeId());
                        out.println("n" + tgt.getGraphNodeId() + " [label=\"" + tgt.toString() + "\"]");
                    }
                    out.println("n" + src.getGraphNodeId() + " -> n" + tgt.getGraphNodeId());
                }
            }
            out.println("}");
        }
    }

    public static Iterable<IClass> superChain(final IClass c) {
        return () -> new Iterator<IClass>(){
            IClass p;
            {
                this.p = c;
            }

            @Override
            public boolean hasNext() {
                return this.p != null;
            }

            @Override
            public IClass next() {
                IClass c2 = this.p;
                this.p = c2.getSuperclass();
                return c2;
            }
        };
    }

    public static String truncate(Object o) {
        if (o == null) {
            return "null";
        }
        String s = String.join((CharSequence)" ", o.toString().split("[\\n\\s]+"));
        if (s.length() < 50) {
            return s;
        }
        return s.substring(0, 50) + "...";
    }

    public static <T> Iterable<T> makeIterable(final T[] data) {
        return () -> new Iterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < data.length;
            }

            @Override
            public T next() {
                return this.hasNext() ? data[this.i++] : null;
            }
        };
    }

    public static <T> Iterable<T> filter(final Iterable<T> data, final Predicate<T> filter) {
        return () -> new Iterator<T>(){
            Iterator i;
            Object next;
            {
                this.i = data.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (this.i.hasNext()) {
                    this.next = this.i.next();
                    if (!filter.test(this.next)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    Object r = this.next;
                    this.next = null;
                    return r;
                }
                return null;
            }
        };
    }

    public static <S, T> Iterable<T> map(final Iterable<S> data, final Function<S, T> map) {
        return () -> new Iterator<T>(){
            Iterator i;
            {
                this.i = data.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public T next() {
                return map.apply(this.i.next());
            }
        };
    }

    public static <E> boolean any(Iterable<E> input, Predicate<E> f) {
        for (E e : input) {
            if (!f.test(e)) continue;
            return true;
        }
        return false;
    }

    public static <E> boolean all(Iterable<E> input, Predicate<E> f) {
        for (E e : input) {
            if (f.test(e)) continue;
            return false;
        }
        return true;
    }

    public static <E> Iterable<E> concat(final Iterable<E> a, final Iterable<E> b) {
        return () -> new Iterator<E>(){
            Iterator i;
            Iterator j;
            {
                this.i = a.iterator();
                this.j = null;
            }

            @Override
            public boolean hasNext() {
                if (this.j == null) {
                    if (this.i.hasNext()) {
                        return true;
                    }
                    this.i = null;
                    this.j = b.iterator();
                }
                return this.j.hasNext();
            }

            @Override
            public E next() {
                return this.j == null ? this.i.next() : this.j.next();
            }
        };
    }

    public static <E, F> Iterable<F> flatMap(final Iterable<E> a, final Function<E, Iterable<F>> b) {
        return () -> new Iterator<F>(){
            Iterator i;
            Iterator j;
            {
                this.i = a.iterator();
                this.j = null;
            }

            @Override
            public boolean hasNext() {
                while (true) {
                    if (this.j != null && this.j.hasNext()) {
                        return true;
                    }
                    if (!this.i.hasNext()) break;
                    this.j = ((Iterable)b.apply(this.i.next())).iterator();
                }
                return false;
            }

            @Override
            public F next() {
                if (this.j == null && !this.hasNext()) {
                    return null;
                }
                return this.j.next();
            }
        };
    }

    public static <E> Iterable<E> empty() {
        return () -> EMPTY_ITER;
    }

    public static Iterable<Integer> range(final int x) {
        return () -> new Iterator<Integer>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < x;
            }

            @Override
            public Integer next() {
                return this.i++;
            }
        };
    }

    public static Iterable<Integer> makeIterable(final IntSet x) {
        return () -> new Iterator<Integer>(){
            IntIterator i;
            {
                this.i = x.intIterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public Integer next() {
                return this.i.next();
            }
        };
    }

    public static <T> T[] makeArray(Iterable<T> iter, Class<T> c) {
        List<T> temp = Util.makeList(iter);
        Object[] res = (Object[])Array.newInstance(c, temp.size());
        int i = 0;
        for (T t : temp) {
            res[i++] = t;
        }
        return res;
    }

    public static <T> List<T> makeList(Iterable<T> iter) {
        ArrayList<T> temp = new ArrayList<T>();
        for (T v : iter) {
            temp.add(v);
        }
        return temp;
    }

    public static <T> Set<T> makeSet(Iterable<T> iter) {
        LinkedHashSet<T> temp = new LinkedHashSet<T>();
        for (T v : iter) {
            temp.add(v);
        }
        return temp;
    }

    static {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tF %1$tT %4$s %5$s%6$s%n");
        LOGGER = Logger.getLogger("");
        CLASS_DUMP_LOCATION = null;
        Level loglevel = Level.parse(System.getProperty("diva.loglevel", "INFO"));
        LOGGER.setLevel(loglevel);
        LOGGER.getHandlers()[0].setLevel(loglevel);
        DefaultIndenter indenter = new DefaultIndenter("  ", DefaultIndenter.SYS_LF);
        DefaultPrettyPrinter printer = new DefaultPrettyPrinter();
        printer.indentObjectsWith((DefaultPrettyPrinter.Indenter)indenter);
        printer.indentArraysWith((DefaultPrettyPrinter.Indenter)indenter);
        JSON_SERIALIZER = new ObjectMapper().writer((PrettyPrinter)printer);
        YAML_SERIALIZER = new ObjectMapper((JsonFactory)new YAMLFactory());
        EMPTY_ITER = new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Object next() {
                return null;
            }
        };
    }

    public static abstract class LazyReport
    implements Report,
    Consumer<Report.Builder> {
        Report delegate;

        @Override
        public void add(Report.Named.Builder builder) {
            if (this.delegate == null) {
                this.accept(r -> {
                    this.delegate = r;
                });
            }
            this.delegate.add(builder);
        }

        @Override
        public void add(Report.Builder builder) {
            if (this.delegate == null) {
                this.accept(r -> {
                    this.delegate = r;
                });
            }
            this.delegate.add(builder);
        }

        @Override
        public void add(String data) {
            if (this.delegate == null) {
                this.accept(r -> {
                    this.delegate = r;
                });
            }
            this.delegate.add(data);
        }

        @Override
        public void add(Integer data) {
            if (this.delegate == null) {
                this.accept(r -> {
                    this.delegate = r;
                });
            }
            this.delegate.add(data);
        }
    }

    public static class JsonReport
    implements Report {
        List<Object> list;

        public JsonReport(List<Object> list) {
            this.list = list;
        }

        @Override
        public void add(Report.Named.Builder builder) {
            LinkedHashMap<String, Object> value = new LinkedHashMap<String, Object>();
            this.list.add(value);
            builder.build(new Named(value));
        }

        @Override
        public void add(Report.Builder builder) {
            ArrayList<Object> value = new ArrayList<Object>();
            this.list.add(value);
            builder.build(new JsonReport(value));
        }

        @Override
        public void add(String data) {
            this.list.add(data);
        }

        @Override
        public void add(Integer data) {
            this.list.add(data);
        }

        public static class Named
        implements Report.Named {
            Map<String, Object> map;

            public Named(Map<String, Object> map) {
                this.map = map;
            }

            @Override
            public void putPrimitive(String key, Object value) {
                this.map.put(key, value);
            }

            @Override
            public void put(String key, Report.Named.Builder builder) {
                LinkedHashMap<String, Object> value;
                if (!this.map.containsKey(key)) {
                    value = new LinkedHashMap();
                    this.map.put(key, value);
                } else {
                    value = (Map)this.map.get(key);
                }
                builder.build(new Named(value));
            }

            @Override
            public void put(String key, Report.Builder builder) {
                ArrayList<Object> value;
                if (!this.map.containsKey(key)) {
                    value = new ArrayList();
                    this.map.put(key, value);
                } else {
                    value = (List)this.map.get(key);
                }
                builder.build(new JsonReport(value));
            }
        }
    }

    public static class Chain<T extends Chain<T>>
    implements Iterable<T> {
        protected T next;

        public Chain(T next) {
            this.next = next;
        }

        T reverse0() {
            Chain<T> s = this;
            Chain prev = null;
            while (s != null) {
                T next = s.next;
                s.next = prev;
                prev = s;
                s = next;
            }
            return (T)prev;
        }

        public Iterable<T> reversed() {
            return () -> new Iterator<T>(){
                Chain last;
                Chain current;
                {
                    this.current = this.last = this.reverse0();
                }

                @Override
                public boolean hasNext() {
                    return this.current != null;
                }

                @Override
                public T next() {
                    Chain c = this.current;
                    this.current = c.next;
                    if (this.current == null) {
                        this.last.reverse0();
                    }
                    return c;
                }
            };
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                T current;
                {
                    this.current = this;
                }

                @Override
                public boolean hasNext() {
                    return this.current != null;
                }

                @Override
                public T next() {
                    Object c = this.current;
                    this.current = ((Chain)c).next;
                    return c;
                }
            };
        }
    }
}

