/*
 * Decompiled with CFR 0.152.
 */
package io.tackle.diva;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntSet;
import io.tackle.diva.Constraint;
import io.tackle.diva.Framework;
import io.tackle.diva.Trace;
import io.tackle.diva.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class Context
extends ArrayList<Constraint> {
    public Map<IClass, IClass> dispatch;
    public static int MAX_NUM_CONTEXTS = 4096;

    public Map<IClass, IClass> dispatchMap() {
        if (this.dispatch == null) {
            this.dispatch = new LinkedHashMap<IClass, IClass>();
            for (Constraint con : this) {
                if (!(con instanceof Constraint.DispatchConstraint)) continue;
                this.dispatch.put(((Constraint.DispatchConstraint)con).base, ((Constraint.DispatchConstraint)con).impl);
            }
        }
        return this.dispatch;
    }

    public Context(Iterable<Constraint> cs) {
        for (Constraint c : cs) {
            this.add(c);
        }
    }

    public Context() {
    }

    public BitVector calculateReachable(Framework fw, CGNode n) {
        Map<Integer, BitVector> reaching;
        BitVector reachable = null;
        HashSet<Pair> knownKeys = new HashSet<Pair>();
        for (Constraint constraint : this) {
            if (constraint instanceof Constraint.BranchingConstraint && (reaching = ((Constraint.BranchingConstraint)constraint).reachingInstrs()).containsKey(n.getGraphNodeId())) {
                reachable = reachable == null ? reaching.get(n.getGraphNodeId()) : BitVector.and((BitVector)reachable, (BitVector)reaching.get(n.getGraphNodeId()));
            }
            knownKeys.add(Pair.make((Object)constraint.category(), (Object)constraint.type()));
        }
        for (Map.Entry entry : fw.constraints.entrySet()) {
            if (knownKeys.contains(entry.getKey()) || !(((List)entry.getValue()).get(0) instanceof Constraint.BranchingConstraint) || !(reaching = ((Constraint.BranchingConstraint)((List)entry.getValue()).get(0)).defaultConstraint().reachingInstrs()).containsKey(n.getGraphNodeId())) continue;
            if (reachable == null) {
                reachable = reaching.get(n.getGraphNodeId());
                continue;
            }
            reachable = BitVector.and((BitVector)reachable, (BitVector)reaching.get(n.getGraphNodeId()));
        }
        if (reachable != null) {
            return reachable;
        }
        BitVector visited = new BitVector();
        BitVector bitVector = new BitVector();
        IR ir = n.getIR();
        int i = 0;
        bitVector.set(i);
        while (!bitVector.isZero()) {
            SSAConditionalBranchInstruction c;
            i = bitVector.nextSetBit(0);
            bitVector.clear(i);
            visited.set(i);
            if (i >= ir.getInstructions().length) continue;
            SSAInstruction instr = ir.getInstructions()[i];
            if (instr instanceof SSAConditionalBranchInstruction) {
                c = (SSAConditionalBranchInstruction)instr;
                if (c.getTarget() >= 0 && !visited.contains(c.getTarget())) {
                    bitVector.set(c.getTarget());
                }
            } else if (instr instanceof SSASwitchInstruction) {
                c = (SSASwitchInstruction)instr;
                for (int l : c.getCasesAndLabels()) {
                    int j = c.getTarget(l);
                    if (visited.contains(j)) continue;
                    bitVector.set(j);
                }
                if (!visited.contains(c.getDefault())) {
                    bitVector.set(c.getDefault());
                }
            } else if (instr instanceof SSAGotoInstruction && (c = (SSAGotoInstruction)instr).getTarget() >= 0 && !visited.contains(c.getTarget())) {
                bitVector.set(c.getTarget());
            }
            if (instr != null && !instr.isFallThrough() || visited.contains(i + 1)) continue;
            bitVector.set(i + 1);
        }
        return visited;
    }

    public static List<Context> calculateDefaultContexts(Framework fw) throws IOException {
        LinkedHashSet<Context> result = new LinkedHashSet<Context>();
        if (fw.constraints.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Constraint> cons = new ArrayList<Constraint>();
        for (Constraint c : Util.flatMap(fw.constraints.values(), v -> v)) {
            if (!(c instanceof Constraint.EntryConstraint)) continue;
            cons.add(c);
        }
        for (Constraint c : Util.flatMap(fw.constraints.values(), v -> v)) {
            if (c instanceof Constraint.EntryConstraint || c instanceof Constraint.BranchingConstraint && !((Constraint.BranchingConstraint)c).isRelevant()) continue;
            cons.add(c);
        }
        Stack<BitVectorIntSet> stack = new Stack<BitVectorIntSet>();
        stack.add(new BitVectorIntSet());
        while (result.size() < MAX_NUM_CONTEXTS && !stack.isEmpty()) {
            int k;
            IntSet v2 = (IntSet)stack.pop();
            int n = k = v2.isEmpty() ? 0 : v2.max() + 1;
            while (k < cons.size()) {
                Iterator<Constraint> c = (Constraint)cons.get(k);
                if (!(v2.isEmpty() && !(c instanceof Constraint.EntryConstraint) || Util.any(Util.makeIterable(v2), arg_0 -> Context.lambda$calculateDefaultContexts$2(cons, (Constraint)((Object)c), arg_0)))) {
                    BitVectorIntSet w = new BitVectorIntSet(v2);
                    w.add(k);
                    stack.push(w);
                }
                ++k;
            }
            if (v2.isEmpty()) continue;
            Context cxt = new Context();
            for (Constraint c2 : Util.map(Util.makeIterable(v2), cons::get)) {
                cxt.add(c2);
            }
            result.add(cxt);
        }
        ArrayList<Object> json = new ArrayList<Object>();
        Util.JsonReport report = new Util.JsonReport(json);
        for (Context cxt : result) {
            report.add(map -> {
                for (Constraint c : cxt) {
                    c.report(map);
                }
            });
        }
        try (FileWriter f = new FileWriter("contexts.yml");){
            f.write(Util.YAML_SERIALIZER.writeValueAsString(json));
        }
        return new ArrayList<Context>(result);
    }

    public static List<Context> loadContexts(Framework fw, String file) throws JsonParseException, JsonMappingException, IOException {
        List data = (List)Util.YAML_SERIALIZER.readValue(new File(file), Object.class);
        ArrayList<Context> result = new ArrayList<Context>();
        for (Map e : data) {
            Context cxt = new Context();
            for (Map.Entry e2 : e.entrySet()) {
                for (Map.Entry e3 : ((Map)e2.getValue()).entrySet()) {
                    for (Constraint c : fw.constraints.get(Pair.make(e2.getKey(), e3.getKey()))) {
                        if (!((List)e3.getValue()).contains(c.value())) continue;
                        cxt.add(c);
                    }
                }
            }
            result.add(cxt);
        }
        return result;
    }

    @Override
    public int hashCode() {
        int result = 1;
        for (Constraint element : this) {
            result = 31 * result + System.identityHashCode(element);
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Context)) {
            return false;
        }
        Context other = (Context)o;
        if (this.size() != other.size()) {
            return false;
        }
        for (int k = 0; k < this.size(); ++k) {
            if (this.get(k) == other.get(k)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$calculateDefaultContexts$2(List cons, Constraint c, Integer i) {
        return ((Constraint)cons.get(i)).forbids(c) || c.forbids((Constraint)cons.get(i));
    }

    public abstract class InstructionVisitor
    implements Trace.InstructionVisitor {
        @Override
        public void visitNode(Trace trace) {
            trace.setContext(Context.this);
        }

        @Override
        public void visitCallSite(Trace trace) {
        }
    }

    public abstract class NodeVisitor
    implements Trace.NodeVisitor {
        @Override
        public void visitNode(Trace trace) {
            trace.setContext(Context.this);
            this.visitNode(trace, Context.this);
        }

        public abstract void visitNode(Trace var1, Context var2);
    }

    public abstract class CallSiteVisitor
    implements Trace.CallSiteVisitor {
        @Override
        public void visitNode(Trace trace) {
            trace.setContext(Context.this);
        }
    }
}

