/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.tree.impl;

import com.ibm.wala.cast.tree.impl.AbstractSourcePosition;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;

public class LineNumberPosition
extends AbstractSourcePosition {
    private final URL url;
    private final URL localFile;
    private final int lineNumber;

    public LineNumberPosition(URL url, URL localFile, int lineNumber) {
        this.url = url;
        this.localFile = localFile;
        this.lineNumber = lineNumber;
    }

    public int getFirstLine() {
        return this.lineNumber;
    }

    public int getLastLine() {
        return this.lineNumber;
    }

    public int getFirstCol() {
        return -1;
    }

    public int getLastCol() {
        return -1;
    }

    public int getFirstOffset() {
        return -1;
    }

    public int getLastOffset() {
        return -1;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public Reader getReader() throws IOException {
        return new InputStreamReader(this.localFile.openConnection().getInputStream());
    }

    @Override
    public String toString() {
        String nm = this.url.getFile();
        nm = nm.substring(nm.lastIndexOf(47) + 1);
        return '[' + nm + ':' + this.lineNumber + ']';
    }
}

