/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ir.translator;

import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.CAstSymbol;
import com.ibm.wala.cast.tree.visit.CAstVisitor;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.MapUtil;
import java.util.Map;
import java.util.Set;

public class ExposedNamesCollector
extends CAstVisitor<EntityContext> {
    private final Map<CAstEntity, Set<String>> entity2DeclaredNames = HashMapFactory.make();
    private final Map<CAstEntity, Set<String>> entity2ExposedNames = HashMapFactory.make();

    public Map<CAstEntity, Set<String>> getEntity2ExposedNames() {
        return this.entity2ExposedNames;
    }

    public void run(CAstEntity N) {
        this.visitEntities(N, new EntityContext(N), this);
    }

    @Override
    protected EntityContext makeCodeContext(EntityContext context, CAstEntity n) {
        if (n.getKind() == 1) {
            String[] argumentNames;
            for (String arg : argumentNames = n.getArgumentNames()) {
                MapUtil.findOrCreateSet(this.entity2DeclaredNames, (Object)n).add(arg);
            }
        }
        return new EntityContext(n);
    }

    @Override
    protected void leaveDeclStmt(CAstNode n, EntityContext c, CAstVisitor<EntityContext> visitor) {
        CAstSymbol s = (CAstSymbol)n.getChild(0).getValue();
        String nm = s.name();
        MapUtil.findOrCreateSet(this.entity2DeclaredNames, (Object)c.top()).add(nm);
    }

    @Override
    protected void leaveFunctionStmt(CAstNode n, EntityContext c, CAstVisitor<EntityContext> visitor) {
        CAstEntity fn = (CAstEntity)n.getChild(0).getValue();
        String nm = fn.getName();
        MapUtil.findOrCreateSet(this.entity2DeclaredNames, (Object)c.top()).add(nm);
    }

    @Override
    protected void leaveClassStmt(CAstNode n, EntityContext c, CAstVisitor<EntityContext> visitor) {
        CAstEntity fn = (CAstEntity)n.getChild(0).getValue();
        String nm = fn.getName();
        MapUtil.findOrCreateSet(this.entity2DeclaredNames, (Object)c.top()).add(nm);
    }

    private void checkForLexicalAccess(CAstVisitor.Context c, String nm) {
        CAstEntity entity = c.top();
        Set<String> entityNames = this.entity2DeclaredNames.get(entity);
        if (entityNames == null || !entityNames.contains(nm)) {
            CAstEntity declaringEntity = null;
            CAstEntity curEntity = this.getParent(entity);
            while (curEntity != null) {
                Set<String> curEntityNames = this.entity2DeclaredNames.get(curEntity);
                if (curEntityNames != null && curEntityNames.contains(nm)) {
                    declaringEntity = curEntity;
                    break;
                }
                curEntity = this.getParent(curEntity);
            }
            if (declaringEntity != null) {
                MapUtil.findOrCreateSet(this.entity2ExposedNames, declaringEntity).add(nm);
            }
        }
    }

    @Override
    protected void leaveVar(CAstNode n, EntityContext c, CAstVisitor<EntityContext> visitor) {
        String nm = (String)n.getChild(0).getValue();
        this.checkForLexicalAccess(c, nm);
    }

    @Override
    protected void leaveVarAssignOp(CAstNode n, CAstNode v, CAstNode a, boolean pre, EntityContext c, CAstVisitor<EntityContext> visitor) {
        this.checkForLexicalAccess(c, (String)n.getChild(0).getValue());
    }

    @Override
    protected void leaveVarAssign(CAstNode n, CAstNode v, CAstNode a, EntityContext c, CAstVisitor<EntityContext> visitor) {
        this.checkForLexicalAccess(c, (String)n.getChild(0).getValue());
    }

    @Override
    protected boolean doVisit(CAstNode n, EntityContext context, CAstVisitor<EntityContext> visitor) {
        return true;
    }

    @Override
    protected boolean doVisitAssignNodes(CAstNode n, EntityContext context, CAstNode v, CAstNode a, CAstVisitor<EntityContext> visitor) {
        return true;
    }

    static class EntityContext
    implements CAstVisitor.Context {
        private final CAstEntity top;

        EntityContext(CAstEntity top) {
            this.top = top;
        }

        @Override
        public CAstEntity top() {
            return this.top;
        }

        @Override
        public CAstSourcePositionMap getSourceMap() {
            return this.top.getSourceMap();
        }
    }
}

