/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.parser.xml.when;

import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryPropertyComparisonType;
import org.jboss.windup.graph.GraphTypeManager;
import org.jboss.windup.graph.model.WindupFrame;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.util.exception.WindupException;
import org.joox.JOOX;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="graph-query", namespace="http://windup.jboss.org/schema/jboss-ruleset")
public class QueryHandler
implements ElementHandler<Query> {
    public static final String ELEMENT_NAME = "graph-query";
    public static final String DISCRIMINATOR = "discriminator";
    public static final String FROM = "from";
    public static final String AS = "as";
    public static final String PROPERTY = "property";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_SEARCH_TYPE = "searchType";
    @Inject
    private GraphTypeManager graphTypeManager;

    @Override
    public Query processElement(ParserContext handlerManager, Element element) throws ConfigurationException {
        Class typeAsWindupFrame;
        String from = JOOX.$((Element)element).attr(FROM);
        String as = JOOX.$((Element)element).attr(AS);
        String discriminator = JOOX.$((Element)element).attr(DISCRIMINATOR);
        if (StringUtils.isBlank((CharSequence)discriminator)) {
            throw new WindupException("Error loading rule, 'discriminator' attribute must be specified!");
        }
        Query query = null;
        if (StringUtils.isNotBlank((CharSequence)from)) {
            query = (Query)Query.from((String)from);
        }
        if ((typeAsWindupFrame = this.graphTypeManager.getTypeForDiscriminator(discriminator)) == null) {
            throw new WindupException("Error, type: " + discriminator + " not registered!");
        }
        Class<? extends WindupVertexFrame> type = this.cast(typeAsWindupFrame);
        query = query == null ? (Query)Query.fromType(type) : (Query)query.includingType(type);
        List children = JOOX.$((Element)element).children().get();
        for (Element child : children) {
            String propertyName;
            if (!child.getNodeName().equals(PROPERTY) || StringUtils.isBlank((CharSequence)(propertyName = JOOX.$((Element)child).attr(PROPERTY_NAME)))) continue;
            String value = JOOX.$((Element)child).text();
            String propertyType = JOOX.$((Element)child).attr(PROPERTY_TYPE);
            String searchMode = JOOX.$((Element)child).attr(PROPERTY_SEARCH_TYPE);
            if (StringUtils.equals((CharSequence)"BOOLEAN", (CharSequence)propertyType)) {
                query.withProperty(propertyName, (Object)Boolean.valueOf(value));
                continue;
            }
            if (StringUtils.equals((CharSequence)"regex", (CharSequence)searchMode)) {
                query.withProperty(propertyName, QueryPropertyComparisonType.REGEX, (Object)value);
                continue;
            }
            query.withProperty(propertyName, (Object)value);
        }
        if (StringUtils.isNotBlank((CharSequence)as)) {
            query.as(as);
        }
        return query;
    }

    private Class<? extends WindupVertexFrame> cast(Class<? extends WindupFrame> typeAsWindupFrame) {
        if (!WindupVertexFrame.class.isAssignableFrom(typeAsWindupFrame)) {
            throw new WindupException("Only types that are a subclass of " + WindupVertexFrame.class.getCanonicalName() + " are supported by the graph-query element!");
        }
        return typeAsWindupFrame;
    }
}

