/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.parser;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.forge.furnace.util.Visitor;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.TechnologyReferenceAliasTranslator;
import org.jboss.windup.config.metadata.TechnologyReferenceAliasTranslatorLoader;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.util.file.FileSuffixPredicate;
import org.jboss.windup.util.file.FileVisit;

public class XMLTechnologyReferenceAliasTranslatorLoader
implements TechnologyReferenceAliasTranslatorLoader {
    private static final String XML_EXTENSION = ".windup.technologytransformer.xml";
    @Inject
    private Furnace furnace;

    public Collection<TechnologyReferenceAliasTranslator> loadTranslators(RuleLoaderContext ruleLoaderContext) {
        final ArrayList<TechnologyReferenceAliasTranslator> translators = new ArrayList<TechnologyReferenceAliasTranslator>();
        for (Path userRulesPath : ruleLoaderContext.getRulePaths()) {
            Visitor<File> visitor = new Visitor<File>(){

                public void visit(File file) {
                    translators.addAll(XMLTechnologyReferenceAliasTranslatorLoader.this.loadTranslators(file));
                }
            };
            FileVisit.visit((File)userRulesPath.toFile(), (Predicate)new FileSuffixPredicate(XML_EXTENSION), (Visitor)visitor);
        }
        return translators;
    }

    private List<TechnologyReferenceAliasTranslator> loadTranslators(File file) {
        RuleLoaderContext loaderContext = new RuleLoaderContext(Collections.singleton(file.toPath()), null);
        ParserContext parser = new ParserContext(this.furnace, loaderContext);
        parser.setXmlInputPath(file.toPath());
        parser.setXmlInputRootPath(file.getParentFile().toPath());
        return (List)parser.processDocument(file.toURI());
    }
}

