/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.mavenize;

import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Logger;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.jboss.windup.ast.java.data.TypeReferenceLocation;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.service.Service;
import org.jboss.windup.rules.apps.java.archives.model.ArchiveCoordinateModel;
import org.jboss.windup.rules.apps.java.scan.ast.TypeInterestFactory;
import org.jboss.windup.rules.apps.mavenize.ArchiveCoordinateService;
import org.jboss.windup.rules.apps.mavenize.MavenCoord;
import org.jboss.windup.util.Logging;

public class PackagesToContainingMavenArtifactsIndex {
    private static final Logger LOG = Logging.get(PackagesToContainingMavenArtifactsIndex.class);
    public static final String EDGE_USES = "uses";
    private final GraphContext graphContext;

    public PackagesToContainingMavenArtifactsIndex(GraphContext graphContext) {
        this.graphContext = graphContext;
    }

    private Iterable<ProjectModel> getProjectsContainingClassesReferencingPackage(String pkg) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void registerPackagesFromAPI(MavenCoord apiCoords) {
        Iterable<String> packages = this.getPackagesInArtifact(apiCoords);
        for (String pkg : packages) {
            this.registerPackageInTypeInterestFactory(pkg);
        }
    }

    public void markProjectsUsingPackagesFromAPI(MavenCoord apiCoords) {
        Service coordsService = this.graphContext.service(ArchiveCoordinateModel.class);
        Iterable<String> packages = this.getPackagesInArtifact(apiCoords);
        for (String pkg : packages) {
            Iterable<ProjectModel> projects = this.getProjectsContainingClassesReferencingPackage(pkg);
            for (ProjectModel project : projects) {
                ArchiveCoordinateModel apiArchiveRepresentant = new ArchiveCoordinateService(this.graphContext, ArchiveCoordinateModel.class).getSingleOrCreate(apiCoords.getGroupId(), apiCoords.getArtifactId(), null);
                project.getElement().addEdge(EDGE_USES, apiArchiveRepresentant.getElement(), new Object[0]);
            }
        }
    }

    public boolean moduleContainsPackagesFromAPI(ProjectModel projectModel, MavenCoord apiCoords) {
        ArchiveCoordinateModel archive = new ArchiveCoordinateService(this.graphContext, ArchiveCoordinateModel.class).findSingle(apiCoords.getGroupId(), apiCoords.getArtifactId(), null);
        if (archive == null) {
            return false;
        }
        Iterator projectsVerts = archive.getElement().vertices(Direction.IN, new String[]{EDGE_USES});
        Iterator projects = this.graphContext.getFramed().frame(projectsVerts, ProjectModel.class);
        while (projects.hasNext()) {
            ProjectModel project = (ProjectModel)projects.next();
            if (!projectModel.equals(project)) continue;
            return true;
        }
        return false;
    }

    private Iterable<String> getPackagesInArtifact(MavenCoord apiCoords) {
        return Collections.EMPTY_LIST;
    }

    private void registerPackageInTypeInterestFactory(String pkg) {
        TypeInterestFactory.registerInterest(pkg + "_pkg", pkg.replace(".", "\\."), pkg, TypeReferenceLocation.IMPORT);
    }
}

