/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.mavenize;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphTypeManager;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.rules.apps.java.model.project.MavenProjectModel;
import org.jboss.windup.util.Logging;

public class ModuleAnalysisHelper {
    public static final String LAST_RESORT_DEFAULT_GROUP_ID = "com.mycompany.mavenized";
    private static final Logger LOG = Logging.get(ModuleAnalysisHelper.class);
    protected GraphContext graphContext;

    public ModuleAnalysisHelper(GraphContext context) {
        this.graphContext = context;
    }

    String deriveGroupId(ProjectModel projectModel) {
        List scanPackages;
        String groupId;
        if (projectModel instanceof MavenProjectModel) {
            MavenProjectModel mavenProject = (MavenProjectModel)projectModel;
            mavenProject.getGroupId();
        }
        if ((groupId = (String)this.graphContext.getOptionMap().get("mavenizeGroupId")) != null) {
            if (groupId.matches("[a-zA-Z][-_a-zA-Z0-9]*(\\.[a-zA-Z][-_a-zA-Z0-9]*)*")) {
                return groupId;
            }
            LOG.severe("mavenizeGroupId doesn't match the groupId pattern, ignoring: " + groupId);
        }
        if ((scanPackages = (List)this.graphContext.getOptionMap().get("packages")) != null && !scanPackages.isEmpty() && ((String)scanPackages.get(0)).contains(".")) {
            return (String)scanPackages.get(0);
        }
        return LAST_RESORT_DEFAULT_GROUP_ID;
    }

    String deriveGroupIdFromPackages(ProjectModel projectModel) {
        Map pkgsMap = new HashMap();
        HashSet pkgs = new HashSet(1000);
        GraphTraversal pipeline = new GraphTraversalSource((Graph)this.graphContext.getGraph()).V(new Object[]{projectModel});
        pkgsMap = (Map)pipeline.out(new String[]{"projectModelToFile"}).has("w:winduptype", new P((BiPredicate)new BiPredicate<String, String>(){

            @Override
            public boolean test(String o, String o2) {
                return o.contains(o2);
            }
        }, (Object)GraphTypeManager.getTypeValue(JavaClassFileModel.class))).hasKey("packageName", new String[0]).groupCount().by(v -> this.upToThirdDot(this.graphContext, (Vertex)v)).toList().get(0);
        Map.Entry biggest = null;
        for (Map.Entry entry : pkgsMap.entrySet()) {
            if (biggest != null && (Long)biggest.getValue() >= (Long)entry.getValue()) continue;
            biggest = entry;
        }
        if (biggest != null && (Long)biggest.getValue() > (long)(pkgsMap.size() / 2)) {
            return biggest.getKey().toString();
        }
        return null;
    }

    public String upToThirdDot(GraphContext context, Vertex v) {
        JavaClassFileModel javaModel = (JavaClassFileModel)context.getFramed().frameElement((Element)v, JavaClassFileModel.class);
        String pkgName = javaModel.getPackageName();
        int upToThirdDot = StringUtils.ordinalIndexOf((CharSequence)pkgName, (CharSequence)".", (int)3);
        return StringUtils.substring((String)pkgName, (int)0, (int)upToThirdDot);
    }
}

