/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo;

import java.math.BigInteger;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xmlsec.signature.DEREncodedKeyValue;
import org.opensaml.xmlsec.signature.DSAKeyValue;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.KeyValue;
import org.opensaml.xmlsec.signature.RSAKeyValue;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.opensaml.xmlsec.signature.X509Digest;
import org.opensaml.xmlsec.signature.X509IssuerSerial;
import org.opensaml.xmlsec.signature.X509SKI;
import org.opensaml.xmlsec.signature.X509SubjectName;
import org.slf4j.Logger;

public class KeyInfoSupport {
    private static CertificateFactory x509CertFactory;

    protected KeyInfoSupport();

    @Nonnull
    public static List<String> getKeyNames(@Nullable KeyInfo var0);

    public static void addKeyName(@Nonnull KeyInfo var0, @Nullable String var1);

    @Nonnull
    public static List<java.security.cert.X509Certificate> getCertificates(@Nullable KeyInfo var0) throws CertificateException;

    @Nonnull
    public static List<java.security.cert.X509Certificate> getCertificates(@Nullable X509Data var0) throws CertificateException;

    @Nullable
    public static java.security.cert.X509Certificate getCertificate(@Nullable X509Certificate var0) throws CertificateException;

    @Nonnull
    public static List<X509CRL> getCRLs(@Nullable KeyInfo var0) throws CRLException;

    @Nonnull
    public static List<X509CRL> getCRLs(@Nullable X509Data var0) throws CRLException;

    @Nullable
    public static X509CRL getCRL(@Nullable org.opensaml.xmlsec.signature.X509CRL var0) throws CRLException;

    public static void addCertificate(@Nonnull KeyInfo var0, @Nonnull java.security.cert.X509Certificate var1) throws CertificateEncodingException;

    public static void addCRL(@Nonnull KeyInfo var0, @Nonnull X509CRL var1) throws CRLException;

    @Nonnull
    public static X509Certificate buildX509Certificate(java.security.cert.X509Certificate var0) throws CertificateEncodingException;

    @Nonnull
    public static org.opensaml.xmlsec.signature.X509CRL buildX509CRL(X509CRL var0) throws CRLException;

    @Nonnull
    public static X509SubjectName buildX509SubjectName(@Nullable String var0);

    @Nonnull
    public static X509IssuerSerial buildX509IssuerSerial(@Nullable String var0, @Nullable BigInteger var1);

    @Nullable
    public static X509SKI buildX509SKI(@Nonnull java.security.cert.X509Certificate var0);

    @Nonnull
    public static X509Digest buildX509Digest(@Nonnull java.security.cert.X509Certificate var0, @Nonnull String var1) throws NoSuchAlgorithmException, CertificateEncodingException;

    public static void addPublicKey(@Nonnull KeyInfo var0, @Nullable PublicKey var1);

    @Nonnull
    public static RSAKeyValue buildRSAKeyValue(@Nonnull RSAPublicKey var0);

    @Nonnull
    public static DSAKeyValue buildDSAKeyValue(@Nonnull DSAPublicKey var0);

    public static void addDEREncodedPublicKey(@Nonnull KeyInfo var0, @Nonnull PublicKey var1) throws NoSuchAlgorithmException, InvalidKeySpecException;

    @Nonnull
    public static List<PublicKey> getPublicKeys(@Nullable KeyInfo var0) throws KeyException;

    @Nullable
    public static PublicKey getKey(@Nonnull KeyValue var0) throws KeyException;

    @Nonnull
    public static PublicKey getDSAKey(@Nonnull DSAKeyValue var0) throws KeyException;

    @Nonnull
    public static PublicKey getDSAKey(@Nonnull DSAKeyValue var0, @Nonnull DSAParams var1) throws KeyException;

    public static boolean hasCompleteDSAParams(@Nullable DSAKeyValue var0);

    @Nonnull
    public static PublicKey getRSAKey(@Nonnull RSAKeyValue var0) throws KeyException;

    @Nonnull
    public static final BigInteger decodeBigIntegerFromCryptoBinary(@Nonnull String var0);

    @Nonnull
    public static final String encodeCryptoBinaryFromBigInteger(@Nonnull BigInteger var0);

    @Nonnull
    protected static PublicKey buildKey(@Nonnull KeySpec var0, @Nonnull String var1) throws KeyException;

    @Nonnull
    public static PublicKey getKey(@Nonnull DEREncodedKeyValue var0) throws KeyException;

    @Nonnull
    protected static CertificateFactory getX509CertFactory() throws CertificateException;

    @Nullable
    public static KeyInfoGenerator getKeyInfoGenerator(@Nonnull Credential var0, @Nonnull NamedKeyInfoGeneratorManager var1, @Nullable String var2);

    @Nonnull
    private static Logger getLogger();
}

