/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.util.encoding;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.temporal.TemporalUnit;

public class ConversionHelper {
    public static int getTTLSeconds(Duration duration) {
        Preconditions.checkArgument((duration != null && !duration.isZero() ? 1 : 0) != 0, (Object)"Must provide non-zero TTL");
        long ttlSeconds = Math.max(1L, duration.getSeconds());
        assert (ttlSeconds > 0L);
        Preconditions.checkArgument((ttlSeconds <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"tll value is too large [%s] - value overflow", (Object[])new Object[]{duration});
        return (int)ttlSeconds;
    }

    public static int getTTLSeconds(long time, TemporalUnit unit) {
        return ConversionHelper.getTTLSeconds(Duration.of(time, unit));
    }
}

