/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.util.datastructures;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;

public class RandomRemovalList<T>
implements Collection<T>,
Iterator<T> {
    public static final Random random = new Random();
    private List<T> list;
    private static final int numTriesBeforeCompaction = 13;
    private static final double fillFactor = 1.05;
    private int size;
    private int numberOfCompactions;
    private boolean isIterating;

    public RandomRemovalList() {
        this(10);
    }

    public RandomRemovalList(int capacity) {
        this.list = new ArrayList<T>(capacity);
        this.size = 0;
        this.numberOfCompactions = 0;
        this.isIterating = false;
    }

    public RandomRemovalList(Collection<T> objects) {
        this.list = new ArrayList<T>(objects);
        this.size = objects.size();
        this.numberOfCompactions = 0;
        this.isIterating = false;
    }

    @Override
    public boolean add(T obj) {
        Preconditions.checkNotNull(obj, (Object)"Random Removal lists only contain non-null elements");
        Preconditions.checkArgument((!this.isIterating ? 1 : 0) != 0, (Object)"Cannot add to a random removal list while it is being iterated over");
        ++this.size;
        return this.list.add(obj);
    }

    public T getRandom() {
        int pos;
        T element;
        assert (this.size >= 0);
        if (this.size == 0) {
            throw new NoSuchElementException("List is empty");
        }
        int numTries = 0;
        while ((element = this.list.get(pos = random.nextInt(this.list.size()))) == null && ++numTries < 13) {
        }
        if (element != null) {
            this.list.set(pos, null);
            --this.size;
            return element;
        }
        ArrayList<T> newList = new ArrayList<T>((int)Math.ceil(1.05 * (double)this.size));
        for (T obj : this.list) {
            if (obj == null) continue;
            newList.add(obj);
        }
        this.list = newList;
        ++this.numberOfCompactions;
        return this.getRandom();
    }

    @Override
    public int size() {
        assert (this.size >= 0);
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        assert (this.size >= 0);
        return this.size == 0;
    }

    public int getNumCompactions() {
        return this.numberOfCompactions;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean ret = true;
        for (T obj : c) {
            if (this.add(obj)) continue;
            ret = false;
        }
        return ret;
    }

    @Override
    public void clear() {
        this.list.clear();
        this.size = 0;
        this.numberOfCompactions = 0;
    }

    @Override
    public boolean contains(Object o) {
        return o != null && this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean ret = true;
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            ret = false;
        }
        return ret;
    }

    @Override
    public boolean hasNext() {
        this.isIterating = true;
        return !this.isEmpty();
    }

    @Override
    public T next() {
        this.isIterating = true;
        return this.getRandom();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Element has already been removed");
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        throw new UnsupportedOperationException();
    }
}

