/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.internal;

import com.google.common.base.Preconditions;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.schema.JanusGraphSchemaType;
import org.janusgraph.graphdb.relations.RelationIdentifier;
import org.janusgraph.graphdb.types.VertexLabelVertex;
import org.janusgraph.graphdb.types.vertices.EdgeLabelVertex;
import org.janusgraph.graphdb.types.vertices.PropertyKeyVertex;

public final class ElementCategory
extends Enum<ElementCategory> {
    public static final /* enum */ ElementCategory VERTEX = new ElementCategory();
    public static final /* enum */ ElementCategory EDGE = new ElementCategory();
    public static final /* enum */ ElementCategory PROPERTY = new ElementCategory();
    private static final /* synthetic */ ElementCategory[] $VALUES;

    public static ElementCategory[] values() {
        return (ElementCategory[])$VALUES.clone();
    }

    public static ElementCategory valueOf(String name) {
        return Enum.valueOf(ElementCategory.class, name);
    }

    public Class<? extends Element> getElementType() {
        switch (this) {
            case VERTEX: {
                return JanusGraphVertex.class;
            }
            case EDGE: {
                return JanusGraphEdge.class;
            }
            case PROPERTY: {
                return JanusGraphVertexProperty.class;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isRelation() {
        switch (this) {
            case VERTEX: {
                return false;
            }
            case EDGE: 
            case PROPERTY: {
                return true;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isValidConstraint(JanusGraphSchemaType type) {
        Preconditions.checkNotNull((Object)type);
        switch (this) {
            case VERTEX: {
                return type instanceof VertexLabelVertex;
            }
            case EDGE: {
                return type instanceof EdgeLabelVertex;
            }
            case PROPERTY: {
                return type instanceof PropertyKeyVertex;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean matchesConstraint(JanusGraphSchemaType type, JanusGraphElement element) {
        Preconditions.checkArgument((type != null && element != null ? 1 : 0) != 0);
        assert (this.isInstance(element));
        assert (this.isValidConstraint(type));
        switch (this) {
            case VERTEX: {
                return ((JanusGraphVertex)element).vertexLabel().equals(type);
            }
            case EDGE: {
                return ((JanusGraphEdge)element).edgeLabel().equals(type);
            }
            case PROPERTY: {
                return ((JanusGraphVertexProperty)element).propertyKey().equals(type);
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isInstance(JanusGraphElement element) {
        Preconditions.checkNotNull((Object)element);
        return this.getElementType().isAssignableFrom(element.getClass());
    }

    public boolean subsumedBy(Class<? extends Element> clazz) {
        return clazz.isAssignableFrom(this.getElementType());
    }

    public String getName() {
        return this.toString().toLowerCase();
    }

    public JanusGraphElement retrieve(Object elementId, JanusGraphTransaction tx) {
        Preconditions.checkArgument((elementId != null ? 1 : 0) != 0, (Object)"Must provide elementId");
        switch (this) {
            case VERTEX: {
                Preconditions.checkArgument((boolean)(elementId instanceof Long));
                return tx.getVertex((Long)elementId);
            }
            case EDGE: {
                Preconditions.checkArgument((boolean)(elementId instanceof RelationIdentifier));
                return ((RelationIdentifier)elementId).findEdge(tx);
            }
            case PROPERTY: {
                Preconditions.checkArgument((boolean)(elementId instanceof RelationIdentifier));
                return ((RelationIdentifier)elementId).findProperty(tx);
            }
        }
        throw new IllegalArgumentException();
    }

    public static ElementCategory getByClazz(Class<? extends Element> clazz) {
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"Need to provide a element class argument");
        if (Vertex.class.isAssignableFrom(clazz)) {
            return VERTEX;
        }
        if (Edge.class.isAssignableFrom(clazz)) {
            return EDGE;
        }
        if (JanusGraphVertexProperty.class.isAssignableFrom(clazz)) {
            return PROPERTY;
        }
        throw new IllegalArgumentException("Invalid clazz provided: " + clazz);
    }

    public static ElementCategory getByName(String name) {
        for (ElementCategory category : ElementCategory.values()) {
            if (!category.toString().equalsIgnoreCase(name)) continue;
            return category;
        }
        throw new IllegalArgumentException("Unrecognized name: " + name);
    }

    static {
        $VALUES = new ElementCategory[]{VERTEX, EDGE, PROPERTY};
    }
}

