/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.configuration;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import info.ganglia.gmetric4j.gmetric.GMetric;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ClassUtils;
import org.janusgraph.core.JanusGraphConfigurationException;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.attribute.AttributeSerializer;
import org.janusgraph.core.schema.DefaultSchemaMaker;
import org.janusgraph.diskstorage.Backend;
import org.janusgraph.diskstorage.StandardIndexProvider;
import org.janusgraph.diskstorage.StandardStoreManager;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ConfigNamespace;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.MergedConfiguration;
import org.janusgraph.diskstorage.configuration.MixedConfiguration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.backend.CommonsConfiguration;
import org.janusgraph.diskstorage.configuration.backend.KCVSConfiguration;
import org.janusgraph.diskstorage.idmanagement.ConflictAvoidanceMode;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.ttl.TTLKCVSManager;
import org.janusgraph.diskstorage.log.kcvs.KCVSLog;
import org.janusgraph.diskstorage.log.kcvs.KCVSLogManager;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.diskstorage.util.time.TimestampProviders;
import org.janusgraph.graphdb.configuration.JanusGraphConstants;
import org.janusgraph.graphdb.configuration.RegisteredAttributeClass;
import org.janusgraph.graphdb.database.cache.MetricInstrumentedSchemaCache;
import org.janusgraph.graphdb.database.cache.SchemaCache;
import org.janusgraph.graphdb.database.cache.StandardSchemaCache;
import org.janusgraph.graphdb.database.idassigner.VertexIDAssigner;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.janusgraph.graphdb.database.serialize.Serializer;
import org.janusgraph.graphdb.database.serialize.StandardSerializer;
import org.janusgraph.graphdb.tinkerpop.JanusGraphDefaultSchemaMaker;
import org.janusgraph.graphdb.tinkerpop.Tp3DefaultSchemaMaker;
import org.janusgraph.graphdb.types.typemaker.DisableDefaultSchemaMaker;
import org.janusgraph.util.encoding.LongEncoding;
import org.janusgraph.util.stats.MetricManager;
import org.janusgraph.util.stats.NumberUtil;
import org.janusgraph.util.system.ConfigurationUtil;
import org.janusgraph.util.system.LoggerUtil;
import org.janusgraph.util.system.NetworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphDatabaseConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GraphDatabaseConfiguration.class);
    public static final ConfigNamespace ROOT_NS = new ConfigNamespace(null, "root", "Root Configuration Namespace for the JanusGraph Graph Database");
    public static final ConfigNamespace GRAPH_NS = new ConfigNamespace(ROOT_NS, "graph", "General configuration options");
    public static final ConfigOption<Boolean> ALLOW_SETTING_VERTEX_ID = new ConfigOption<Boolean>(GRAPH_NS, "set-vertex-id", "Whether user provided vertex ids should be enabled and JanusGraph's automatic id allocation be disabled. Useful when operating JanusGraph in concert with another storage system that assigns long ids but disables some of JanusGraph's advanced features which can lead to inconsistent data. EXPERT FEATURE - USE WITH GREAT CARE.", ConfigOption.Type.FIXED, false);
    public static final ConfigOption<String> GRAPH_NAME = new ConfigOption<String>(GRAPH_NS, "graphname", "This config option is an optional configuration setting that you may supply when opening a graph. The String value you provide will be the name of your graph. If you use the ConfigurationManagement APIs, then you will be able to access your graph by this String representation using the ConfiguredGraphFactory APIs.", ConfigOption.Type.LOCAL, String.class);
    public static final ConfigOption<TimestampProviders> TIMESTAMP_PROVIDER = new ConfigOption<TimestampProviders>(GRAPH_NS, "timestamps", "The timestamp resolution to use when writing to storage and indices. Sets the time granularity for the entire graph cluster. To avoid potential inaccuracies, the configured time resolution should match those of the backend systems. Some JanusGraph storage backends declare a preferred timestamp resolution that reflects design constraints in the underlying service. When the backend provides a preferred default, and when this setting is not explicitly declared in the config file, the backend default is used and the general default associated with this setting is ignored.  An explicit declaration of this setting overrides both the general and backend-specific defaults.", ConfigOption.Type.FIXED, TimestampProviders.class, TimestampProviders.MICRO);
    public static final ConfigOption<String> UNIQUE_INSTANCE_ID = new ConfigOption<String>(GRAPH_NS, "unique-instance-id", "Unique identifier for this JanusGraph instance.  This must be unique among all instances concurrently accessing the same stores or indexes.  It's automatically generated by concatenating the hostname, process id, and a static (process-wide) counter. Leaving it unset is recommended.", ConfigOption.Type.LOCAL, String.class);
    public static final ConfigOption<Short> UNIQUE_INSTANCE_ID_SUFFIX = new ConfigOption<Short>(GRAPH_NS, "unique-instance-id-suffix", "When this is set and " + UNIQUE_INSTANCE_ID.getName() + " is not, this JanusGraph instance's unique identifier is generated by concatenating the hex encoded hostname to the provided number.", ConfigOption.Type.LOCAL, Short.class);
    public static final ConfigOption<String> INITIAL_JANUSGRAPH_VERSION = new ConfigOption<String>(GRAPH_NS, "janusgraph-version", "The version of JanusGraph with which this database was created. Automatically set on first start. Don't manually set this property.", ConfigOption.Type.FIXED, String.class).hide();
    public static final ConfigOption<String> INITIAL_STORAGE_VERSION = new ConfigOption<String>(GRAPH_NS, "storage-version", "The version of JanusGraph storage schema with which this database was created. Automatically set on first start of graph. Should only ever be changed if upgraing to a new major release version of JanusGraph that contains schema changes", ConfigOption.Type.FIXED, String.class);
    public static ConfigOption<Boolean> ALLOW_UPGRADE = new ConfigOption<Boolean>(GRAPH_NS, "allow-upgrade", "Setting this to true will allow certain fixed values to be updated such as storage-version. This should only be used for upgrading.", ConfigOption.Type.MASKABLE, Boolean.class, false);
    public static final ConfigOption<Boolean> UNIQUE_INSTANCE_ID_HOSTNAME = new ConfigOption<Boolean>(GRAPH_NS, "use-hostname-for-unique-instance-id", "When this is set, this JanusGraph's unique instance identifier is set to the hostname. If " + UNIQUE_INSTANCE_ID_SUFFIX.getName() + " is also set, then the identifier is set to <hostname><suffix>.", ConfigOption.Type.LOCAL, Boolean.class, false);
    public static final ConfigOption<Boolean> REPLACE_INSTANCE_IF_EXISTS = new ConfigOption<Boolean>(GRAPH_NS, "replace-instance-if-exists", "If a JanusGraph instance with the same instance identifier already exists, the usage of this configuration option results in the opening of this graph anwyay.", ConfigOption.Type.LOCAL, Boolean.class, false);
    public static final ConfigOption<String> TITAN_COMPATIBLE_VERSIONS = new ConfigOption<String>(GRAPH_NS, "titan-version", "Titan version for backwards compatibility which this database was created. Automatically set on first start. Don't manually set this property.", ConfigOption.Type.FIXED, String.class).hide();
    public static final ConfigOption<Boolean> ALLOW_STALE_CONFIG = new ConfigOption<Boolean>(GRAPH_NS, "allow-stale-config", "Whether to allow the local and storage-backend-hosted copies of the configuration to contain conflicting values for options with any of the following types: " + Joiner.on((String)", ").join(ConfigOption.getManagedTypes()) + ".  These types are managed globally through the storage backend and cannot be overridden by changing the local configuration.  This type of conflict usually indicates misconfiguration.  When this option is true, JanusGraph will log these option conflicts, but continue normal operation using the storage-backend-hosted value for each conflicted option.  When this option is false, JanusGraph will log these option conflicts, but then it will throw an exception, refusing to start.", ConfigOption.Type.MASKABLE, Boolean.class, true);
    public static final ConfigNamespace REGISTRATION_NS = new ConfigNamespace(ROOT_NS, "system-registration", "This is used internally to keep track of open instances.", true);
    public static final ConfigOption<Instant> REGISTRATION_TIME = new ConfigOption<Instant>(REGISTRATION_NS, "startup-time", "Timestamp when this instance was started.  Automatically set.", ConfigOption.Type.GLOBAL, Instant.class).hide();
    public static final ConfigNamespace JOB_NS = new ConfigNamespace(null, "job", "Root Configuration Namespace for JanusGraph OLAP jobs");
    public static final ConfigOption<Long> JOB_START_TIME = new ConfigOption<Long>(JOB_NS, "start-time", "Timestamp (ms since epoch) when the job started. Automatically set.", ConfigOption.Type.LOCAL, Long.class).hide();
    public static final ConfigNamespace COMPUTER_NS = new ConfigNamespace(ROOT_NS, "computer", "GraphComputer related configuration");
    public static final ConfigOption<String> COMPUTER_RESULT_MODE = new ConfigOption<String>(COMPUTER_NS, "result-mode", "How the graph computer should return the computed results. 'persist' for writing them into the graph, 'localtx' for writing them into the local transaction, or 'none' (default)", ConfigOption.Type.MASKABLE, "none");
    public static final ConfigNamespace TRANSACTION_NS = new ConfigNamespace(ROOT_NS, "tx", "Configuration options for transaction handling");
    public static final ConfigOption<Boolean> SYSTEM_LOG_TRANSACTIONS = new ConfigOption<Boolean>(TRANSACTION_NS, "log-tx", "Whether transaction mutations should be logged to JanusGraph's write-ahead transaction log which can be used for recovery of partially failed transactions", ConfigOption.Type.GLOBAL, false);
    public static final ConfigOption<Duration> MAX_COMMIT_TIME = new ConfigOption<Duration>(TRANSACTION_NS, "max-commit-time", "Maximum time (in ms) that a transaction might take to commit against all backends. This is used by the distributed write-ahead log processing to determine when a transaction can be considered failed (i.e. after this time has elapsed).Must be longer than the maximum allowed write time.", ConfigOption.Type.GLOBAL, Duration.ofSeconds(10L));
    public static final ConfigNamespace TRANSACTION_RECOVERY_NS = new ConfigNamespace(TRANSACTION_NS, "recovery", "Configuration options for transaction recovery processes");
    public static final ConfigOption<Boolean> VERBOSE_TX_RECOVERY = new ConfigOption<Boolean>(TRANSACTION_RECOVERY_NS, "verbose", "Whether the transaction recovery system should print recovered transactions and other activity to standard output", ConfigOption.Type.MASKABLE, false);
    public static final ConfigNamespace QUERY_NS = new ConfigNamespace(ROOT_NS, "query", "Configuration options for query processing");
    public static final ConfigOption<Boolean> IGNORE_UNKNOWN_INDEX_FIELD = new ConfigOption<Boolean>(QUERY_NS, "ignore-unknown-index-key", "Whether to ignore undefined types encountered in user-provided index queries", ConfigOption.Type.MASKABLE, false);
    public static final String UNKNOWN_FIELD_NAME = "unknown_key";
    public static final ConfigOption<Boolean> FORCE_INDEX_USAGE = new ConfigOption<Boolean>(QUERY_NS, "force-index", "Whether JanusGraph should throw an exception if a graph query cannot be answered using an index. Doing solimits the functionality of JanusGraph's graph queries but ensures that slow graph queries are avoided on large graphs. Recommended for production use of JanusGraph.", ConfigOption.Type.MASKABLE, false);
    public static final ConfigOption<Boolean> PROPERTY_PREFETCHING = new ConfigOption<Boolean>(QUERY_NS, "fast-property", "Whether to pre-fetch all properties on first singular vertex property access. This can eliminate backend calls on subsequentproperty access for the same vertex at the expense of retrieving all properties at once. This can be expensive for vertices with many properties", ConfigOption.Type.MASKABLE, true);
    public static final ConfigOption<Boolean> ADJUST_LIMIT = new ConfigOption<Boolean>(QUERY_NS, "smart-limit", "Whether the query optimizer should try to guess a smart limit for the query to ensure responsiveness in light of possibly large result sets. Those will be loaded incrementally if this option is enabled.", ConfigOption.Type.MASKABLE, true);
    public static final ConfigOption<Boolean> USE_MULTIQUERY = new ConfigOption<Boolean>(QUERY_NS, "batch", "Whether traversal queries should be batched when executed against the storage backend. This can lead to significant performance improvement if there is a non-trivial latency to the backend.", ConfigOption.Type.MASKABLE, false);
    public static final ConfigNamespace SCHEMA_NS = new ConfigNamespace(ROOT_NS, "schema", "Schema related configuration options");
    public static final ConfigOption<String> AUTO_TYPE = new ConfigOption<String>(SCHEMA_NS, "default", "Configures the DefaultSchemaMaker to be used by this graph. If set to 'none', automatic schema creation is disabled. Defaults to a blueprints compatible schema maker with MULTI edge labels and SINGLE property keys", ConfigOption.Type.MASKABLE, "default", new Predicate<String>(){

        public boolean apply(@Nullable String s) {
            if (s == null) {
                return false;
            }
            if (preregisteredAutoType.containsKey(s)) {
                return true;
            }
            try {
                Class clazz = ClassUtils.getClass((String)s);
                return DefaultSchemaMaker.class.isAssignableFrom(clazz);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
    });
    private static final Map<String, DefaultSchemaMaker> preregisteredAutoType = ImmutableMap.of((Object)"none", (Object)DisableDefaultSchemaMaker.INSTANCE, (Object)"default", (Object)JanusGraphDefaultSchemaMaker.INSTANCE, (Object)"tp3", (Object)Tp3DefaultSchemaMaker.INSTANCE);
    public static final ConfigOption<Boolean> SCHEMA_CONSTRAINTS = new ConfigOption<Boolean>(SCHEMA_NS, "constraints", "Configures the schema constraints to be used by this graph. If config 'schema.constraints' is set to 'true' and 'schema.default' is set to 'none', then an 'IllegalArgumentException' is thrown for schema constraint violations. If 'schema.constraints' is set to 'true' and 'schema.default' is not set 'none', schema constraints are automatically created as described in the config option 'schema.default'. If 'schema.constraints' is set to 'false' which is the default, then no schema constraints are applied.", ConfigOption.Type.GLOBAL_OFFLINE, false);
    public static final ConfigNamespace CACHE_NS = new ConfigNamespace(ROOT_NS, "cache", "Configuration options that modify JanusGraph's caching behavior");
    public static final ConfigOption<Boolean> DB_CACHE = new ConfigOption<Boolean>(CACHE_NS, "db-cache", "Whether to enable JanusGraph's database-level cache, which is shared across all transactions. Enabling this option speeds up traversals by holding hot graph elements in memory, but also increases the likelihood of reading stale data.  Disabling it forces each transaction to independently fetch graph elements from storage before reading/writing them.", ConfigOption.Type.MASKABLE, false);
    public static final ConfigOption<Double> DB_CACHE_SIZE = new ConfigOption<Double>(CACHE_NS, "db-cache-size", "Size of JanusGraph's database level cache.  Values between 0 and 1 are interpreted as a percentage of VM heap, while larger values are interpreted as an absolute size in bytes.", ConfigOption.Type.MASKABLE, 0.3);
    public static final ConfigOption<Integer> DB_CACHE_CLEAN_WAIT = new ConfigOption<Integer>(CACHE_NS, "db-cache-clean-wait", "How long, in milliseconds, database-level cache will keep entries after flushing them.  This option is only useful on distributed storage backends that are capable of acknowledging writes without necessarily making them immediately visible.", ConfigOption.Type.GLOBAL_OFFLINE, 50);
    public static final ConfigOption<Long> DB_CACHE_TIME = new ConfigOption<Long>(CACHE_NS, "db-cache-time", "Default expiration time, in milliseconds, for entries in the database-level cache. Entries are evicted when they reach this age even if the cache has room to spare. Set to 0 to disable expiration (cache entries live forever or until memory pressure triggers eviction when set to 0).", ConfigOption.Type.GLOBAL_OFFLINE, 10000L);
    public static final ConfigOption<Integer> TX_CACHE_SIZE = new ConfigOption<Integer>(CACHE_NS, "tx-cache-size", "Maximum size of the transaction-level cache of recently-used vertices.", ConfigOption.Type.MASKABLE, 20000);
    public static final ConfigOption<Integer> TX_DIRTY_SIZE = new ConfigOption<Integer>(CACHE_NS, "tx-dirty-size", "Initial size of the transaction-level cache of uncommitted dirty vertices. This is a performance hint for write-heavy, performance-sensitive transactional workloads. If set, it should roughly match the median vertices modified per transaction.", ConfigOption.Type.MASKABLE, Integer.class);
    private static final int TX_DIRTY_SIZE_DEFAULT_WITHOUT_BATCH = 32;
    private static final int TX_DIRTY_SIZE_DEFAULT_WITH_BATCH = 4096;
    public static final ConfigNamespace STORAGE_NS = new ConfigNamespace(ROOT_NS, "storage", "Configuration options for the storage backend.  Some options are applicable only for certain backends.");
    public static final ConfigOption<String> STORAGE_ROOT = new ConfigOption<String>(STORAGE_NS, "root", "Storage root directory for those storage backends that require local storage. If you do not supply storage.directory and you do supply graph.graphname, then your data will be stored in the directory equivalent to <STORAGE_ROOT>/<GRAPH_NAME>.", ConfigOption.Type.LOCAL, String.class);
    public static final ConfigOption<String> STORAGE_DIRECTORY = new ConfigOption<String>(STORAGE_NS, "directory", "Storage directory for those storage backends that require local storage.", ConfigOption.Type.LOCAL, String.class);
    public static final ConfigOption<String> STORAGE_CONF_FILE = new ConfigOption<String>(STORAGE_NS, "conf-file", "Path to a configuration file for those storage backends which require/support a single separate config file.", ConfigOption.Type.LOCAL, String.class);
    public static final ConfigOption<String> STORAGE_BACKEND = new ConfigOption<String>(STORAGE_NS, "backend", "The primary persistence provider used by JanusGraph.  This is required.  It should be set one of JanusGraph's built-in shorthand names for its standard storage backends (shorthands: " + Joiner.on((String)", ").join(StandardStoreManager.getAllShorthands()) + ") or to the full package and classname of a custom/third-party StoreManager implementation.", ConfigOption.Type.LOCAL, String.class);
    public static final ConfigOption<Boolean> STORAGE_READONLY = new ConfigOption<Boolean>(STORAGE_NS, "read-only", "Read-only database", ConfigOption.Type.LOCAL, false);
    public static final ConfigOption<Boolean> STORAGE_BATCH = new ConfigOption<Boolean>(STORAGE_NS, "batch-loading", "Whether to enable batch loading into the storage backend", ConfigOption.Type.LOCAL, false);
    public static final ConfigOption<Boolean> STORAGE_TRANSACTIONAL = new ConfigOption<Boolean>(STORAGE_NS, "transactions", "Enables transactions on storage backends that support them", ConfigOption.Type.MASKABLE, true);
    public static final ConfigOption<Integer> BUFFER_SIZE = new ConfigOption<Integer>(STORAGE_NS, "buffer-size", "Size of the batch in which mutations are persisted", ConfigOption.Type.MASKABLE, 1024, ConfigOption.positiveInt());
    public static final ConfigOption<Duration> STORAGE_WRITE_WAITTIME = new ConfigOption<Duration>(STORAGE_NS, "write-time", "Maximum time (in ms) to wait for a backend write operation to complete successfully. If a backend write operationfails temporarily, JanusGraph will backoff exponentially and retry the operation until the wait time has been exhausted. ", ConfigOption.Type.MASKABLE, Duration.ofSeconds(100L));
    public static final ConfigOption<Duration> STORAGE_READ_WAITTIME = new ConfigOption<Duration>(STORAGE_NS, "read-time", "Maximum time (in ms) to wait for a backend read operation to complete successfully. If a backend read operationfails temporarily, JanusGraph will backoff exponentially and retry the operation until the wait time has been exhausted. ", ConfigOption.Type.MASKABLE, Duration.ofSeconds(10L));
    public static final ConfigOption<Boolean> PARALLEL_BACKEND_OPS = new ConfigOption<Boolean>(STORAGE_NS, "parallel-backend-ops", "Whether JanusGraph should attempt to parallelize storage operations", ConfigOption.Type.MASKABLE, true);
    public static final ConfigOption<String[]> STORAGE_HOSTS = new ConfigOption<String[]>(STORAGE_NS, "hostname", "The hostname or comma-separated list of hostnames of storage backend servers.  This is only applicable to some storage backends, such as cassandra and hbase.", ConfigOption.Type.LOCAL, new String[]{NetworkUtil.getLoopbackAddress()});
    public static final ConfigOption<Integer> STORAGE_PORT = new ConfigOption<Integer>(STORAGE_NS, "port", "The port on which to connect to storage backend servers. For HBase, it is the Zookeeper port.", ConfigOption.Type.LOCAL, Integer.class);
    public static final ConfigOption<String> AUTH_USERNAME = new ConfigOption<String>(STORAGE_NS, "username", "Username to authenticate against backend", ConfigOption.Type.LOCAL, String.class);
    public static final ConfigOption<String> AUTH_PASSWORD = new ConfigOption<String>(STORAGE_NS, "password", "Password to authenticate against backend", ConfigOption.Type.LOCAL, String.class);
    public static final ConfigOption<Duration> CONNECTION_TIMEOUT = new ConfigOption<Duration>(STORAGE_NS, "connection-timeout", "Default timeout, in milliseconds, when connecting to a remote database instance", ConfigOption.Type.MASKABLE, Duration.ofMillis(10000L));
    public static final ConfigOption<Duration> SETUP_WAITTIME = new ConfigOption<Duration>(STORAGE_NS, "setup-wait", "Time in milliseconds for backend manager to wait for the storage backends to become available when JanusGraph is run in server mode", ConfigOption.Type.MASKABLE, Duration.ofMillis(60000L));
    public static final ConfigOption<Integer> PAGE_SIZE = new ConfigOption<Integer>(STORAGE_NS, "page-size", "JanusGraph break requests that may return many results from distributed storage backends into a series of requests for small chunks/pages of results, where each chunk contains up to this many elements.", ConfigOption.Type.MASKABLE, 100);
    public static final ConfigOption<Boolean> DROP_ON_CLEAR = new ConfigOption<Boolean>(STORAGE_NS, "drop-on-clear", "Whether to drop the graph database (true) or delete rows (false) when clearing storage. Note that some backends always drop the graph database when clearing storage. Also note that indices are always dropped when clearing storage.", ConfigOption.Type.MASKABLE, true);
    public static final ConfigNamespace LOCK_NS = new ConfigNamespace(STORAGE_NS, "lock", "Options for locking on eventually-consistent stores");
    public static final ConfigOption<Integer> LOCK_RETRY = new ConfigOption<Integer>(LOCK_NS, "retries", "Number of times the system attempts to acquire a lock before giving up and throwing an exception", ConfigOption.Type.MASKABLE, 3);
    public static final ConfigOption<Duration> LOCK_WAIT = new ConfigOption<Duration>(LOCK_NS, "wait-time", "Number of milliseconds the system waits for a lock application to be acknowledged by the storage backend. Also, the time waited at the end of all lock applications before verifying that the applications were successful. This value should be a small multiple of the average consistent write time.", ConfigOption.Type.GLOBAL_OFFLINE, Duration.ofMillis(100L));
    public static final ConfigOption<Duration> LOCK_EXPIRE = new ConfigOption<Duration>(LOCK_NS, "expiry-time", "Number of milliseconds after which a lock is considered to have expired. Lock applications that were not released are considered expired after this time and released. This value should be larger than the maximum time a transaction can take in order to guarantee that no correctly held applications are expired pre-maturely and as small as possible to avoid dead lock.", ConfigOption.Type.GLOBAL_OFFLINE, Duration.ofMillis(300000L));
    public static final ConfigOption<Boolean> LOCK_CLEAN_EXPIRED = new ConfigOption<Boolean>(LOCK_NS, "clean-expired", "Whether to delete expired locks from the storage backend", ConfigOption.Type.MASKABLE, false);
    public static final ConfigOption<String> LOCK_BACKEND = new ConfigOption<String>(LOCK_NS, "backend", "Locker type to use", ConfigOption.Type.GLOBAL_OFFLINE, "consistentkey");
    public static final ConfigOption<String> LOCK_LOCAL_MEDIATOR_GROUP = new ConfigOption<String>(LOCK_NS, "local-mediator-group", "This option determines the LocalLockMediator instance used for early detection of lock contention between concurrent JanusGraph graph instances within the same process which are connected to the same storage backend.  JanusGraph instances that have the same value for this variable will attempt to discover lock contention among themselves in memory before proceeding with the general-case distributed locking code.  JanusGraph generates an appropriate default value for this option at startup.  Overridding the default is generally only useful in testing.", ConfigOption.Type.LOCAL, String.class);
    public static final ConfigNamespace STORE_META_NS = new ConfigNamespace(STORAGE_NS, "meta", "Meta data to include in storage backend retrievals", true);
    public static final ConfigOption<Boolean> STORE_META_TIMESTAMPS = new ConfigOption<Boolean>(STORE_META_NS, "timestamps", "Whether to include timestamps in retrieved entries for storage backends that automatically annotated entries with timestamps", ConfigOption.Type.GLOBAL, false);
    public static final ConfigOption<Boolean> STORE_META_TTL = new ConfigOption<Boolean>(STORE_META_NS, "ttl", "Whether to include ttl in retrieved entries for storage backends that support storage and retrieval of cell level TTL", ConfigOption.Type.GLOBAL, false);
    public static final ConfigOption<Boolean> STORE_META_VISIBILITY = new ConfigOption<Boolean>(STORE_META_NS, "visibility", "Whether to include visibility in retrieved entries for storage backends that support cell level visibility", ConfigOption.Type.GLOBAL, true);
    public static final ConfigNamespace CLUSTER_NS = new ConfigNamespace(ROOT_NS, "cluster", "Configuration options for multi-machine deployments");
    public static final ConfigOption<Integer> CLUSTER_MAX_PARTITIONS = new ConfigOption<Integer>(CLUSTER_NS, "max-partitions", "The number of virtual partition blocks created in the partitioned graph. This should be larger than the maximum expected number of nodes in the JanusGraph graph cluster. Must be greater than 1 and a power of 2.", ConfigOption.Type.FIXED, 32, integer -> integer != null && integer > 1 && NumberUtil.isPowerOf2(integer.intValue()));
    public static final ConfigNamespace IDS_NS = new ConfigNamespace(ROOT_NS, "ids", "General configuration options for graph element IDs");
    public static final ConfigOption<Integer> IDS_BLOCK_SIZE = new ConfigOption<Integer>(IDS_NS, "block-size", "Globally reserve graph element IDs in chunks of this size.  Setting this too low will make commits frequently block on slow reservation requests.  Setting it too high will result in IDs wasted when a graph instance shuts down with reserved but mostly-unused blocks.", ConfigOption.Type.GLOBAL_OFFLINE, 10000);
    public static final ConfigOption<String> IDS_STORE_NAME = new ConfigOption<String>(IDS_NS, "store-name", "The name of the ID KCVStore. IDS_STORE_NAME is meant to be used only for backward compatibility with Titan, and should not be used explicitly in normal operations or in new graphs.", ConfigOption.Type.GLOBAL_OFFLINE, "janusgraph_ids");
    public static final ConfigOption<Boolean> IDS_FLUSH = new ConfigOption<Boolean>(IDS_NS, "flush", "When true, vertices and edges are assigned IDs immediately upon creation.  When false, IDs are assigned only when the transaction commits.", ConfigOption.Type.MASKABLE, true);
    public static final ConfigOption<Duration> IDS_RENEW_TIMEOUT = new ConfigOption<Duration>(IDS_NS, "renew-timeout", "The number of milliseconds that the JanusGraph id pool manager will wait before giving up on allocating a new block of ids", ConfigOption.Type.MASKABLE, Duration.ofMillis(120000L));
    public static final ConfigOption<Double> IDS_RENEW_BUFFER_PERCENTAGE = new ConfigOption<Double>(IDS_NS, "renew-percentage", "When the most-recently-reserved ID block has only this percentage of its total IDs remaining (expressed as a value between 0 and 1), JanusGraph asynchronously begins reserving another block. This helps avoid transaction commits waiting on ID reservation even if the block size is relatively small.", ConfigOption.Type.MASKABLE, 0.3);
    public static final ConfigNamespace IDAUTHORITY_NS = new ConfigNamespace(IDS_NS, "authority", "Configuration options for graph element ID reservation/allocation");
    public static final ConfigOption<Duration> IDAUTHORITY_WAIT = new ConfigOption<Duration>(IDAUTHORITY_NS, "wait-time", "The number of milliseconds the system waits for an ID block reservation to be acknowledged by the storage backend", ConfigOption.Type.GLOBAL_OFFLINE, Duration.ofMillis(300L));
    public static final ConfigOption<ConflictAvoidanceMode> IDAUTHORITY_CONFLICT_AVOIDANCE = new ConfigOption<ConflictAvoidanceMode>(IDAUTHORITY_NS, "conflict-avoidance-mode", "This setting helps separate JanusGraph instances sharing a single graph storage backend avoid contention when reserving ID blocks, increasing overall throughput.", ConfigOption.Type.GLOBAL_OFFLINE, ConflictAvoidanceMode.class, ConflictAvoidanceMode.NONE);
    public static final ConfigOption<Integer> IDAUTHORITY_CAV_RETRIES = new ConfigOption<Integer>(IDAUTHORITY_NS, "randomized-conflict-avoidance-retries", "Number of times the system attempts ID block reservations with random conflict avoidance tags before giving up and throwing an exception", ConfigOption.Type.MASKABLE, 5);
    public static final ConfigOption<Integer> IDAUTHORITY_CAV_BITS = new ConfigOption<Integer>(IDAUTHORITY_NS, "conflict-avoidance-tag-bits", "Configures the number of bits of JanusGraph-assigned element IDs that are reserved for the conflict avoidance tag", ConfigOption.Type.FIXED, 4, uniqueIdBitWidth -> uniqueIdBitWidth >= 0 && uniqueIdBitWidth <= 16);
    public static final ConfigOption<Integer> IDAUTHORITY_CAV_TAG = new ConfigOption<Integer>(IDAUTHORITY_NS, "conflict-avoidance-tag", "Conflict avoidance tag to be used by this JanusGraph instance when allocating IDs", ConfigOption.Type.LOCAL, 0);
    public static final ConfigNamespace INDEX_NS = new ConfigNamespace(ROOT_NS, "index", "Configuration options for the individual indexing backends", true);
    public static final ConfigOption<String> INDEX_BACKEND = new ConfigOption<String>(INDEX_NS, "backend", "The indexing backend used to extend and optimize JanusGraph's query functionality. This setting is optional.  JanusGraph can use multiple heterogeneous index backends.  Hence, this option can appear more than once, so long as the user-defined name between \"" + INDEX_NS.getName() + "\" and \"backend\" is unique among appearances.Similar to the storage backend, this should be set to one of JanusGraph's built-in shorthand names for its standard index backends (shorthands: " + Joiner.on((String)", ").join(StandardIndexProvider.getAllShorthands()) + ") or to the full package and classname of a custom/third-party IndexProvider implementation.", ConfigOption.Type.GLOBAL_OFFLINE, "elasticsearch");
    public static final ConfigOption<String> INDEX_DIRECTORY = new ConfigOption<String>(INDEX_NS, "directory", "Directory to store index data locally", ConfigOption.Type.MASKABLE, String.class);
    public static final ConfigOption<String> INDEX_NAME = new ConfigOption<String>(INDEX_NS, "index-name", "Name of the index if required by the indexing backend", ConfigOption.Type.GLOBAL_OFFLINE, "janusgraph");
    public static final ConfigOption<String[]> INDEX_HOSTS = new ConfigOption<String[]>(INDEX_NS, "hostname", "The hostname or comma-separated list of hostnames of index backend servers.  This is only applicable to some index backends, such as elasticsearch and solr.", ConfigOption.Type.MASKABLE, new String[]{NetworkUtil.getLoopbackAddress()});
    public static final ConfigOption<Integer> INDEX_PORT = new ConfigOption<Integer>(INDEX_NS, "port", "The port on which to connect to index backend servers", ConfigOption.Type.MASKABLE, Integer.class);
    public static final ConfigOption<String> INDEX_CONF_FILE = new ConfigOption<String>(INDEX_NS, "conf-file", "Path to a configuration file for those indexing backends that require/support a separate config file", ConfigOption.Type.MASKABLE, String.class);
    public static final ConfigOption<Integer> INDEX_MAX_RESULT_SET_SIZE = new ConfigOption<Integer>(INDEX_NS, "max-result-set-size", "Maximum number of results to return if no limit is specified. For index backends that support scrolling, it represents the number of results in each batch", ConfigOption.Type.MASKABLE, 50);
    public static final ConfigOption<Boolean> INDEX_NAME_MAPPING = new ConfigOption<Boolean>(INDEX_NS, "map-name", "Whether to use the name of the property key as the field name in the index. It must be ensured, that theindexed property key names are valid field names. Renaming the property key will NOT rename the field and its the developers responsibility to avoid field collisions.", ConfigOption.Type.GLOBAL, true);
    public static final ConfigNamespace LOG_NS = new ConfigNamespace(ROOT_NS, "log", "Configuration options for JanusGraph's logging system", true);
    public static final String MANAGEMENT_LOG = "janusgraph";
    public static final String TRANSACTION_LOG = "tx";
    public static final String USER_LOG = "user";
    public static final String USER_LOG_PREFIX = "ulog_";
    public static final Duration TRANSACTION_LOG_DEFAULT_TTL = Duration.ofDays(7L);
    public static final ConfigOption<String> LOG_BACKEND = new ConfigOption<String>(LOG_NS, "backend", "Define the log backed to use", ConfigOption.Type.GLOBAL_OFFLINE, "default");
    public static final ConfigOption<Integer> LOG_NUM_BUCKETS = new ConfigOption<Integer>(LOG_NS, "num-buckets", "The number of buckets to split log entries into for load balancing", ConfigOption.Type.GLOBAL_OFFLINE, 1, ConfigOption.positiveInt());
    public static final ConfigOption<Integer> LOG_SEND_BATCH_SIZE = new ConfigOption<Integer>(LOG_NS, "send-batch-size", "Maximum number of log messages to batch up for sending for logging implementations that support batch sending", ConfigOption.Type.MASKABLE, 256, ConfigOption.positiveInt());
    public static final ConfigOption<Integer> LOG_READ_BATCH_SIZE = new ConfigOption<Integer>(LOG_NS, "read-batch-size", "Maximum number of log messages to read at a time for logging implementations that read messages in batches", ConfigOption.Type.MASKABLE, 1024, ConfigOption.positiveInt());
    public static final ConfigOption<Duration> LOG_SEND_DELAY = new ConfigOption<Duration>(LOG_NS, "send-delay", "Maximum time in ms that messages can be buffered locally before sending in batch", ConfigOption.Type.MASKABLE, Duration.ofMillis(1000L));
    public static final ConfigOption<Duration> LOG_READ_INTERVAL = new ConfigOption<Duration>(LOG_NS, "read-interval", "Time in ms between message readings from the backend for this logging implementations that read message in batch", ConfigOption.Type.MASKABLE, Duration.ofMillis(5000L));
    public static final ConfigOption<Integer> LOG_READ_THREADS = new ConfigOption<Integer>(LOG_NS, "read-threads", "Number of threads to be used in reading and processing log messages", ConfigOption.Type.MASKABLE, 1, ConfigOption.positiveInt());
    public static final ConfigOption<Duration> LOG_STORE_TTL = new ConfigOption<Predicate>(LOG_NS, "ttl", "Sets a TTL on all log entries, meaningthat all entries added to this log expire after the configured amount of time. Requiresthat the log implementation supports TTL.", ConfigOption.Type.GLOBAL, (Class<Predicate>)Duration.class, sd -> null != sd && !sd.isZero());
    public static final ConfigNamespace ATTRIBUTE_NS = new ConfigNamespace(ROOT_NS, "attributes", "Configuration options for attribute handling");
    public static final ConfigNamespace CUSTOM_ATTRIBUTE_NS = new ConfigNamespace(ATTRIBUTE_NS, "custom", "Custom attribute serialization and handling", true);
    public static final String ATTRIBUTE_PREFIX = "attribute";
    public static final ConfigOption<String> CUSTOM_ATTRIBUTE_CLASS = new ConfigOption<String>(CUSTOM_ATTRIBUTE_NS, "attribute-class", "Class of the custom attribute to be registered", ConfigOption.Type.GLOBAL_OFFLINE, String.class);
    public static final ConfigOption<String> CUSTOM_SERIALIZER_CLASS = new ConfigOption<String>(CUSTOM_ATTRIBUTE_NS, "serializer-class", "Class of the custom attribute serializer to be registered", ConfigOption.Type.GLOBAL_OFFLINE, String.class);
    public static final ConfigNamespace METRICS_NS = new ConfigNamespace(ROOT_NS, "metrics", "Configuration options for metrics reporting");
    public static final ConfigOption<Boolean> BASIC_METRICS = new ConfigOption<Boolean>(METRICS_NS, "enabled", "Whether to enable basic timing and operation count monitoring on backend", ConfigOption.Type.MASKABLE, false);
    public static final String METRICS_PREFIX_DEFAULT = "org.janusgraph";
    public static final String METRICS_SYSTEM_PREFIX_DEFAULT = "org.janusgraph.sys";
    public static final String METRICS_SCHEMA_PREFIX_DEFAULT = "org.janusgraph.sys.schema";
    public static final ConfigOption<String> METRICS_PREFIX = new ConfigOption<String>(METRICS_NS, "prefix", "The default name prefix for Metrics reported by JanusGraph.", ConfigOption.Type.MASKABLE, "org.janusgraph");
    public static final ConfigOption<Boolean> METRICS_MERGE_STORES = new ConfigOption<Boolean>(METRICS_NS, "merge-stores", "Whether to aggregate measurements for the edge store, vertex index, edge index, and ID store", ConfigOption.Type.MASKABLE, true);
    public static final ConfigNamespace METRICS_CONSOLE_NS = new ConfigNamespace(METRICS_NS, "console", "Configuration options for metrics reporting to console");
    public static final ConfigOption<Duration> METRICS_CONSOLE_INTERVAL = new ConfigOption<Duration>(METRICS_CONSOLE_NS, "interval", "Time between Metrics reports printing to the console, in milliseconds", ConfigOption.Type.MASKABLE, Duration.class);
    public static final ConfigNamespace METRICS_CSV_NS = new ConfigNamespace(METRICS_NS, "csv", "Configuration options for metrics reporting to CSV file");
    public static final ConfigOption<Duration> METRICS_CSV_INTERVAL = new ConfigOption<Duration>(METRICS_CSV_NS, "interval", "Time between dumps of CSV files containing Metrics data, in milliseconds", ConfigOption.Type.MASKABLE, Duration.class);
    public static final ConfigOption<String> METRICS_CSV_DIR = new ConfigOption<String>(METRICS_CSV_NS, "directory", "Metrics CSV output directory", ConfigOption.Type.MASKABLE, String.class);
    public static final ConfigNamespace METRICS_JMX_NS = new ConfigNamespace(METRICS_NS, "jmx", "Configuration options for metrics reporting through JMX");
    public static final ConfigOption<Boolean> METRICS_JMX_ENABLED = new ConfigOption<Boolean>(METRICS_JMX_NS, "enabled", "Whether to report Metrics through a JMX MBean", ConfigOption.Type.MASKABLE, false);
    public static final ConfigOption<String> METRICS_JMX_DOMAIN = new ConfigOption<String>(METRICS_JMX_NS, "domain", "The JMX domain in which to report Metrics", ConfigOption.Type.MASKABLE, String.class);
    public static final ConfigOption<String> METRICS_JMX_AGENTID = new ConfigOption<String>(METRICS_JMX_NS, "agentid", "The JMX agentId used by Metrics", ConfigOption.Type.MASKABLE, String.class);
    public static final ConfigNamespace METRICS_SLF4J_NS = new ConfigNamespace(METRICS_NS, "slf4j", "Configuration options for metrics reporting through slf4j");
    public static final ConfigOption<Duration> METRICS_SLF4J_INTERVAL = new ConfigOption<Duration>(METRICS_SLF4J_NS, "interval", "Time between slf4j logging reports of Metrics data, in milliseconds", ConfigOption.Type.MASKABLE, Duration.class);
    public static final ConfigOption<String> METRICS_SLF4J_LOGGER = new ConfigOption<String>(METRICS_SLF4J_NS, "logger", "The complete name of the Logger through which Metrics will report via Slf4j", ConfigOption.Type.MASKABLE, String.class);
    public static final ConfigNamespace METRICS_GANGLIA_NS = new ConfigNamespace(METRICS_NS, "ganglia", "Configuration options for metrics reporting through Ganglia");
    public static final ConfigOption<String> GANGLIA_HOST_OR_GROUP = new ConfigOption<String>(METRICS_GANGLIA_NS, "hostname", "The unicast host or multicast group name to which Metrics will send Ganglia data", ConfigOption.Type.MASKABLE, String.class);
    public static final ConfigOption<Duration> GANGLIA_INTERVAL = new ConfigOption<Duration>(METRICS_GANGLIA_NS, "interval", "The number of milliseconds to wait between sending Metrics data to Ganglia", ConfigOption.Type.MASKABLE, Duration.class);
    public static final ConfigOption<Integer> GANGLIA_PORT = new ConfigOption<Integer>(METRICS_GANGLIA_NS, "port", "The port to which Ganglia data are sent", ConfigOption.Type.MASKABLE, 8649);
    public static final ConfigOption<String> GANGLIA_ADDRESSING_MODE = new ConfigOption<String>(METRICS_GANGLIA_NS, "addressing-mode", "Whether to communicate to Ganglia via uni- or multicast", ConfigOption.Type.MASKABLE, "unicast", s -> s != null && s.equalsIgnoreCase("unicast") || s.equalsIgnoreCase("multicast"));
    public static final ConfigOption<Integer> GANGLIA_TTL = new ConfigOption<Integer>(METRICS_GANGLIA_NS, "ttl", "The multicast TTL to set on outgoing Ganglia datagrams", ConfigOption.Type.MASKABLE, 1);
    public static final ConfigOption<Boolean> GANGLIA_USE_PROTOCOL_31 = new ConfigOption<Boolean>(METRICS_GANGLIA_NS, "protocol-31", "Whether to send data to Ganglia in the 3.1 protocol format", ConfigOption.Type.MASKABLE, true);
    public static final ConfigOption<String> GANGLIA_UUID = new ConfigOption<String>(METRICS_GANGLIA_NS, "uuid", "The host UUID to set on outgoing Ganglia datagrams. See https://github.com/ganglia/monitor-core/wiki/UUIDSources for information about this setting.", ConfigOption.Type.LOCAL, String.class);
    public static final ConfigOption<String> GANGLIA_SPOOF = new ConfigOption<Predicate>(METRICS_GANGLIA_NS, "spoof", "If non-null, it must be a valid Gmetric spoof string formatted as an IP:hostname pair. See https://github.com/ganglia/monitor-core/wiki/Gmetric-Spoofing for information about this setting.", ConfigOption.Type.MASKABLE, (Class<Predicate>)String.class, s -> s != null && 0 < s.indexOf(58));
    public static final ConfigNamespace METRICS_GRAPHITE_NS = new ConfigNamespace(METRICS_NS, "graphite", "Configuration options for metrics reporting through Graphite");
    public static final ConfigOption<String> GRAPHITE_HOST = new ConfigOption<String>(METRICS_GRAPHITE_NS, "hostname", "The hostname to receive Graphite plaintext protocol metric data", ConfigOption.Type.MASKABLE, String.class);
    public static final ConfigOption<Duration> GRAPHITE_INTERVAL = new ConfigOption<Duration>(METRICS_GRAPHITE_NS, "interval", "The number of milliseconds to wait between sending Metrics data", ConfigOption.Type.MASKABLE, Duration.class);
    public static final ConfigOption<Integer> GRAPHITE_PORT = new ConfigOption<Integer>(METRICS_GRAPHITE_NS, "port", "The port to which Graphite data are sent", ConfigOption.Type.MASKABLE, 2003);
    public static final ConfigOption<String> GRAPHITE_PREFIX = new ConfigOption<String>(METRICS_GRAPHITE_NS, "prefix", "A Graphite-specific prefix for reported metrics", ConfigOption.Type.MASKABLE, String.class);
    public static final ConfigNamespace GREMLIN_NS = new ConfigNamespace(ROOT_NS, "gremlin", "Gremlin configuration options");
    public static final ConfigOption<String> GREMLIN_GRAPH = new ConfigOption<String>(GREMLIN_NS, "graph", "The implementation of graph factory that will be used by gremlin server", ConfigOption.Type.LOCAL, "org.janusgraph.core.JanusGraphFactory");
    public static final String SYSTEM_PROPERTIES_STORE_NAME = "system_properties";
    public static final String SYSTEM_CONFIGURATION_IDENTIFIER = "configuration";
    public static final String USER_CONFIGURATION_IDENTIFIER = "userconfig";
    private static final String INCOMPATIBLE_VERSION_EXCEPTION = "Runtime version is incompatible with current JanusGraph version: JanusGraph [%1s] vs. runtime [%2s]";
    private static final String INCOMPATIBLE_STORAGE_VERSION_EXCEPTION = "Storage version is incompatible with current client: graph storage version %s vs. client storage version %s when opening graph %s.";
    private static final String BACKLEVEL_STORAGE_VERSION_EXCEPTION = "The storage version on the client or server is lower than the storage version of the graph: graph storage version %s vs. client storage version %s when opening graph %s.";
    private final org.janusgraph.diskstorage.configuration.Configuration configuration;
    private final ReadConfiguration configurationAtOpen;
    private String uniqueGraphId;
    private final ModifiableConfiguration localConfiguration;
    private boolean readOnly;
    private boolean flushIDs;
    private boolean forceIndexUsage;
    private boolean batchLoading;
    private int txVertexCacheSize;
    private int txDirtyVertexSize;
    private DefaultSchemaMaker defaultSchemaMaker;
    private boolean hasDisabledSchemaConstraints;
    private Boolean propertyPrefetching;
    private boolean adjustQueryLimit;
    private Boolean useMultiQuery;
    private boolean allowVertexIdSetting;
    private boolean logTransactions;
    private String metricsPrefix;
    private String unknownIndexKeyName;
    private StoreFeatures storeFeatures = null;
    private static final AtomicLong INSTANCE_COUNTER = new AtomicLong(0L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphDatabaseConfiguration(ReadConfiguration localConfig) {
        ReadConfiguration globalConfig;
        Preconditions.checkNotNull((Object)localConfig);
        this.configurationAtOpen = localConfig;
        BasicConfiguration localBasicConfiguration = new BasicConfiguration(ROOT_NS, localConfig, BasicConfiguration.Restriction.NONE);
        ModifiableConfiguration overwrite = new ModifiableConfiguration(ROOT_NS, new CommonsConfiguration(), BasicConfiguration.Restriction.NONE);
        KeyColumnValueStoreManager storeManager = Backend.getStorageManager(localBasicConfiguration);
        StoreFeatures storeFeatures = storeManager.getFeatures();
        KCVSConfiguration keyColumnValueStoreConfiguration = Backend.getStandaloneGlobalConfiguration(storeManager, localBasicConfiguration);
        this.localConfiguration = new ModifiableConfiguration(ROOT_NS, new CommonsConfiguration(), BasicConfiguration.Restriction.LOCAL);
        this.localConfiguration.setAll(GraphDatabaseConfiguration.getLocalSubset(localBasicConfiguration.getAll()));
        try {
            ModifiableConfiguration globalWrite;
            if (!localBasicConfiguration.has(LOCK_LOCAL_MEDIATOR_GROUP, new String[0])) {
                overwrite.set(LOCK_LOCAL_MEDIATOR_GROUP, storeManager.getName(), new String[0]);
            }
            if (!(globalWrite = new ModifiableConfiguration(ROOT_NS, keyColumnValueStoreConfiguration, BasicConfiguration.Restriction.GLOBAL)).isFrozen()) {
                globalWrite.setAll(GraphDatabaseConfiguration.getGlobalSubset(localBasicConfiguration.getAll()));
                Preconditions.checkArgument((!globalWrite.has(INITIAL_JANUSGRAPH_VERSION, new String[0]) ? 1 : 0) != 0, (Object)"Database has already been initialized but not frozen");
                globalWrite.set(INITIAL_JANUSGRAPH_VERSION, JanusGraphConstants.VERSION, new String[0]);
                Preconditions.checkArgument((!globalWrite.has(INITIAL_STORAGE_VERSION, new String[0]) ? 1 : 0) != 0, (Object)"Database has already been initialized but not frozen");
                globalWrite.set(INITIAL_STORAGE_VERSION, JanusGraphConstants.STORAGE_VERSION, new String[0]);
                if (!localBasicConfiguration.has(TIMESTAMP_PROVIDER, new String[0])) {
                    TimestampProviders backendPreference;
                    StoreFeatures f = storeManager.getFeatures();
                    if (f.hasTimestamps() && null != (backendPreference = f.getPreferredTimestamps())) {
                        globalWrite.set(TIMESTAMP_PROVIDER, backendPreference, new String[0]);
                        log.info("Set timestamps to {} according to storage backend preference", (Object)LoggerUtil.sanitizeAndLaunder(globalWrite.get(TIMESTAMP_PROVIDER, new String[0])));
                    } else {
                        globalWrite.set(TIMESTAMP_PROVIDER, TIMESTAMP_PROVIDER.getDefaultValue(), new String[0]);
                        log.info("Set default timestamp provider {}", (Object)LoggerUtil.sanitizeAndLaunder(globalWrite.get(TIMESTAMP_PROVIDER, new String[0])));
                    }
                } else {
                    log.info("Using configured timestamp provider {}", (Object)localBasicConfiguration.get(TIMESTAMP_PROVIDER, new String[0]));
                }
                globalWrite.freezeConfiguration();
            } else {
                boolean allowUpgrade;
                String graphName = this.getGraphName();
                if (graphName == null) {
                    graphName = "";
                }
                if (allowUpgrade = localBasicConfiguration.has(ALLOW_UPGRADE, new String[0]) ? localBasicConfiguration.get(ALLOW_UPGRADE, new String[0]) : (globalWrite.has(ALLOW_UPGRADE, new String[0]) ? globalWrite.get(ALLOW_UPGRADE, new String[0]).booleanValue() : ALLOW_UPGRADE.getDefaultValue().booleanValue())) {
                    if (!globalWrite.has(INITIAL_STORAGE_VERSION, new String[0])) {
                        globalWrite.set(INITIAL_JANUSGRAPH_VERSION, JanusGraphConstants.VERSION, new String[0]);
                        globalWrite.set(TITAN_COMPATIBLE_VERSIONS, JanusGraphConstants.VERSION, new String[0]);
                        globalWrite.set(INITIAL_STORAGE_VERSION, JanusGraphConstants.STORAGE_VERSION, new String[0]);
                        globalWrite.set(ALLOW_UPGRADE, false, new String[0]);
                        log.info("graph.storage-version has been upgraded from 1 to {} and graph.janusgraph-version has been upgraded from {} to {} on graph {}", new Object[]{JanusGraphConstants.STORAGE_VERSION, globalWrite.get(INITIAL_JANUSGRAPH_VERSION, new String[0]), JanusGraphConstants.VERSION, graphName});
                    } else if (Integer.parseInt(globalWrite.get(INITIAL_STORAGE_VERSION, new String[0])) < Integer.parseInt(JanusGraphConstants.STORAGE_VERSION)) {
                        globalWrite.set(INITIAL_JANUSGRAPH_VERSION, JanusGraphConstants.VERSION, new String[0]);
                        globalWrite.set(TITAN_COMPATIBLE_VERSIONS, JanusGraphConstants.VERSION, new String[0]);
                        globalWrite.set(INITIAL_STORAGE_VERSION, JanusGraphConstants.STORAGE_VERSION, new String[0]);
                        globalWrite.set(ALLOW_UPGRADE, false, new String[0]);
                        log.info("graph.storage-version has been upgraded from {} to {} and graph.janusgraph-version has been upgraded from {} to {} on graph {}", new Object[]{globalWrite.get(INITIAL_STORAGE_VERSION, new String[0]), JanusGraphConstants.STORAGE_VERSION, globalWrite.get(INITIAL_JANUSGRAPH_VERSION, new String[0]), JanusGraphConstants.VERSION, graphName});
                    } else {
                        if (Integer.parseInt(globalWrite.get(INITIAL_STORAGE_VERSION, new String[0])) > Integer.parseInt(JanusGraphConstants.STORAGE_VERSION)) {
                            throw new JanusGraphException(String.format(BACKLEVEL_STORAGE_VERSION_EXCEPTION, globalWrite.get(INITIAL_STORAGE_VERSION, new String[0]), JanusGraphConstants.STORAGE_VERSION, graphName));
                        }
                        log.warn("Warning graph.allow-upgrade is currently set to true on graph {}. Please set graph.allow-upgrade to false in your properties file.", (Object)graphName);
                    }
                } else if (!globalWrite.has(INITIAL_STORAGE_VERSION, new String[0]) || !globalWrite.get(INITIAL_STORAGE_VERSION, new String[0]).equals(JanusGraphConstants.STORAGE_VERSION)) {
                    String storageVersion = globalWrite.has(INITIAL_STORAGE_VERSION, new String[0]) ? globalWrite.get(INITIAL_STORAGE_VERSION, new String[0]) : "1";
                    throw new JanusGraphException(String.format(INCOMPATIBLE_STORAGE_VERSION_EXCEPTION, storageVersion, JanusGraphConstants.STORAGE_VERSION, graphName));
                }
                try {
                    String version = globalWrite.get(INITIAL_JANUSGRAPH_VERSION, new String[0]);
                    Preconditions.checkArgument((version != null ? 1 : 0) != 0, (Object)"JanusGraph version has not been initialized");
                }
                catch (IllegalStateException ise) {
                    this.checkBackwardCompatibilityWithTitan(globalWrite, localBasicConfiguration, keyColumnValueStoreConfiguration, overwrite);
                }
                boolean managedOverridesAllowed = localBasicConfiguration.has(ALLOW_STALE_CONFIG, new String[0]) ? localBasicConfiguration.get(ALLOW_STALE_CONFIG, new String[0]) : (globalWrite.has(ALLOW_STALE_CONFIG, new String[0]) ? globalWrite.get(ALLOW_STALE_CONFIG, new String[0]).booleanValue() : ALLOW_STALE_CONFIG.getDefaultValue().booleanValue());
                HashSet optionsWithDiscrepancies = Sets.newHashSet();
                for (Map.Entry<ConfigElement.PathIdentifier, Object> ent : GraphDatabaseConfiguration.getManagedSubset(localBasicConfiguration.getAll()).entrySet()) {
                    boolean match;
                    ConfigElement.PathIdentifier pid = ent.getKey();
                    assert (pid.element.isOption());
                    ConfigOption opt = (ConfigOption)pid.element;
                    Object localValue = ent.getValue();
                    Object storeValue = globalWrite.get(opt, pid.umbrellaElements);
                    if (overwrite.has(opt, pid.umbrellaElements)) {
                        storeValue = overwrite.get(opt, pid.umbrellaElements);
                    }
                    if (null != localValue && null != storeValue) {
                        match = localValue.equals(storeValue);
                    } else {
                        boolean bl = match = null == localValue && null == storeValue;
                    }
                    if (match) continue;
                    String fullOptionName = ConfigElement.getPath(pid.element, pid.umbrellaElements);
                    String template = "Local setting {}={} (Type: {}) is overridden by globally managed value ({}).  Use the {} interface instead of the local configuration to control this setting.";
                    Object[] replacements = new Object[]{fullOptionName, localValue, opt.getType(), storeValue, ManagementSystem.class.getSimpleName()};
                    if (managedOverridesAllowed) {
                        log.warn(template, replacements);
                    } else {
                        log.error(template, replacements);
                    }
                    optionsWithDiscrepancies.add(fullOptionName);
                }
                if (0 < optionsWithDiscrepancies.size() && !managedOverridesAllowed) {
                    String template = "Local settings present for one or more globally managed options: [%s].  These options are controlled through the %s interface; local settings have no effect.";
                    throw new JanusGraphConfigurationException(String.format(template, Joiner.on((String)", ").join((Iterable)optionsWithDiscrepancies), ManagementSystem.class.getSimpleName()));
                }
            }
            globalConfig = keyColumnValueStoreConfiguration.asReadConfiguration();
        }
        finally {
            keyColumnValueStoreConfiguration.close();
        }
        MixedConfiguration combinedConfig = new MixedConfiguration(ROOT_NS, globalConfig, localConfig);
        this.uniqueGraphId = GraphDatabaseConfiguration.getOrGenerateUniqueInstanceId(combinedConfig);
        overwrite.set(UNIQUE_INSTANCE_ID, this.uniqueGraphId, new String[0]);
        Preconditions.checkArgument((boolean)combinedConfig.get(LOG_BACKEND, TRANSACTION_LOG).equals(LOG_BACKEND.getDefaultValue()), (Object)"Must use default log backend for transaction log");
        Preconditions.checkArgument((!combinedConfig.has(LOG_SEND_DELAY, TRANSACTION_LOG) || combinedConfig.get(LOG_SEND_DELAY, TRANSACTION_LOG).isZero() ? 1 : 0) != 0, (Object)"Send delay must be 0 for transaction log.");
        overwrite.set(LOG_SEND_DELAY, Duration.ZERO, TRANSACTION_LOG);
        if (!combinedConfig.has(LOG_STORE_TTL, TRANSACTION_LOG) && TTLKCVSManager.supportsAnyTTL(storeFeatures)) {
            overwrite.set(LOG_STORE_TTL, TRANSACTION_LOG_DEFAULT_TTL, TRANSACTION_LOG);
        }
        Preconditions.checkArgument((boolean)combinedConfig.get(LOG_BACKEND, MANAGEMENT_LOG).equals(LOG_BACKEND.getDefaultValue()), (Object)"Must use default log backend for system log");
        Preconditions.checkArgument((!combinedConfig.has(LOG_SEND_DELAY, MANAGEMENT_LOG) || combinedConfig.get(LOG_SEND_DELAY, MANAGEMENT_LOG).isZero() ? 1 : 0) != 0, (Object)"Send delay must be 0 for system log.");
        overwrite.set(LOG_SEND_DELAY, Duration.ZERO, MANAGEMENT_LOG);
        Preconditions.checkArgument((!combinedConfig.has(KCVSLog.LOG_KEY_CONSISTENT, MANAGEMENT_LOG) || combinedConfig.get(KCVSLog.LOG_KEY_CONSISTENT, MANAGEMENT_LOG) != false ? 1 : 0) != 0, (Object)"Management log must be configured to be key-consistent");
        overwrite.set(KCVSLog.LOG_KEY_CONSISTENT, true, MANAGEMENT_LOG);
        Preconditions.checkArgument((!combinedConfig.has(KCVSLogManager.LOG_FIXED_PARTITION, MANAGEMENT_LOG) || combinedConfig.get(KCVSLogManager.LOG_FIXED_PARTITION, MANAGEMENT_LOG) != false ? 1 : 0) != 0, (Object)"Fixed partitions must be enabled for management log");
        overwrite.set(KCVSLogManager.LOG_FIXED_PARTITION, true, MANAGEMENT_LOG);
        this.configuration = new MergedConfiguration(overwrite, combinedConfig);
        this.preLoadConfiguration();
    }

    private void checkBackwardCompatibilityWithTitan(ModifiableConfiguration globalWrite, BasicConfiguration localBasicConfiguration, KCVSConfiguration keyColumnValueStoreConfiguration, ModifiableConfiguration overwrite) {
        String version = globalWrite.get(TITAN_COMPATIBLE_VERSIONS, new String[0]);
        Preconditions.checkArgument((version != null ? 1 : 0) != 0, (Object)"JanusGraph version nor Titan compatibility have not been initialized");
        if (!JanusGraphConstants.TITAN_COMPATIBLE_VERSIONS.contains(version)) {
            throw new JanusGraphException(String.format(INCOMPATIBLE_VERSION_EXCEPTION, version, JanusGraphConstants.VERSION));
        }
        boolean localIdStoreIsDefault = "janusgraph_ids".equals(localBasicConfiguration.get(IDS_STORE_NAME, new String[0]));
        boolean usingTitanIdStore = localIdStoreIsDefault || "titan_ids".equals(localBasicConfiguration.get(IDS_STORE_NAME, new String[0]));
        boolean existingKeyStore = keyColumnValueStoreConfiguration.get(IDS_STORE_NAME.getName(), IDS_STORE_NAME.getDatatype()) != null;
        Preconditions.checkArgument((boolean)usingTitanIdStore, (Object)"ID store for Titan compatibility has not been initialized to: titan_ids");
        if (!existingKeyStore) {
            log.info("Setting {} to {} for Titan compatibility", (Object)IDS_STORE_NAME.getName(), (Object)"titan_ids");
            overwrite.set(IDS_STORE_NAME, "titan_ids", new String[0]);
        }
    }

    private static Map<ConfigElement.PathIdentifier, Object> getGlobalSubset(Map<ConfigElement.PathIdentifier, Object> m) {
        return Maps.filterEntries(m, entry -> {
            assert (((ConfigElement.PathIdentifier)entry.getKey()).element.isOption());
            return ((ConfigOption)((ConfigElement.PathIdentifier)entry.getKey()).element).isGlobal();
        });
    }

    private static Map<ConfigElement.PathIdentifier, Object> getLocalSubset(Map<ConfigElement.PathIdentifier, Object> m) {
        return Maps.filterEntries(m, entry -> {
            assert (((ConfigElement.PathIdentifier)entry.getKey()).element.isOption());
            return ((ConfigOption)((ConfigElement.PathIdentifier)entry.getKey()).element).isLocal();
        });
    }

    private static Map<ConfigElement.PathIdentifier, Object> getManagedSubset(Map<ConfigElement.PathIdentifier, Object> m) {
        return Maps.filterEntries(m, entry -> {
            assert (((ConfigElement.PathIdentifier)entry.getKey()).element.isOption());
            return ((ConfigOption)((ConfigElement.PathIdentifier)entry.getKey()).element).isManaged();
        });
    }

    private static String getSuffix(org.janusgraph.diskstorage.configuration.Configuration config) {
        String suffix = config.has(UNIQUE_INSTANCE_ID_SUFFIX, new String[0]) ? LongEncoding.encode(config.get(UNIQUE_INSTANCE_ID_SUFFIX, new String[0]).shortValue()) : (!config.has(UNIQUE_INSTANCE_ID_HOSTNAME, new String[0]) ? ManagementFactory.getRuntimeMXBean().getName() + LongEncoding.encode(INSTANCE_COUNTER.incrementAndGet()) : "");
        return suffix;
    }

    private static String getUid(org.janusgraph.diskstorage.configuration.Configuration config) {
        byte[] addrBytes;
        String uid;
        String localHostErrMsg = "Cannot determine local host";
        if (config.has(UNIQUE_INSTANCE_ID_HOSTNAME, new String[0]) && config.get(UNIQUE_INSTANCE_ID_HOSTNAME, new String[0]).booleanValue()) {
            try {
                uid = Inet4Address.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new JanusGraphConfigurationException("Cannot determine local host", e);
            }
        }
        try {
            addrBytes = Inet4Address.getLocalHost().getAddress();
        }
        catch (UnknownHostException e) {
            throw new JanusGraphConfigurationException("Cannot determine local host", e);
        }
        uid = new String(Hex.encodeHex((byte[])addrBytes));
        return uid;
    }

    private static String computeUniqueInstanceId(org.janusgraph.diskstorage.configuration.Configuration config) {
        String suffix = GraphDatabaseConfiguration.getSuffix(config);
        String uid = GraphDatabaseConfiguration.getUid(config);
        String instanceId = uid + suffix;
        for (char c : ConfigElement.ILLEGAL_CHARS) {
            instanceId = StringUtils.replaceChars((String)instanceId, (char)c, (char)'-');
        }
        return instanceId;
    }

    public static String getOrGenerateUniqueInstanceId(org.janusgraph.diskstorage.configuration.Configuration config) {
        String uid;
        if (!config.has(UNIQUE_INSTANCE_ID, new String[0])) {
            uid = GraphDatabaseConfiguration.computeUniqueInstanceId(config);
            log.info("Generated {}={}", (Object)UNIQUE_INSTANCE_ID.getName(), (Object)uid);
        } else {
            uid = config.get(UNIQUE_INSTANCE_ID, new String[0]);
        }
        Preconditions.checkArgument((!StringUtils.containsAny((String)uid, (char[])ConfigElement.ILLEGAL_CHARS) ? 1 : 0) != 0, (String)"Invalid unique identifier: %s", (Object[])new Object[]{uid});
        return uid;
    }

    public static ModifiableConfiguration buildGraphConfiguration() {
        return new ModifiableConfiguration(ROOT_NS, new CommonsConfiguration((Configuration)new BaseConfiguration()), BasicConfiguration.Restriction.NONE);
    }

    public static ModifiableConfiguration buildJobConfiguration() {
        return new ModifiableConfiguration(JOB_NS, new CommonsConfiguration((Configuration)new BaseConfiguration()), BasicConfiguration.Restriction.NONE);
    }

    public static String getSystemMetricsPrefix() {
        return METRICS_SYSTEM_PREFIX_DEFAULT;
    }

    public static ModifiableConfiguration getGlobalSystemConfig(Backend backend) {
        return new ModifiableConfiguration(ROOT_NS, backend.getGlobalSystemConfig(), BasicConfiguration.Restriction.GLOBAL);
    }

    private void preLoadConfiguration() {
        this.readOnly = this.configuration.get(STORAGE_READONLY, new String[0]);
        this.flushIDs = this.configuration.get(IDS_FLUSH, new String[0]);
        this.forceIndexUsage = this.configuration.get(FORCE_INDEX_USAGE, new String[0]);
        this.batchLoading = this.configuration.get(STORAGE_BATCH, new String[0]);
        String autoTypeMakerName = this.configuration.get(AUTO_TYPE, new String[0]);
        this.defaultSchemaMaker = preregisteredAutoType.containsKey(autoTypeMakerName) ? preregisteredAutoType.get(autoTypeMakerName) : (DefaultSchemaMaker)ConfigurationUtil.instantiate(autoTypeMakerName);
        if (this.batchLoading) {
            this.defaultSchemaMaker = DisableDefaultSchemaMaker.INSTANCE;
        }
        this.hasDisabledSchemaConstraints = this.configuration.get(SCHEMA_CONSTRAINTS, new String[0]) == false;
        this.txVertexCacheSize = this.configuration.get(TX_CACHE_SIZE, new String[0]);
        this.txDirtyVertexSize = this.configuration.has(TX_DIRTY_SIZE, new String[0]) ? this.configuration.get(TX_DIRTY_SIZE, new String[0]) : (this.batchLoading ? 4096 : 32);
        this.propertyPrefetching = this.configuration.get(PROPERTY_PREFETCHING, new String[0]);
        this.useMultiQuery = this.configuration.get(USE_MULTIQUERY, new String[0]);
        this.adjustQueryLimit = this.configuration.get(ADJUST_LIMIT, new String[0]);
        this.allowVertexIdSetting = this.configuration.get(ALLOW_SETTING_VERTEX_ID, new String[0]);
        this.logTransactions = this.configuration.get(SYSTEM_LOG_TRANSACTIONS, new String[0]);
        this.unknownIndexKeyName = this.configuration.get(IGNORE_UNKNOWN_INDEX_FIELD, new String[0]) != false ? UNKNOWN_FIELD_NAME : null;
        this.configureMetrics();
    }

    private void configureMetrics() {
        Preconditions.checkNotNull((Object)this.configuration);
        this.metricsPrefix = this.configuration.get(METRICS_PREFIX, new String[0]);
        if (!this.configuration.get(BASIC_METRICS, new String[0]).booleanValue()) {
            this.metricsPrefix = null;
        } else {
            Preconditions.checkNotNull((Object)this.metricsPrefix);
        }
        this.configureMetricsConsoleReporter();
        this.configureMetricsCsvReporter();
        this.configureMetricsJmxReporter();
        this.configureMetricsSlf4jReporter();
        this.configureMetricsGangliaReporter();
        this.configureMetricsGraphiteReporter();
    }

    private void configureMetricsConsoleReporter() {
        if (this.configuration.has(METRICS_CONSOLE_INTERVAL, new String[0])) {
            MetricManager.INSTANCE.addConsoleReporter(this.configuration.get(METRICS_CONSOLE_INTERVAL, new String[0]));
        }
    }

    private void configureMetricsCsvReporter() {
        if (this.configuration.has(METRICS_CSV_DIR, new String[0])) {
            MetricManager.INSTANCE.addCsvReporter(this.configuration.get(METRICS_CSV_INTERVAL, new String[0]), this.configuration.get(METRICS_CSV_DIR, new String[0]));
        }
    }

    private void configureMetricsJmxReporter() {
        if (this.configuration.get(METRICS_JMX_ENABLED, new String[0]).booleanValue()) {
            MetricManager.INSTANCE.addJmxReporter(this.configuration.get(METRICS_JMX_DOMAIN, new String[0]), this.configuration.get(METRICS_JMX_AGENTID, new String[0]));
        }
    }

    private void configureMetricsSlf4jReporter() {
        if (this.configuration.has(METRICS_SLF4J_INTERVAL, new String[0])) {
            MetricManager.INSTANCE.addSlf4jReporter(this.configuration.get(METRICS_SLF4J_INTERVAL, new String[0]), this.configuration.has(METRICS_SLF4J_LOGGER, new String[0]) ? this.configuration.get(METRICS_SLF4J_LOGGER, new String[0]) : null);
        }
    }

    private void configureMetricsGangliaReporter() {
        if (this.configuration.has(GANGLIA_HOST_OR_GROUP, new String[0])) {
            GMetric.UDPAddressingMode addressingMode;
            String host = this.configuration.get(GANGLIA_HOST_OR_GROUP, new String[0]);
            Duration intervalDuration = this.configuration.get(GANGLIA_INTERVAL, new String[0]);
            Integer port = this.configuration.get(GANGLIA_PORT, new String[0]);
            String addressingModeString = this.configuration.get(GANGLIA_ADDRESSING_MODE, new String[0]);
            if (addressingModeString.equalsIgnoreCase("multicast")) {
                addressingMode = GMetric.UDPAddressingMode.MULTICAST;
            } else if (addressingModeString.equalsIgnoreCase("unicast")) {
                addressingMode = GMetric.UDPAddressingMode.UNICAST;
            } else {
                throw new AssertionError();
            }
            Boolean proto31 = this.configuration.get(GANGLIA_USE_PROTOCOL_31, new String[0]);
            int ttl = this.configuration.get(GANGLIA_TTL, new String[0]);
            UUID uuid = this.configuration.has(GANGLIA_UUID, new String[0]) ? UUID.fromString(this.configuration.get(GANGLIA_UUID, new String[0])) : null;
            String spoof = null;
            if (this.configuration.has(GANGLIA_SPOOF, new String[0])) {
                spoof = this.configuration.get(GANGLIA_SPOOF, new String[0]);
            }
            try {
                MetricManager.INSTANCE.addGangliaReporter(host, port, addressingMode, ttl, proto31, uuid, spoof, intervalDuration);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void configureMetricsGraphiteReporter() {
        if (this.configuration.has(GRAPHITE_HOST, new String[0])) {
            MetricManager.INSTANCE.addGraphiteReporter(this.configuration.get(GRAPHITE_HOST, new String[0]), this.configuration.get(GRAPHITE_PORT, new String[0]), this.configuration.get(GRAPHITE_PREFIX, new String[0]), this.configuration.get(GRAPHITE_INTERVAL, new String[0]));
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean hasFlushIDs() {
        return this.flushIDs;
    }

    public boolean hasForceIndexUsage() {
        return this.forceIndexUsage;
    }

    public int getTxVertexCacheSize() {
        return this.txVertexCacheSize;
    }

    public int getTxDirtyVertexSize() {
        return this.txDirtyVertexSize;
    }

    public boolean isBatchLoading() {
        return this.batchLoading;
    }

    public String getUniqueGraphId() {
        return this.uniqueGraphId;
    }

    public String getMetricsPrefix() {
        return this.metricsPrefix;
    }

    public DefaultSchemaMaker getDefaultSchemaMaker() {
        return this.defaultSchemaMaker;
    }

    public boolean hasDisabledSchemaConstraints() {
        return this.hasDisabledSchemaConstraints;
    }

    public boolean allowVertexIdSetting() {
        return this.allowVertexIdSetting;
    }

    public Duration getMaxCommitTime() {
        return this.configuration.get(MAX_COMMIT_TIME, new String[0]);
    }

    public Duration getMaxWriteTime() {
        return this.configuration.get(STORAGE_WRITE_WAITTIME, new String[0]);
    }

    public boolean hasPropertyPrefetching() {
        if (this.propertyPrefetching == null) {
            return this.getStoreFeatures().isDistributed();
        }
        return this.propertyPrefetching;
    }

    public boolean useMultiQuery() {
        return this.useMultiQuery;
    }

    public boolean adjustQueryLimit() {
        return this.adjustQueryLimit;
    }

    public String getUnknownIndexKeyName() {
        return this.unknownIndexKeyName;
    }

    public boolean hasLogTransactions() {
        return this.logTransactions;
    }

    public TimestampProvider getTimestampProvider() {
        return this.configuration.get(TIMESTAMP_PROVIDER, new String[0]);
    }

    public boolean isUpgradeAllowed(String name) {
        return this.configuration.get(ALLOW_UPGRADE, new String[0]) != false && JanusGraphConstants.UPGRADEABLE_FIXED.contains(name);
    }

    public static List<RegisteredAttributeClass<?>> getRegisteredAttributeClasses(org.janusgraph.diskstorage.configuration.Configuration configuration) {
        ArrayList all = new ArrayList();
        for (String attributeId : configuration.getContainedNamespaces(CUSTOM_ATTRIBUTE_NS, new String[0])) {
            AttributeSerializer serializer;
            Class<?> clazz;
            int position;
            Preconditions.checkArgument((boolean)attributeId.startsWith(ATTRIBUTE_PREFIX), (String)"Invalid attribute definition: %s", (Object[])new Object[]{attributeId});
            try {
                position = Integer.parseInt(attributeId.substring(ATTRIBUTE_PREFIX.length()));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Expected entry of the form [attributeX] where X is a number but given" + attributeId);
            }
            String classname = configuration.get(CUSTOM_ATTRIBUTE_CLASS, attributeId);
            try {
                clazz = Class.forName(classname);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not find attribute class" + classname, e);
            }
            Preconditions.checkNotNull(clazz);
            Preconditions.checkArgument((boolean)configuration.has(CUSTOM_SERIALIZER_CLASS, attributeId));
            String serializerName = configuration.get(CUSTOM_SERIALIZER_CLASS, attributeId);
            try {
                Class<?> serializerClass = Class.forName(serializerName);
                serializer = (AttributeSerializer)serializerClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not find serializer class" + serializerName);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("Could not instantiate serializer class" + serializerName, e);
            }
            Preconditions.checkNotNull((Object)serializer);
            RegisteredAttributeClass reg = new RegisteredAttributeClass(position, clazz, serializer);
            for (RegisteredAttributeClass registeredAttributeClass : all) {
                if (!registeredAttributeClass.equals(reg)) continue;
                throw new IllegalArgumentException("Duplicate attribute registration: " + registeredAttributeClass + " and " + reg);
            }
            all.add(reg);
        }
        return all;
    }

    public VertexIDAssigner getIDAssigner(Backend backend) {
        return new VertexIDAssigner(this.configuration, backend.getIDAuthority(), backend.getStoreFeatures());
    }

    public String getBackendDescription() {
        String className = this.configuration.get(STORAGE_BACKEND, new String[0]);
        if (className.equalsIgnoreCase("berkeleyje")) {
            return className + ":" + this.configuration.get(STORAGE_DIRECTORY, new String[0]);
        }
        return className + ":" + Arrays.toString(this.configuration.get(STORAGE_HOSTS, new String[0]));
    }

    public org.janusgraph.diskstorage.configuration.Configuration getConfiguration() {
        return this.configuration;
    }

    public Backend getBackend() {
        Backend backend = new Backend(this.configuration);
        backend.initialize(this.configuration);
        this.storeFeatures = backend.getStoreFeatures();
        return backend;
    }

    public String getGraphName() {
        return this.getConfigurationAtOpen().getString(GRAPH_NAME.toStringWithoutRoot());
    }

    public StoreFeatures getStoreFeatures() {
        Preconditions.checkArgument((this.storeFeatures != null ? 1 : 0) != 0, (Object)"Cannot retrieve store features before the storage backend has been initialized");
        return this.storeFeatures;
    }

    public Serializer getSerializer() {
        return GraphDatabaseConfiguration.getSerializer(this.configuration);
    }

    public static Serializer getSerializer(org.janusgraph.diskstorage.configuration.Configuration configuration) {
        StandardSerializer serializer = new StandardSerializer();
        for (RegisteredAttributeClass<?> clazz : GraphDatabaseConfiguration.getRegisteredAttributeClasses(configuration)) {
            clazz.registerWith(serializer);
        }
        return serializer;
    }

    public SchemaCache getTypeCache(SchemaCache.StoreRetrieval retriever) {
        if (this.configuration.get(BASIC_METRICS, new String[0]).booleanValue()) {
            return new MetricInstrumentedSchemaCache(retriever);
        }
        return new StandardSchemaCache(retriever);
    }

    public Configuration getLocalConfiguration() {
        Configuration config = ((CommonsConfiguration)this.localConfiguration.getConfiguration()).getCommonConfiguration();
        config.setProperty("gremlin.graph", (Object)JanusGraphFactory.class.getName());
        return config;
    }

    public Configuration getConfigurationAtOpen() {
        BaseConfiguration result = new BaseConfiguration();
        for (String k : this.configurationAtOpen.getKeys("")) {
            result.setProperty(k, this.configurationAtOpen.get(k, Object.class));
        }
        return result;
    }

    public static String getPath(File dir) {
        return dir.getAbsolutePath() + File.separator;
    }
}

