/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.bridge.proxies.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.xadisk.bridge.proxies.facilitators.RemoteMethodInvoker;
import org.xadisk.bridge.proxies.facilitators.RemoteObjectProxy;
import org.xadisk.filesystem.TransactionInformation;

public class RemoteEventProcessingXAResource
extends RemoteObjectProxy
implements XAResource {
    private static final long serialVersionUID = 1L;
    private transient ConcurrentHashMap<Xid, TransactionInformation> internalXids = new ConcurrentHashMap();
    private final Object lockOnInternalXids = new ArrayList(0);

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.internalXids = new ConcurrentHashMap();
    }

    public RemoteEventProcessingXAResource(long objectId, RemoteMethodInvoker invoker) {
        super(objectId, invoker);
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            TransactionInformation xidImpl = this.mapToInternalXid(xid);
            this.invokeRemoteMethod("commit", xidImpl, Boolean.valueOf(onePhase));
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (Throwable th) {
            throw this.assertExceptionHandling(th);
        }
        finally {
            this.disconnect();
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        try {
            TransactionInformation xidImpl = this.mapToInternalXid(xid);
            this.invokeRemoteMethod("end", xidImpl, Integer.valueOf(flags));
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (Throwable th) {
            throw this.assertExceptionHandling(th);
        }
    }

    public void forget(Xid xid) throws XAException {
        try {
            TransactionInformation xidImpl = this.mapToInternalXid(xid);
            this.invokeRemoteMethod("forget", xidImpl);
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (Throwable th) {
            throw this.assertExceptionHandling(th);
        }
    }

    public int getTransactionTimeout() throws XAException {
        try {
            return (Integer)this.invokeRemoteMethod("getTransactionTimeout", new Serializable[0]);
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (Throwable th) {
            throw this.assertExceptionHandling(th);
        }
    }

    public boolean isSameRM(XAResource xar) throws XAException {
        return false;
    }

    public int prepare(Xid xid) throws XAException {
        try {
            TransactionInformation xidImpl = this.mapToInternalXid(xid);
            return (Integer)this.invokeRemoteMethod("prepare", xidImpl);
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (Throwable th) {
            throw this.assertExceptionHandling(th);
        }
    }

    public Xid[] recover(int flag) throws XAException {
        try {
            return (Xid[])this.invokeRemoteMethod("recover", Integer.valueOf(flag));
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (Throwable th) {
            throw this.assertExceptionHandling(th);
        }
    }

    public void rollback(Xid xid) throws XAException {
        try {
            TransactionInformation xidImpl = this.mapToInternalXid(xid);
            this.invokeRemoteMethod("rollback", xidImpl);
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (Throwable th) {
            throw this.assertExceptionHandling(th);
        }
        finally {
            this.disconnect();
        }
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        try {
            return (Boolean)this.invokeRemoteMethod("setTransactionTimeout", Integer.valueOf(timeout));
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (Throwable th) {
            throw this.assertExceptionHandling(th);
        }
    }

    public void start(Xid xid, int flag) throws XAException {
        try {
            TransactionInformation xidImpl = this.mapToInternalXid(xid);
            this.invokeRemoteMethod("start", xidImpl, Integer.valueOf(flag));
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (Throwable th) {
            throw this.assertExceptionHandling(th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionInformation mapToInternalXid(Xid xid) {
        Object object = this.lockOnInternalXids;
        synchronized (object) {
            TransactionInformation internalXid = this.internalXids.get(xid);
            if (internalXid == null) {
                internalXid = new TransactionInformation(xid);
                this.internalXids.put(xid, internalXid);
            }
            return internalXid;
        }
    }
}

