/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec.configuration.options;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import javax.inject.Inject;
import org.jboss.windup.config.AbstractPathConfigurationOption;
import org.jboss.windup.config.InputType;
import org.jboss.windup.config.ValidationResult;
import org.jboss.windup.config.loader.LabelLoader;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.util.PathUtil;
import org.jboss.windup.util.exception.WindupException;

public class UserLabelsDirectoryOption
extends AbstractPathConfigurationOption {
    public static final String NAME = "userLabelsDirectory";
    @Inject
    private LabelLoader labelLoader;

    public UserLabelsDirectoryOption() {
        super(true);
    }

    public String getName() {
        return NAME;
    }

    public String getLabel() {
        return "User Metadata Directory";
    }

    public String getDescription() {
        return "User Labels Directory (Search pattern: *.windup.label.xml, *.rhamt.label.xml, and *.mta.label.xml). Multiple paths can be specified separated by a space (for example, --userLabelsDirectory PATH_1 PATH_2).";
    }

    public Class<?> getType() {
        return File.class;
    }

    public InputType getUIType() {
        return InputType.MANY;
    }

    public boolean isRequired() {
        return false;
    }

    public int getPriority() {
        return 7500;
    }

    public ValidationResult validate(Object fileObject) {
        ValidationResult validate = super.validate(fileObject);
        if (validate.getLevel().equals((Object)ValidationResult.Level.ERROR)) {
            return validate;
        }
        ArrayList<Path> userLabelsPaths = new ArrayList<Path>();
        if (fileObject != null) {
            if (fileObject instanceof Iterable && !(fileObject instanceof Path)) {
                for (Object listItem : (Iterable)fileObject) {
                    userLabelsPaths.add(this.castToPath(listItem));
                }
            } else {
                userLabelsPaths.add(this.castToPath(fileObject));
            }
        }
        ArrayList<Path> defaultRulePaths = new ArrayList<Path>();
        defaultRulePaths.add(PathUtil.getWindupRulesDir());
        defaultRulePaths.add(PathUtil.getUserRulesDir());
        defaultRulePaths.add(PathUtil.getWindupLabelsDir());
        defaultRulePaths.add(PathUtil.getUserLabelsDir());
        defaultRulePaths.addAll(userLabelsPaths);
        try {
            RuleLoaderContext labelLoaderContext = new RuleLoaderContext(defaultRulePaths, null);
            this.labelLoader.loadConfiguration(labelLoaderContext);
        }
        catch (WindupException e) {
            return new ValidationResult(ValidationResult.Level.ERROR, e.getMessage());
        }
        return validate;
    }
}

