/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.xml;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Logger;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.jboss.windup.rules.apps.xml.xml.ValidateXmlHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class EnhancedEntityResolver2
implements EntityResolver2 {
    private static final Logger LOG = Logger.getLogger(EnhancedEntityResolver2.class.getName());
    private static final CatalogResolver catalogResolver = new CatalogResolver();
    private boolean onlineMode;

    public EnhancedEntityResolver2(boolean onlineMode) {
        this.onlineMode = onlineMode;
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        return null;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return this.resolveEntity(null, publicId, null, systemId);
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        LOG.fine("Entity for resolving " + publicId + " " + systemId);
        InputSource inputSource = catalogResolver.resolveEntity(publicId, systemId);
        if (inputSource != null) {
            LOG.fine("Resolved entity through catalog.");
            return inputSource;
        }
        URL url = baseURI != null ? new URL(new URL(baseURI), systemId) : new URL(systemId);
        LOG.fine("Resolving entity -> " + url.toString());
        if (!this.onlineMode && ValidateXmlHandler.isNetworkUrl(url.toExternalForm())) {
            throw new IOException("XSD Not accessible in offline mode!");
        }
        URLConnection connection = url.openConnection();
        if (!(connection instanceof HttpURLConnection)) {
            return new InputSource(connection.getInputStream());
        }
        HttpURLConnection httpConnection = (HttpURLConnection)connection;
        int status = httpConnection.getResponseCode();
        for (int i = 0; i < 4 && this.isRedirect(status); ++i) {
            String newUrl = httpConnection.getHeaderField("Location");
            httpConnection = (HttpURLConnection)new URL(newUrl).openConnection();
            httpConnection.setConnectTimeout(10000);
            httpConnection.setReadTimeout(10000);
            status = httpConnection.getResponseCode();
        }
        inputSource = new InputSource(httpConnection.getInputStream());
        inputSource.setSystemId(url.toString());
        inputSource.setPublicId(publicId);
        return inputSource;
    }

    private boolean isRedirect(int status) {
        return status != 200 && (status == 302 || status == 301 || status == 303);
    }
}

