/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.utilint.DbLsn;

public class PackedObsoleteInfo
extends TupleOutput {
    public int getMemorySize() {
        return MemoryBudget.tupleOutputSize(this);
    }

    public void copyObsoleteInfo(PackedObsoleteInfo other) {
        this.writeFast(other.getBufferBytes(), other.getBufferOffset(), other.getBufferLength());
    }

    public void addObsoleteInfo(long obsoleteLsn) {
        this.writePackedLong(DbLsn.getFileNumber(obsoleteLsn));
        this.writePackedLong(DbLsn.getFileOffset(obsoleteLsn));
    }

    public void countObsoleteInfo(UtilizationTracker tracker, DatabaseImpl nodeDb) {
        TupleInput in = new TupleInput(this);
        while (in.available() > 0) {
            long fileNumber = in.readPackedLong();
            long fileOffset = in.readPackedLong();
            tracker.countObsoleteNode(DbLsn.makeLsn(fileNumber, fileOffset), LogEntryType.LOG_IN, 0, nodeDb);
        }
    }
}

