/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.service;

import com.syncleus.ferma.FramedGraph;
import com.syncleus.ferma.Traversable;
import java.util.TreeSet;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.attribute.Text;
import org.jboss.forge.furnace.util.Iterators;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.frames.FramedVertexIterable;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.SourceFileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.reporting.model.DefaultTechnologyTagComparator;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.model.TechnologyTagModel;

public class TechnologyTagService
extends GraphService<TechnologyTagModel> {
    public TechnologyTagService(GraphContext context) {
        super(context, TechnologyTagModel.class);
    }

    public TechnologyTagModel addTagToFileModel(FileModel fileModel, String tagName, TechnologyTagLevel level) {
        Traversable q = this.getGraphContext().getQuery(TechnologyTagModel.class).traverse(g -> g.has("name", (Object)tagName));
        return this.getOrCreate((Traversable<Vertex, Vertex>)q, fileModel, tagName, level, null);
    }

    public TechnologyTagModel addTagToFileModel(FileModel fileModel, String tagName, TechnologyTagLevel level, String version) {
        Traversable q = this.getGraphContext().getQuery(TechnologyTagModel.class).traverse(g -> g.has("name", (Object)tagName).has("version", (Object)version));
        return this.getOrCreate((Traversable<Vertex, Vertex>)q, fileModel, tagName, level, version);
    }

    private TechnologyTagModel getOrCreate(Traversable<Vertex, Vertex> q, FileModel fileModel, String tagName, TechnologyTagLevel level, String version) {
        TechnologyTagModel technologyTag = (TechnologyTagModel)super.getUnique((Traversal)q.getRawTraversal());
        if (technologyTag == null) {
            technologyTag = (TechnologyTagModel)this.create();
            technologyTag.setName(tagName);
            technologyTag.setLevel(level);
            technologyTag.setVersion(version);
        }
        if (level == TechnologyTagLevel.IMPORTANT && fileModel instanceof SourceFileModel) {
            ((SourceFileModel)fileModel).setGenerateSourceReport(true);
        }
        technologyTag.addFileModel(fileModel);
        return technologyTag;
    }

    public void removeTagFromFileModel(FileModel fileModel, String tagName) {
        Traversable q = this.getGraphContext().getQuery(TechnologyTagModel.class).traverse(g -> g.has("name", (Object)tagName));
        TechnologyTagModel technologyTag = (TechnologyTagModel)super.getUnique((Traversal)q.getRawTraversal());
        if (technologyTag != null) {
            technologyTag.removeFileModel(fileModel);
        }
    }

    public Iterable<TechnologyTagModel> findTechnologyTagsForFile(FileModel fileModel) {
        GraphTraversal pipeline = new GraphTraversalSource((Graph)this.getGraphContext().getGraph()).V(new Object[]{fileModel.getElement()});
        pipeline.in(new String[]{"techTagToFileModel"}).has("w:winduptype", (Object)"TechnologyTagModel");
        DefaultTechnologyTagComparator comparator = new DefaultTechnologyTagComparator();
        pipeline.order().by((a, b) -> {
            TechnologyTagModel aModel = (TechnologyTagModel)this.getGraphContext().getFramed().frameElement((Element)a, TechnologyTagModel.class);
            TechnologyTagModel bModel = (TechnologyTagModel)this.getGraphContext().getFramed().frameElement((Element)b, TechnologyTagModel.class);
            return comparator.compare(aModel, bModel);
        });
        return new FramedVertexIterable((FramedGraph)this.getGraphContext().getFramed(), (Iterable)pipeline.toList(), TechnologyTagModel.class);
    }

    public Iterable<TechnologyTagModel> findTechnologyTagsForProject(ProjectModelTraversal traversal) {
        TreeSet<TechnologyTagModel> results = new TreeSet<TechnologyTagModel>(new DefaultTechnologyTagComparator());
        GraphTraversal pipeline = new GraphTraversalSource((Graph)this.getGraphContext().getGraph()).V(new Object[]{traversal.getCanonicalProject().getElement()});
        pipeline.out(new String[]{"projectModelToFile"});
        pipeline.in(new String[]{"techTagToFileModel"}).has("w:winduptype", Text.textContains((Object)"TechnologyTagModel"));
        FramedVertexIterable modelIterable = new FramedVertexIterable((FramedGraph)this.getGraphContext().getFramed(), (Iterable)pipeline.toList(), TechnologyTagModel.class);
        results.addAll(Iterators.asSet((Iterable)modelIterable));
        for (ProjectModelTraversal childTraversal : traversal.getChildren()) {
            results.addAll(Iterators.asSet(this.findTechnologyTagsForProject(childTraversal)));
        }
        return results;
    }
}

