/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.service;

import java.util.logging.Logger;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.util.Logging;

public class ApplicationReportService
extends GraphService<ApplicationReportModel> {
    private static final Logger LOG = Logging.get(ApplicationReportService.class);

    public ApplicationReportService(GraphContext context) {
        super(context, ApplicationReportModel.class);
    }

    public ApplicationReportModel create() {
        ApplicationReportModel applicationReportModel = (ApplicationReportModel)super.create();
        applicationReportModel.setDisplayInApplicationReportIndex(false);
        applicationReportModel.setMainApplicationReport(false);
        applicationReportModel.setReportPriority(Integer.MAX_VALUE);
        return applicationReportModel;
    }

    public ApplicationReportModel getMainApplicationReportForFile(FileModel fileModel) {
        ProjectModel rootProjectModel = fileModel.getProjectModel();
        if (rootProjectModel == null) {
            return null;
        }
        rootProjectModel = rootProjectModel.getRootProjectModel();
        GraphTraversal pipe = new GraphTraversalSource((Graph)this.getGraphContext().getGraph()).V(new Object[]{rootProjectModel.getElement()});
        pipe.in(new String[]{"reportToProjectModel"});
        pipe.has("mainApplicationModel", (Object)true);
        ApplicationReportModel mainAppReport = null;
        for (Vertex v : pipe.toList()) {
            ApplicationReportModel appReport = (ApplicationReportModel)this.frame(v);
            if (mainAppReport != null) {
                LOG.warning("There are multiple ApplicationReportModels for a single file " + fileModel.getFilePath() + ". This may cause some brokenlinks in the report file");
            }
            mainAppReport = appReport;
        }
        return mainAppReport;
    }
}

