/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import freemarker.template.DefaultListAdapter;
import freemarker.template.TemplateModelException;
import java.util.Collections;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.rules.CreateApplicationListReportRuleProvider;
import org.jboss.windup.util.ExecutionStatistics;

public class SortApplicationsListMethod
implements WindupFreeMarkerMethod {
    private static final String NAME = "sortApplicationsList";
    private GraphContext context;

    @Override
    public void setContext(GraphRewrite event) {
        this.context = event.getGraphContext();
    }

    public Object exec(List arguments) throws TemplateModelException {
        ExecutionStatistics.get().begin(NAME);
        if (arguments.size() != 1) {
            throw new TemplateModelException("Error, method expects one argument (an Iterable)");
        }
        DefaultListAdapter listModelArg = (DefaultListAdapter)arguments.get(0);
        List list = (List)listModelArg.getWrappedObject();
        Collections.sort(list, new CreateApplicationListReportRuleProvider.AppRootFileNameComparator());
        ExecutionStatistics.get().end(NAME);
        return list;
    }

    @Override
    public String getMethodName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return "Sorts the given list of ApplicationReportModel's by it's root filename or, for VIRTUAL apps, by the name.";
    }
}

