/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultIterableAdapter;
import freemarker.template.DefaultListAdapter;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.Variables;
import org.jboss.windup.config.operation.Iteration;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.reporting.freemarker.FurnaceFreeMarkerTemplateLoader;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerTemplateDirective;
import org.jboss.windup.util.Theme;
import org.jboss.windup.util.ThemeProvider;
import org.jboss.windup.util.exception.WindupException;

public class FreeMarkerUtil {
    public static Configuration getDefaultFreemarkerConfiguration() {
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_26);
        DefaultObjectWrapperBuilder objectWrapperBuilder = new DefaultObjectWrapperBuilder(Configuration.VERSION_2_3_26);
        objectWrapperBuilder.setUseAdaptersForContainers(true);
        objectWrapperBuilder.setIterableSupport(true);
        configuration.setObjectWrapper((ObjectWrapper)objectWrapperBuilder.build());
        configuration.setAPIBuiltinEnabled(true);
        configuration.setTemplateLoader((TemplateLoader)new FurnaceFreeMarkerTemplateLoader());
        configuration.setTemplateUpdateDelayMilliseconds(3600L);
        return configuration;
    }

    public static Set<String> simpleSequenceToSet(SimpleSequence simpleSequence) {
        if (simpleSequence == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < simpleSequence.size(); ++i) {
            try {
                TemplateModel sequenceEntry = simpleSequence.get(i);
                if (sequenceEntry instanceof SimpleScalar) {
                    result.add(((SimpleScalar)sequenceEntry).getAsString());
                    continue;
                }
                result.add(simpleSequence.get(i).toString());
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static Map<String, Object> findFreeMarkerExtensions(Furnace furnace, GraphRewrite event) {
        Theme theme = ThemeProvider.getInstance().getTheme();
        Imported freeMarkerMethods = furnace.getAddonRegistry(new AddonRepository[0]).getServices(WindupFreeMarkerMethod.class);
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (WindupFreeMarkerMethod freeMarkerMethod : freeMarkerMethods) {
            freeMarkerMethod.setContext(event);
            if (results.containsKey(freeMarkerMethod.getMethodName())) {
                throw new WindupException(theme.getBrandNameAcronym() + " contains two freemarker extension providing the same name: " + freeMarkerMethod.getMethodName());
            }
            results.put(freeMarkerMethod.getMethodName(), freeMarkerMethod);
        }
        Imported freeMarkerDirectives = furnace.getAddonRegistry(new AddonRepository[0]).getServices(WindupFreeMarkerTemplateDirective.class);
        for (WindupFreeMarkerTemplateDirective freeMarkerDirective : freeMarkerDirectives) {
            freeMarkerDirective.setContext(event);
            if (results.containsKey(freeMarkerDirective.getDirectiveName())) {
                throw new WindupException(theme.getBrandNameAcronym() + " contains two freemarker extension providing the same name: " + freeMarkerDirective.getDirectiveName());
            }
            results.put(freeMarkerDirective.getDirectiveName(), freeMarkerDirective);
        }
        return results;
    }

    public static Map<String, Object> findFreeMarkerContextVariables(Variables variables, String ... varNames) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (String varName : varNames) {
            WindupVertexFrame payload = null;
            try {
                payload = Iteration.getCurrentPayload((Variables)variables, null, (String)varName);
            }
            catch (IllegalArgumentException | IllegalStateException runtimeException) {
                // empty catch block
            }
            if (payload != null) {
                results.put(varName, payload);
                continue;
            }
            Iterable var = variables.findVariable(varName);
            if (var == null) continue;
            results.put(varName, var);
        }
        return results;
    }

    public static Iterable freemarkerWrapperToIterable(Object object) {
        if (object == null) {
            throw new WindupException("Illegal null passed to freemarkerWrapperToIterable method!");
        }
        if (object instanceof DefaultListAdapter) {
            return (Iterable)((DefaultListAdapter)object).getWrappedObject();
        }
        if (object instanceof DefaultIterableAdapter) {
            return (Iterable)((DefaultIterableAdapter)object).getWrappedObject();
        }
        throw new WindupException("Unrecognized type: " + object.getClass());
    }
}

