/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.container.cdi.lifecycle;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.container.cdi.events.EventManagerImpl;
import org.jboss.forge.furnace.container.cdi.events.EventManagerProducer;
import org.jboss.forge.furnace.container.cdi.events.Local;
import org.jboss.forge.furnace.container.cdi.impl.AddonProducer;
import org.jboss.forge.furnace.container.cdi.impl.AddonRegistryProducer;
import org.jboss.forge.furnace.container.cdi.impl.AddonRepositoryProducer;
import org.jboss.forge.furnace.container.cdi.impl.ContainerBeanRegistrant;
import org.jboss.forge.furnace.container.cdi.impl.ContainerServiceExtension;
import org.jboss.forge.furnace.container.cdi.impl.FurnaceProducer;
import org.jboss.forge.furnace.container.cdi.impl.ServiceRegistryProducer;
import org.jboss.forge.furnace.container.cdi.impl.WeldServiceRegistry;
import org.jboss.forge.furnace.container.cdi.util.BeanManagerUtils;
import org.jboss.forge.furnace.container.cdi.weld.AddonResourceLoader;
import org.jboss.forge.furnace.container.cdi.weld.ModularURLScanner;
import org.jboss.forge.furnace.container.cdi.weld.ModuleScanResult;
import org.jboss.forge.furnace.event.EventManager;
import org.jboss.forge.furnace.event.PostStartup;
import org.jboss.forge.furnace.event.PreShutdown;
import org.jboss.forge.furnace.lifecycle.AddonLifecycleProvider;
import org.jboss.forge.furnace.lifecycle.ControlType;
import org.jboss.forge.furnace.spi.ServiceRegistry;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.resources.spi.ResourceLoader;

public class WeldAddonLifecycleProvider
implements AddonLifecycleProvider {
    private Furnace furnace;
    private AddonRegistry addonRegistry;
    private WeldServiceRegistry serviceRegistry;
    private BeanManager manager;
    private EventManagerImpl eventManager;
    private Addon container;
    private WeldContainer weldContainer;

    public void initialize(Furnace furnace, AddonRegistry registry, Addon container) {
        this.furnace = furnace;
        this.addonRegistry = registry;
        this.container = container;
    }

    public void start(Addon addon) throws Exception {
        AddonResourceLoader resourceLoader = new AddonResourceLoader(addon);
        ModularURLScanner scanner = new ModularURLScanner(resourceLoader, "META-INF/beans.xml");
        ModuleScanResult scanResult = scanner.scan();
        if (scanResult.getDiscoveredResourceUrls().size() > 0) {
            ContainerServiceExtension serviceExtension = new ContainerServiceExtension(this.container, addon);
            ContainerBeanRegistrant registrantExtension = new ContainerBeanRegistrant();
            this.weldContainer = new Weld(addon.getId().getName()).setResourceLoader((ResourceLoader)resourceLoader).addExtension((Extension)serviceExtension).addExtension((Extension)registrantExtension).property(ConfigurationKey.PRELOADER_THREAD_POOL_SIZE.get(), (Object)0).property(ConfigurationKey.CONCURRENT_DEPLOYMENT.get(), (Object)false).initialize();
            this.manager = this.weldContainer.getBeanManager();
            Assert.notNull((Object)this.manager, (String)"BeanManager was null");
            AddonRepositoryProducer repositoryProducer = BeanManagerUtils.getContextualInstance(this.manager, AddonRepositoryProducer.class);
            repositoryProducer.setRepository(addon.getRepository());
            FurnaceProducer forgeProducer = BeanManagerUtils.getContextualInstance(this.manager, FurnaceProducer.class);
            forgeProducer.setFurnace(this.furnace);
            AddonProducer addonProducer = BeanManagerUtils.getContextualInstance(this.manager, AddonProducer.class);
            addonProducer.setAddon(addon);
            AddonRegistryProducer addonRegistryProducer = BeanManagerUtils.getContextualInstance(this.manager, AddonRegistryProducer.class);
            addonRegistryProducer.setRegistry(this.addonRegistry);
            ServiceRegistryProducer serviceRegistryProducer = BeanManagerUtils.getContextualInstance(this.manager, ServiceRegistryProducer.class);
            this.serviceRegistry = new WeldServiceRegistry(this.furnace.getLockManager(), addon, this.manager, serviceExtension.getServices());
            serviceRegistryProducer.setServiceRegistry(this.serviceRegistry);
            Assert.notNull((Object)BeanManagerUtils.getContextualInstance(this.manager, ServiceRegistry.class), (String)"InboundEvent registry was null.");
            EventManagerProducer eventManagerProducer = BeanManagerUtils.getContextualInstance(this.manager, EventManagerProducer.class);
            this.eventManager = new EventManagerImpl(addon, this.manager);
            eventManagerProducer.setEventManager(this.eventManager);
            Assert.notNull((Object)BeanManagerUtils.getContextualInstance(this.manager, EventManager.class), (String)"InboundEvent registry was null.");
        }
    }

    public void postStartup(Addon addon) {
        if (this.eventManager != null) {
            this.eventManager.fireEvent(new PostStartup(addon), new Annotation[]{Local.Literal.INSTANCE});
        }
    }

    public void preShutdown(Addon addon) {
        if (this.eventManager != null) {
            this.eventManager.fireEvent(new PreShutdown(addon), new Annotation[]{Local.Literal.INSTANCE});
        }
    }

    public void stop(Addon addon) {
        if (this.weldContainer != null) {
            this.weldContainer.shutdown();
        }
        this.serviceRegistry.close();
        this.serviceRegistry = null;
        this.eventManager = null;
    }

    public EventManager getEventManager(Addon addon) {
        return this.eventManager;
    }

    public ServiceRegistry getServiceRegistry(Addon addon) {
        return this.serviceRegistry;
    }

    public ControlType getControlType() {
        return ControlType.DEPENDENTS;
    }
}

